function validateNonPrimitive(value) {
    if (value === undefined ||
        value === null ||
        typeof value === 'string' ||
        typeof value === 'number' ||
        typeof value === 'boolean') {
        return false;
    }
    return true;
}
export function validateSplitEntrypointOption(option) {
    if (!validateNonPrimitive(option) || Array.isArray(option)) {
        return false;
    }
    if (!option['app'] || !option['api']) {
        return false;
    }
    return true;
}
