import { GraphQLObjectType, GraphQLInputObjectType, GraphQLInterfaceType } from './graphql';
import type { GraphQLFieldConfig, GraphQLOutputType, GraphQLInputType, GraphQLIsTypeOfFn, GraphQLResolveInfo, GraphQLFieldResolver, FieldDefinitionNode, InputValueDefinitionNode } from './graphql';
import { InputTypeComposer } from './InputTypeComposer';
import type { TypeAsString, TypeDefinitionString } from './TypeMapper';
import { InterfaceTypeComposer, InterfaceTypeComposerDefinition, InterfaceTypeComposerThunked } from './InterfaceTypeComposer';
import { Resolver, ResolverDefinition, ResolverNextRpCb, ResolverWrapCb, ResolverMiddleware } from './Resolver';
import { SchemaComposer } from './SchemaComposer';
import { ListComposer } from './ListComposer';
import { NonNullComposer } from './NonNullComposer';
import { ThunkComposer } from './ThunkComposer';
import type { ToInputTypeOpts } from './utils/toInputType';
import { TypeInPath } from './utils/typeByPath';
import { NamedTypeComposer } from './utils/typeHelpers';
import type { ProjectionType } from './utils/projection';
import type { ObjMap, ThunkWithSchemaComposer, Extensions, Directive, DirectiveArgs } from './utils/definitions';
import type { ComposeNamedInputType, ComposeInputType, ComposeInputTypeDefinition, ComposeOutputTypeDefinition, ComposeOutputType, ComposeNamedOutputType } from './utils/typeHelpers';
import { SchemaPrinterOptions } from './utils/schemaPrinter';
export declare type ObjectTypeComposerDefinition<TSource, TContext> = TypeAsString | TypeDefinitionString | ObjectTypeComposerAsObjectDefinition<TSource, TContext> | Readonly<ObjectTypeComposer<TSource, TContext>> | Readonly<GraphQLObjectType>;
export declare type ObjectTypeComposerAsObjectDefinition<TSource, TContext> = {
    name: string;
    interfaces?: null | ThunkWithSchemaComposer<ReadonlyArray<InterfaceTypeComposerDefinition<any, TContext>>, SchemaComposer<TContext>>;
    fields?: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>;
    isTypeOf?: null | GraphQLIsTypeOfFn<TSource, TContext>;
    description?: string | null;
    isIntrospection?: boolean;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type ObjectTypeComposerFieldConfigMap<TSource, TContext> = ObjMap<ObjectTypeComposerFieldConfig<TSource, TContext>>;
export declare type ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext> = ObjMap<ObjectTypeComposerFieldConfigDefinition<TSource, TContext>>;
export declare type ObjectTypeComposerFieldConfigDefinition<TSource, TContext, TArgs = any> = ThunkWithSchemaComposer<ObjectTypeComposerFieldConfigAsObjectDefinition<TSource, TContext, TArgs>, SchemaComposer<TContext>> | ThunkWithSchemaComposer<ComposeOutputTypeDefinition<TContext>, SchemaComposer<TContext>>;
export declare type ObjectTypeComposerFieldConfigAsObjectDefinition<TSource, TContext, TArgs = any> = {
    type: ThunkWithSchemaComposer<ComposeOutputTypeDefinition<TContext> | Readonly<Resolver<any, TContext, any>>, SchemaComposer<TContext>>;
    args?: ObjectTypeComposerArgumentConfigMapDefinition<TArgs>;
    resolve?: GraphQLFieldResolver<TSource, TContext, TArgs>;
    subscribe?: GraphQLFieldResolver<TSource, TContext>;
    deprecationReason?: string | null;
    description?: string | null;
    extensions?: Extensions | undefined;
    directives?: Directive[];
    [key: string]: any;
};
export declare type ObjectTypeComposerFieldConfig<TSource, TContext, TArgs = any> = {
    type: ComposeOutputType<TContext>;
    args?: ObjectTypeComposerArgumentConfigMap<TArgs>;
    resolve?: GraphQLFieldResolver<TSource, TContext, TArgs>;
    subscribe?: GraphQLFieldResolver<TSource, TContext>;
    deprecationReason?: string | null;
    description?: string | null;
    astNode?: FieldDefinitionNode | null;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: any;
};
export declare type ObjectTypeComposerArgumentConfigMap<TArgs = Record<string, any>> = Record<keyof TArgs, ObjectTypeComposerArgumentConfig>;
export declare type ObjectTypeComposerArgumentConfigMapDefinition<TArgs = Record<string, any>> = Record<keyof TArgs, ObjectTypeComposerArgumentConfigDefinition>;
export declare type ObjectTypeComposerArgumentConfigAsObjectDefinition = {
    type: ThunkWithSchemaComposer<ComposeInputTypeDefinition, SchemaComposer<any>>;
    defaultValue?: any;
    description?: string | null;
    deprecationReason?: string | null;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: any;
};
export declare type ObjectTypeComposerArgumentConfig = {
    type: ComposeInputType;
    defaultValue?: any;
    description?: string | null;
    deprecationReason?: string | null;
    astNode?: InputValueDefinitionNode | null;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: any;
};
export declare type ObjectTypeComposerArgumentConfigDefinition = ObjectTypeComposerArgumentConfigAsObjectDefinition | ThunkWithSchemaComposer<ComposeInputTypeDefinition, SchemaComposer<any>>;
export declare type ObjectTypeComposerRelationMap<TSource, TContext> = {
    [fieldName: string]: ObjectTypeComposerRelationOpts<any, TSource, TContext>;
};
export declare type ObjectTypeComposerRelationOpts<TRelationSource, TSource, TContext, TArgs extends Record<string, any> = any> = ObjectTypeComposerRelationOptsWithResolver<TRelationSource, TSource, TContext, TArgs> | ObjectTypeComposerFieldConfigAsObjectDefinition<TSource, TContext, TArgs>;
export declare type ObjectTypeComposerRelationOptsWithResolver<TRelationSource, TSource, TContext, TArgs extends Record<string, any> = any> = {
    resolver: ThunkWithSchemaComposer<Resolver<TRelationSource, TContext, TArgs>, SchemaComposer<TContext>>;
    prepareArgs?: ObjectTypeComposerRelationArgsMapper<TSource, TContext, TArgs>;
    projection?: ProjectionType;
    description?: string | null;
    deprecationReason?: string | null;
    catchErrors?: boolean;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type ObjectTypeComposerRelationArgsMapperFn<TSource, TContext, TArgs = Record<string, any>> = (source: TSource, args: TArgs, context: TContext, info: GraphQLResolveInfo) => any;
export declare type ObjectTypeComposerRelationArgsMapper<TSource, TContext, TArgs extends Record<string, any> = Record<string, any>> = {
    [argName in keyof TArgs]: {
        [key: string]: any;
    } | ObjectTypeComposerRelationArgsMapperFn<TSource, TContext, TArgs> | null | void | string | number | any[];
};
export declare type ObjectTypeComposerGetRecordIdFn<TSource, TContext, TArgs = any> = (source: TSource, args?: TArgs, context?: TContext) => string;
export declare type ObjectTypeComposerThunked<TReturn, TContext> = ObjectTypeComposer<TReturn, TContext> | ThunkComposer<ObjectTypeComposer<TReturn, TContext>, GraphQLObjectType>;
export declare class ObjectTypeComposer<TSource = any, TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    _gqType: GraphQLObjectType;
    _gqcInputTypeComposer: undefined | InputTypeComposer<TContext>;
    _gqcResolvers: undefined | Map<string, Resolver<TSource, TContext>>;
    _gqcGetRecordIdFn: undefined | ObjectTypeComposerGetRecordIdFn<TSource, TContext>;
    _gqcRelations: undefined | ObjectTypeComposerRelationMap<TSource, TContext>;
    _gqcFields: ObjectTypeComposerFieldConfigMap<TSource, TContext>;
    _gqcInterfaces: Array<InterfaceTypeComposerThunked<TSource, TContext>>;
    _gqcExtensions?: Extensions;
    _gqcDirectives?: Directive[];
    _gqcIsModified?: boolean;
    static create<TSrc = any, TCtx = any>(typeDef: ObjectTypeComposerDefinition<TSrc, TCtx>, schemaComposer: SchemaComposer<TCtx>): ObjectTypeComposer<TSrc, TCtx>;
    static createTemp<TSrc = any, TCtx = any>(typeDef: ObjectTypeComposerDefinition<TSrc, TCtx>, schemaComposer?: SchemaComposer<TCtx>): ObjectTypeComposer<TSrc, TCtx>;
    constructor(graphqlType: GraphQLObjectType, schemaComposer: SchemaComposer<TContext>);
    getFields(): ObjectTypeComposerFieldConfigMap<TSource, TContext>;
    getFieldNames(): string[];
    getField<TArgs = any>(fieldName: string): ObjectTypeComposerFieldConfig<TSource, TContext, TArgs>;
    hasField(fieldName: string): boolean;
    setFields(fields: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>): this;
    setField<TArgs = any>(fieldName: string, fieldConfig: ObjectTypeComposerFieldConfigDefinition<TSource, TContext, TArgs>): this;
    addFields(newFields: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>): this;
    addNestedFields(newFields: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>): this;
    removeField(fieldNameOrArray: string | string[]): this;
    removeOtherFields(fieldNameOrArray: string | string[]): this;
    reorderFields(names: string[]): this;
    extendField<TArgs = any>(fieldName: string, partialFieldConfig: Partial<ObjectTypeComposerFieldConfigAsObjectDefinition<TSource, TContext, TArgs>>): this;
    getFieldConfig(fieldName: string): GraphQLFieldConfig<TSource, TContext>;
    getFieldType(fieldName: string): GraphQLOutputType;
    getFieldTypeName(fieldName: string): string;
    getFieldTC(fieldName: string): ComposeNamedOutputType<TContext>;
    getFieldOTC(fieldName: string): ObjectTypeComposer<TSource, TContext>;
    isFieldNonNull(fieldName: string): boolean;
    makeFieldNonNull(fieldNameOrArray: string | string[]): this;
    makeFieldNullable(fieldNameOrArray: string | string[]): this;
    isFieldPlural(fieldName: string): boolean;
    makeFieldPlural(fieldNameOrArray: string | string[]): this;
    makeFieldNonPlural(fieldNameOrArray: string | string[]): this;
    deprecateFields(fields: {
        [fieldName: string]: string;
    } | string[] | string): this;
    getFieldArgs<TArgs = any>(fieldName: string): ObjectTypeComposerArgumentConfigMap<TArgs>;
    getFieldArgNames(fieldName: string): string[];
    hasFieldArg(fieldName: string, argName: string): boolean;
    getFieldArg(fieldName: string, argName: string): ObjectTypeComposerArgumentConfig;
    getFieldArgType(fieldName: string, argName: string): GraphQLInputType;
    getFieldArgTypeName(fieldName: string, argName: string): string;
    getFieldArgTC(fieldName: string, argName: string): ComposeNamedInputType<TContext>;
    getFieldArgITC(fieldName: string, argName: string): InputTypeComposer<TContext>;
    setFieldArgs(fieldName: string, args: ObjectTypeComposerArgumentConfigMapDefinition<any>): this;
    addFieldArgs(fieldName: string, newArgs: ObjectTypeComposerArgumentConfigMapDefinition<any>): this;
    setFieldArg(fieldName: string, argName: string, argConfig: ObjectTypeComposerArgumentConfigDefinition): this;
    removeFieldArg(fieldName: string, argNameOrArray: string | string[]): this;
    removeFieldOtherArgs(fieldName: string, argNameOrArray: string | string[]): this;
    isFieldArgPlural(fieldName: string, argName: string): boolean;
    makeFieldArgPlural(fieldName: string, argNameOrArray: string | string[]): this;
    makeFieldArgNonPlural(fieldName: string, argNameOrArray: string | string[]): this;
    isFieldArgNonNull(fieldName: string, argName: string): boolean;
    makeFieldArgNonNull(fieldName: string, argNameOrArray: string | string[]): this;
    makeFieldArgNullable(fieldName: string, argNameOrArray: string | string[]): this;
    getType(): GraphQLObjectType;
    getTypePlural(): ListComposer<ObjectTypeComposer<TSource, TContext>>;
    getTypeNonNull(): NonNullComposer<ObjectTypeComposer<TSource, TContext>>;
    get List(): ListComposer<ObjectTypeComposer<TSource, TContext>>;
    get NonNull(): NonNullComposer<ObjectTypeComposer<TSource, TContext>>;
    getTypeName(): string;
    setTypeName(name: string): this;
    getDescription(): string;
    setDescription(description: string): this;
    clone(newTypeNameOrTC: string | ObjectTypeComposer<any, any>): ObjectTypeComposer<TSource, TContext>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): ObjectTypeComposer<any, any>;
    getIsTypeOf(): GraphQLIsTypeOfFn<TSource, TContext> | undefined | null;
    setIsTypeOf(fn: GraphQLIsTypeOfFn<any, any> | null | undefined): this;
    merge(type: GraphQLObjectType | GraphQLInterfaceType | ObjectTypeComposer<any, any> | InterfaceTypeComposer<any, any>): this;
    getInputType(): GraphQLInputObjectType;
    hasInputTypeComposer(): boolean;
    setInputTypeComposer(itc: InputTypeComposer<TContext>): this;
    getInputTypeComposer(opts?: ToInputTypeOpts): InputTypeComposer<TContext>;
    getITC(opts?: ToInputTypeOpts): InputTypeComposer<TContext>;
    removeInputTypeComposer(): this;
    getResolvers(): Map<string, Resolver<any, TContext, any>>;
    hasResolver(name: string): boolean;
    getResolver<TArgs = any>(name: string, middlewares?: Array<ResolverMiddleware<TSource, TContext, TArgs>>): Resolver<any, TContext, TArgs>;
    setResolver(name: string, resolver: Resolver<any, TContext>): this;
    addResolver(opts: Resolver<any, TContext> | ResolverDefinition<any, TContext>): this;
    removeResolver(resolverName: string): this;
    wrapResolver(resolverName: string, cbResolver: ResolverWrapCb<any, TSource, TContext>): this;
    wrapResolverAs(resolverName: string, fromResolverName: string, cbResolver: ResolverWrapCb<any, TSource, TContext>): this;
    wrapResolverResolve(resolverName: string, cbNextRp: ResolverNextRpCb<any, TContext>): this;
    getInterfaces(): Array<InterfaceTypeComposerThunked<TSource, TContext>>;
    getInterfacesTypes(): Array<GraphQLInterfaceType>;
    setInterfaces(interfaces: ReadonlyArray<InterfaceTypeComposerDefinition<any, TContext>>): this;
    hasInterface(iface: InterfaceTypeComposerDefinition<any, TContext>): boolean;
    addInterface(iface: InterfaceTypeComposerDefinition<any, TContext> | InterfaceTypeComposerThunked<any, TContext>): this;
    addInterfaces(ifaces: ReadonlyArray<InterfaceTypeComposerDefinition<any, TContext> | InterfaceTypeComposerThunked<any, TContext>>): this;
    removeInterface(iface: InterfaceTypeComposerDefinition<any, TContext>): this;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions | undefined): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getFieldExtensions(fieldName: string): Extensions;
    setFieldExtensions(fieldName: string, extensions: Extensions): this;
    extendFieldExtensions(fieldName: string, extensions: Extensions): this;
    clearFieldExtensions(fieldName: string): this;
    getFieldExtension(fieldName: string, extensionName: string): unknown;
    hasFieldExtension(fieldName: string, extensionName: string): boolean;
    setFieldExtension(fieldName: string, extensionName: string, value: unknown): this;
    removeFieldExtension(fieldName: string, extensionName: string): this;
    getFieldArgExtensions(fieldName: string, argName: string): Extensions;
    setFieldArgExtensions(fieldName: string, argName: string, extensions: Extensions): this;
    extendFieldArgExtensions(fieldName: string, argName: string, extensions: Extensions): this;
    clearFieldArgExtensions(fieldName: string, argName: string): this;
    getFieldArgExtension(fieldName: string, argName: string, extensionName: string): unknown;
    hasFieldArgExtension(fieldName: string, argName: string, extensionName: string): boolean;
    setFieldArgExtension(fieldName: string, argName: string, extensionName: string, value: unknown): this;
    removeFieldArgExtension(fieldName: string, argName: string, extensionName: string): this;
    getDirectives(): Array<Directive>;
    setDirectives(directives: Array<Directive>): this;
    getDirectiveNames(): string[];
    getDirectiveByName(directiveName: string): DirectiveArgs | undefined;
    setDirectiveByName(directiveName: string, args?: DirectiveArgs): this;
    getDirectiveById(idx: number): DirectiveArgs | undefined;
    getFieldDirectives(fieldName: string): Array<Directive>;
    setFieldDirectives(fieldName: string, directives: Array<Directive> | undefined): this;
    getFieldDirectiveNames(fieldName: string): string[];
    getFieldDirectiveByName(fieldName: string, directiveName: string): DirectiveArgs | undefined;
    setFieldDirectiveByName(fieldName: string, directiveName: string, args?: DirectiveArgs): this;
    getFieldDirectiveById(fieldName: string, idx: number): DirectiveArgs | undefined;
    getFieldArgDirectives(fieldName: string, argName: string): Array<Directive>;
    setFieldArgDirectives(fieldName: string, argName: string, directives: Array<Directive>): this;
    getFieldArgDirectiveNames(fieldName: string, argName: string): string[];
    getFieldArgDirectiveByName(fieldName: string, argName: string, directiveName: string): DirectiveArgs | undefined;
    setFieldArgDirectiveByName(fieldName: string, argName: string, directiveName: string, args?: DirectiveArgs): this;
    getFieldArgDirectiveById(fieldName: string, argName: string, idx: number): DirectiveArgs | undefined;
    addRelation<TArgs extends Record<string, any> = any>(fieldName: string, opts: Readonly<ObjectTypeComposerRelationOpts<any, TSource, TContext, TArgs>>): this;
    getRelations(): ObjectTypeComposerRelationMap<any, TContext>;
    _relationWithResolverToFC(opts: ObjectTypeComposerRelationOptsWithResolver<any, TSource, TContext, any>, fieldName?: string): ObjectTypeComposerFieldConfig<TSource, TContext, any>;
    setRecordIdFn(fn: ObjectTypeComposerGetRecordIdFn<TSource, TContext>): this;
    hasRecordIdFn(): boolean;
    getRecordIdFn(): ObjectTypeComposerGetRecordIdFn<TSource, TContext>;
    getRecordId(source: TSource, args?: Record<string, any>, context?: TContext): string | number;
    get(path: string | string[]): TypeInPath<TContext> | void;
    getNestedTCs(opts?: {
        exclude?: string[];
    }, passedTypes?: Set<NamedTypeComposer<any>>): Set<NamedTypeComposer<any>>;
    toSDL(opts?: SchemaPrinterOptions & {
        deep?: boolean;
        exclude?: string[];
    }): string;
}
//# sourceMappingURL=ObjectTypeComposer.d.ts.map