import fetch from "node-fetch";

export default {
  id: "auth",
  handler: (router, { services }) => {
    router.post("/signup", async (req, res) => {
      const { first_name, last_name, email, password, role } = req.body;

      if (!first_name || !last_name || !email || !password || !role) {
        return res.status(400).json({ error: "Missing required fields" });
      }

      try {
        const authResponse = await fetch("https://citycms.in2apps.xyz/auth/login", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            email: "souheil.jabbour@in2uitions.com",
            password: "Nokia6511@2024",
          }),
        });

        if (!authResponse.ok) {
          const err = await authResponse.text();
          return res
            .status(500)
            .json({ error: "Admin auth failed", details: err });
        }

        const authData = await authResponse.json();
        const adminToken = authData?.data?.access_token;

        if (!adminToken) {
          return res
            .status(500)
            .json({ error: "Failed to retrieve admin token" });
        }

        const createUserResponse = await fetch("https://citycms.in2apps.xyz/users", {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            Authorization: `Bearer ${adminToken}`,
          },
          body: JSON.stringify({
            email,
            password,
            first_name,
            last_name,
            name: `${first_name} ${last_name}`, 
            role, 
            status: "active",
          }),
        });

        if (!createUserResponse.ok) {
          let errorDetails;
          try {
            errorDetails = await createUserResponse.json();
          } catch {
            errorDetails = await createUserResponse.text();
          }

          console.error("User creation failed:", errorDetails);

          return res
            .status(400)
            .json({ error: "User creation failed", details: errorDetails });
        }

        const newUser = await createUserResponse.json();

        return res.status(201).json({
          message: "User created successfully",
          user: {
            id: newUser?.data?.id,
            email: newUser?.data?.email,
          },
        });
      } catch (error) {
        console.error("Signup endpoint error:", error);
        return res.status(500).json({ error: "Internal server error" });
      }
    });
  },
};
