/*! @azure/msal-node v2.13.0 2024-08-13 */
'use strict';
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var msalCommon = require('@azure/msal-common');

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
class ManagedIdentityRequestParameters {
    constructor(httpMethod, endpoint) {
        this.httpMethod = httpMethod;
        this._baseEndpoint = endpoint;
        this.headers = {};
        this.bodyParameters = {};
        this.queryParameters = {};
    }
    computeUri() {
        const parameterBuilder = new msalCommon.RequestParameterBuilder();
        if (this.queryParameters) {
            parameterBuilder.addExtraQueryParameters(this.queryParameters);
        }
        const queryParametersString = parameterBuilder.createQueryString();
        return msalCommon.UrlString.appendQueryString(this._baseEndpoint, queryParametersString);
    }
    computeParametersBodyString() {
        const parameterBuilder = new msalCommon.RequestParameterBuilder();
        if (this.bodyParameters) {
            parameterBuilder.addExtraQueryParameters(this.bodyParameters);
        }
        return parameterBuilder.createQueryString();
    }
}

exports.ManagedIdentityRequestParameters = ManagedIdentityRequestParameters;
//# sourceMappingURL=ManagedIdentityRequestParameters.cjs.map
