import { SchemaHelper } from '../types.js';
import { useEnv } from '@directus/env';
import { preprocessBindings } from '../utils/preprocess-bindings.js';
const env = useEnv();
export class SchemaHelperCockroachDb extends SchemaHelper {
    async changeToType(table, column, type, options = {}) {
        await this.changeToTypeByCopy(table, column, type, options);
    }
    constraintName(existingName) {
        const suffix = '_replaced';
        // CockroachDB does not allow for dropping/creating constraints with the same
        // name in a single transaction. reference issue #14873
        if (existingName.endsWith(suffix)) {
            return existingName.substring(0, existingName.length - suffix.length);
        }
        else {
            return existingName + suffix;
        }
    }
    async getDatabaseSize() {
        try {
            const result = await this.knex
                .select(this.knex.raw('round(SUM(range_size_mb) * 1024 * 1024, 0) AS size'))
                .from(this.knex.raw('[SHOW RANGES FROM database ??]', [env['DB_DATABASE']]));
            return result[0]?.['size'] ? Number(result[0]?.['size']) : null;
        }
        catch {
            return null;
        }
    }
    preprocessBindings(queryParams) {
        return preprocessBindings(queryParams, { format: (index) => `$${index + 1}` });
    }
}
