import { SchemaHelper } from '../types.js';
import { preprocessBindings } from '../utils/preprocess-bindings.js';
export class SchemaHelperMSSQL extends SchemaHelper {
    applyLimit(rootQuery, limit) {
        // The ORDER BY clause is invalid in views, inline functions, derived tables, subqueries,
        // and common table expressions, unless TOP, OFFSET or FOR XML is also specified.
        if (limit === -1) {
            rootQuery.limit(Number.MAX_SAFE_INTEGER);
        }
        else {
            rootQuery.limit(limit);
        }
    }
    applyOffset(rootQuery, offset) {
        rootQuery.offset(offset);
        rootQuery.orderBy(1);
    }
    formatUUID(uuid) {
        return uuid.toUpperCase();
    }
    async getDatabaseSize() {
        try {
            const result = await this.knex.raw('SELECT SUM(size) * 8192 AS size FROM sys.database_files;');
            return result[0]?.['size'] ? Number(result[0]?.['size']) : null;
        }
        catch {
            return null;
        }
    }
    preprocessBindings(queryParams) {
        return preprocessBindings(queryParams, { format: (index) => `@p${index}` });
    }
}
