import { parseFilter, parsePreset } from '@directus/utils';
export function processPermissions({ permissions, accountability, permissionsContext }) {
    return permissions.map((permission) => {
        permission.permissions = parseFilter(permission.permissions, accountability, permissionsContext);
        permission.validation = parseFilter(permission.validation, accountability, permissionsContext);
        permission.presets = parsePreset(permission.presets, accountability, permissionsContext);
        return permission;
    });
}
