import { resolveScriptKey, useScript as useScript$1 } from 'unhead';
export { CapoPlugin, HashHydrationPlugin, createHeadCore } from 'unhead';
import { V as Vue3, h as headSymbol, i as injectHead } from './shared/vue.40986ab9.mjs';
export { c as createHead, a as createServerHead, r as resolveUnrefHeadInput, s as setHeadInjectionHandler } from './shared/vue.40986ab9.mjs';
import { getCurrentInstance, onMounted, ref, onScopeDispose } from 'vue';
import { u as useHead } from './shared/vue.65b7bcda.mjs';
import { composableNames, whitelistSafeInput, unpackMeta } from '@unhead/shared';

const VueHeadMixin = {
  created() {
    let source = false;
    if (Vue3) {
      const instance = getCurrentInstance();
      if (!instance)
        return;
      const options = instance.type;
      if (!options || !("head" in options))
        return;
      source = typeof options.head === "function" ? () => options.head.call(instance.proxy) : options.head;
    } else {
      const head = this.$options.head;
      if (head) {
        source = typeof head === "function" ? () => head.call(this) : head;
      }
    }
    source && useHead(source);
  }
};

const Vue2ProvideUnheadPlugin = (_Vue, head) => {
  _Vue.mixin({
    beforeCreate() {
      const options = this.$options;
      const origProvide = options.provide;
      options.provide = function() {
        let origProvideResult;
        if (typeof origProvide === "function")
          origProvideResult = origProvide.call(this);
        else
          origProvideResult = origProvide || {};
        return {
          ...origProvideResult,
          [headSymbol]: head
        };
      };
    }
  });
};

const coreComposableNames = [
  "injectHead"
];
const unheadVueComposablesImports = {
  "@unhead/vue": [...coreComposableNames, ...composableNames]
};

function useHeadSafe(input, options = {}) {
  return useHead(input, { ...options, transform: whitelistSafeInput });
}

function useSeoMeta(input, options) {
  const { title, titleTemplate, ...meta } = input;
  return useHead({
    title,
    titleTemplate,
    // @ts-expect-error runtime type
    _flatMeta: meta
  }, {
    ...options,
    transform(t) {
      const meta2 = unpackMeta({ ...t._flatMeta });
      delete t._flatMeta;
      return {
        // @ts-expect-error runtime type
        ...t,
        meta: meta2
      };
    }
  });
}

function useServerHead(input, options = {}) {
  const head = options.head || injectHead();
  delete options.head;
  if (head)
    return head.push(input, { ...options, mode: "server" });
}

function useServerHeadSafe(input, options = {}) {
  return useHeadSafe(input, { ...options, mode: "server" });
}

function useServerSeoMeta(input, options) {
  return useSeoMeta(input, { ...options, mode: "server" });
}

function useScript(_input, _options) {
  const input = typeof _input === "string" ? { src: _input } : _input;
  const head = injectHead();
  const options = _options || {};
  options.head = head;
  options.eventContext = getCurrentInstance();
  const scope = getCurrentInstance();
  if (scope && !options.trigger)
    options.trigger = onMounted;
  const key = resolveScriptKey(input);
  if (head._scripts?.[key])
    return head._scripts[key];
  let script;
  const status = ref("awaitingLoad");
  const _ = head.hooks.hook("script:updated", ({ script: s }) => {
    if (script && s.id === script.id) {
      status.value = s.status;
      if (s.status === "removed") {
        _();
      }
    }
  });
  script = useScript$1(input, options);
  if (scope) {
    const _registerCb = (key2, cb) => {
      if (!script._cbs[key2]) {
        cb(script.instance);
        return () => {
        };
      }
      let i = script._cbs[key2].push(cb);
      const destroy = () => {
        if (i) {
          script._cbs[key2]?.splice(i - 1, 1);
          i = null;
        }
      };
      onScopeDispose(destroy);
      return destroy;
    };
    script.onLoaded = (cb) => _registerCb("loaded", cb);
    script.onError = (cb) => _registerCb("error", cb);
  }
  return new Proxy(script, {
    get(_2, key2, a) {
      if (key2 === "status")
        return status;
      return Reflect.get(_2, key2, a);
    }
  });
}

export { Vue2ProvideUnheadPlugin, VueHeadMixin, injectHead, unheadVueComposablesImports, useHead, useHeadSafe, useScript, useSeoMeta, useServerHead, useServerHeadSafe, useServerSeoMeta };
