/*! @azure/msal-browser v3.26.1 2024-10-08 */
"use strict";!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).msal={})}(this,(function(e){
/*! @azure/msal-common v14.15.0 2024-10-08 */
const t={LIBRARY_NAME:"MSAL.JS",SKU:"msal.js.common",CACHE_PREFIX:"msal",DEFAULT_AUTHORITY:"https://login.microsoftonline.com/common/",DEFAULT_AUTHORITY_HOST:"login.microsoftonline.com",DEFAULT_COMMON_TENANT:"common",ADFS:"adfs",DSTS:"dstsv2",AAD_INSTANCE_DISCOVERY_ENDPT:"https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",CIAM_AUTH_URL:".ciamlogin.com",AAD_TENANT_DOMAIN_SUFFIX:".onmicrosoft.com",RESOURCE_DELIM:"|",NO_ACCOUNT:"NO_ACCOUNT",CLAIMS:"claims",CONSUMER_UTID:"9188040d-6c67-4c5b-b112-36a304b66dad",OPENID_SCOPE:"openid",PROFILE_SCOPE:"profile",OFFLINE_ACCESS_SCOPE:"offline_access",EMAIL_SCOPE:"email",CODE_RESPONSE_TYPE:"code",CODE_GRANT_TYPE:"authorization_code",RT_GRANT_TYPE:"refresh_token",FRAGMENT_RESPONSE_MODE:"fragment",S256_CODE_CHALLENGE_METHOD:"S256",URL_FORM_CONTENT_TYPE:"application/x-www-form-urlencoded;charset=utf-8",AUTHORIZATION_PENDING:"authorization_pending",NOT_DEFINED:"not_defined",EMPTY_STRING:"",NOT_APPLICABLE:"N/A",NOT_AVAILABLE:"Not Available",FORWARD_SLASH:"/",IMDS_ENDPOINT:"http://169.254.169.254/metadata/instance/compute/location",IMDS_VERSION:"2020-06-01",IMDS_TIMEOUT:2e3,AZURE_REGION_AUTO_DISCOVER_FLAG:"TryAutoDetect",REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX:"login.microsoft.com",KNOWN_PUBLIC_CLOUDS:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"],TOKEN_RESPONSE_TYPE:"token",ID_TOKEN_RESPONSE_TYPE:"id_token",SHR_NONCE_VALIDITY:240,INVALID_INSTANCE:"invalid_instance"},r=400,n=499,o=500,i=599,a=[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE],s=[...a,t.EMAIL_SCOPE],c="Content-Type",l="Retry-After",h="X-AnchorMailbox",d="WWW-Authenticate",u="Authentication-Info",g="x-ms-request-id",p="x-ms-httpver",m="idtoken",f="client.info",C="adal.idtoken",y="error",v="error.description",T="active-account",I="active-account-filters",A="common",w="organizations",k="consumers",S="access_token",E="xms_cc",R={LOGIN:"login",SELECT_ACCOUNT:"select_account",CONSENT:"consent",NONE:"none",CREATE:"create",NO_SESSION:"no_session"},b={PLAIN:"plain",S256:"S256"},_={QUERY:"query",FRAGMENT:"fragment"},P={..._,FORM_POST:"form_post"},M="authorization_code",N="refresh_token",O="MSSTS",q="ADFS",L="Generic",U={CACHE_KEY_SEPARATOR:"-",CLIENT_INFO_SEPARATOR:"."},H={ID_TOKEN:"IdToken",ACCESS_TOKEN:"AccessToken",ACCESS_TOKEN_WITH_AUTH_SCHEME:"AccessToken_With_AuthScheme",REFRESH_TOKEN:"RefreshToken"},B="appmetadata",x="1",D="authority-metadata",F=86400,K="config",z="cache",G="network",$="hardcoded_values",Q={SCHEMA_VERSION:5,MAX_CUR_HEADER_BYTES:80,MAX_LAST_HEADER_BYTES:330,MAX_CACHED_ERRORS:50,CACHE_KEY:"server-telemetry",CATEGORY_SEPARATOR:"|",VALUE_SEPARATOR:",",OVERFLOW_TRUE:"1",OVERFLOW_FALSE:"0",UNKNOWN_ERROR:"unknown_error"},W={BEARER:"Bearer",POP:"pop",SSH:"ssh-cert"},j=60,V=3600,Y="throttling",J="retry-after, h429",X="invalid_grant",Z="client_mismatch",ee="username",te="password",re=200,ne=400,oe="1",ie="3",ae="4",se="2",ce="4",le="5",he="0",de="1",ue="2",ge="3",pe="4",me={Jwt:"JWT",Jwk:"JWK",Pop:"pop"},fe="unexpected_error",Ce="post_request_failed";var ye=Object.freeze({__proto__:null,postRequestFailed:Ce,unexpectedError:fe});
/*! @azure/msal-common v14.15.0 2024-10-08 */const ve={[fe]:"Unexpected error in authentication.",[Ce]:"Post request failed from the network, could be a 4xx/5xx or a network unavailability. Please check the exact error code for details."},Te={unexpectedError:{code:fe,desc:ve[fe]},postRequestFailed:{code:Ce,desc:ve[Ce]}};class Ie extends Error{constructor(e,r,n){super(r?`${e}: ${r}`:e),Object.setPrototypeOf(this,Ie.prototype),this.errorCode=e||t.EMPTY_STRING,this.errorMessage=r||t.EMPTY_STRING,this.subError=n||t.EMPTY_STRING,this.name="AuthError"}setCorrelationId(e){this.correlationId=e}}function Ae(e,t){return new Ie(e,t?`${ve[e]} ${t}`:ve[e])}
/*! @azure/msal-common v14.15.0 2024-10-08 */const we="client_info_decoding_error",ke="client_info_empty_error",Se="token_parsing_error",Ee="null_or_empty_token",Re="endpoints_resolution_error",be="network_error",_e="openid_config_error",Pe="hash_not_deserialized",Me="invalid_state",Ne="state_mismatch",Oe="state_not_found",qe="nonce_mismatch",Le="auth_time_not_found",Ue="max_age_transpired",He="multiple_matching_tokens",Be="multiple_matching_accounts",xe="multiple_matching_appMetadata",De="request_cannot_be_made",Fe="cannot_remove_empty_scope",Ke="cannot_append_scopeset",ze="empty_input_scopeset",Ge="device_code_polling_cancelled",$e="device_code_expired",Qe="device_code_unknown_error",We="no_account_in_silent_request",je="invalid_cache_record",Ve="invalid_cache_environment",Ye="no_account_found",Je="no_crypto_object",Xe="unexpected_credential_type",Ze="invalid_assertion",et="invalid_client_credential",tt="token_refresh_required",rt="user_timeout_reached",nt="token_claims_cnf_required_for_signedjwt",ot="authorization_code_missing_from_server_response",it="binding_key_not_removed",at="end_session_endpoint_not_supported",st="key_id_missing",ct="no_network_connectivity",lt="user_canceled",ht="missing_tenant_id_error",dt="method_not_implemented",ut="nested_app_auth_bridge_disabled";var gt=Object.freeze({__proto__:null,authTimeNotFound:Le,authorizationCodeMissingFromServerResponse:ot,bindingKeyNotRemoved:it,cannotAppendScopeSet:Ke,cannotRemoveEmptyScope:Fe,clientInfoDecodingError:we,clientInfoEmptyError:ke,deviceCodeExpired:$e,deviceCodePollingCancelled:Ge,deviceCodeUnknownError:Qe,emptyInputScopeSet:ze,endSessionEndpointNotSupported:at,endpointResolutionError:Re,hashNotDeserialized:Pe,invalidAssertion:Ze,invalidCacheEnvironment:Ve,invalidCacheRecord:je,invalidClientCredential:et,invalidState:Me,keyIdMissing:st,maxAgeTranspired:Ue,methodNotImplemented:dt,missingTenantIdError:ht,multipleMatchingAccounts:Be,multipleMatchingAppMetadata:xe,multipleMatchingTokens:He,nestedAppAuthBridgeDisabled:ut,networkError:be,noAccountFound:Ye,noAccountInSilentRequest:We,noCryptoObject:Je,noNetworkConnectivity:ct,nonceMismatch:qe,nullOrEmptyToken:Ee,openIdConfigError:_e,requestCannotBeMade:De,stateMismatch:Ne,stateNotFound:Oe,tokenClaimsCnfRequiredForSignedJwt:nt,tokenParsingError:Se,tokenRefreshRequired:tt,unexpectedCredentialType:Xe,userCanceled:lt,userTimeoutReached:rt});
/*! @azure/msal-common v14.15.0 2024-10-08 */const pt={[we]:"The client info could not be parsed/decoded correctly",[ke]:"The client info was empty",[Se]:"Token cannot be parsed",[Ee]:"The token is null or empty",[Re]:"Endpoints cannot be resolved",[be]:"Network request failed",[_e]:"Could not retrieve endpoints. Check your authority and verify the .well-known/openid-configuration endpoint returns the required endpoints.",[Pe]:"The hash parameters could not be deserialized",[Me]:"State was not the expected format",[Ne]:"State mismatch error",[Oe]:"State not found",[qe]:"Nonce mismatch error",[Le]:"Max Age was requested and the ID token is missing the auth_time variable. auth_time is an optional claim and is not enabled by default - it must be enabled. See https://aka.ms/msaljs/optional-claims for more information.",[Ue]:"Max Age is set to 0, or too much time has elapsed since the last end-user authentication.",[He]:"The cache contains multiple tokens satisfying the requirements. Call AcquireToken again providing more requirements such as authority or account.",[Be]:"The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account",[xe]:"The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata",[De]:"Token request cannot be made without authorization code or refresh token.",[Fe]:"Cannot remove null or empty scope from ScopeSet",[Ke]:"Cannot append ScopeSet",[ze]:"Empty input ScopeSet cannot be processed",[Ge]:"Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true.",[$e]:"Device code is expired.",[Qe]:"Device code stopped polling for unknown reasons.",[We]:"Please pass an account object, silent flow is not supported without account information",[je]:"Cache record object was null or undefined.",[Ve]:"Invalid environment when attempting to create cache entry",[Ye]:"No account found in cache for given key.",[Je]:"No crypto object detected.",[Xe]:"Unexpected credential type.",[Ze]:"Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515",[et]:"Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential",[tt]:"Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired.",[rt]:"User defined timeout for device code polling reached",[nt]:"Cannot generate a POP jwt if the token_claims are not populated",[ot]:"Server response does not contain an authorization code to proceed",[it]:"Could not remove the credential's binding key from storage.",[at]:"The provided authority does not support logout",[st]:"A keyId value is missing from the requested bound token's cache record and is required to match the token to it's stored binding key.",[ct]:"No network connectivity. Check your internet connection.",[lt]:"User cancelled the flow.",[ht]:"A tenant id - not common, organizations, or consumers - must be specified when using the client_credentials flow.",[dt]:"This method has not been implemented",[ut]:"The nested app auth bridge is disabled"},mt={clientInfoDecodingError:{code:we,desc:pt[we]},clientInfoEmptyError:{code:ke,desc:pt[ke]},tokenParsingError:{code:Se,desc:pt[Se]},nullOrEmptyToken:{code:Ee,desc:pt[Ee]},endpointResolutionError:{code:Re,desc:pt[Re]},networkError:{code:be,desc:pt[be]},unableToGetOpenidConfigError:{code:_e,desc:pt[_e]},hashNotDeserialized:{code:Pe,desc:pt[Pe]},invalidStateError:{code:Me,desc:pt[Me]},stateMismatchError:{code:Ne,desc:pt[Ne]},stateNotFoundError:{code:Oe,desc:pt[Oe]},nonceMismatchError:{code:qe,desc:pt[qe]},authTimeNotFoundError:{code:Le,desc:pt[Le]},maxAgeTranspired:{code:Ue,desc:pt[Ue]},multipleMatchingTokens:{code:He,desc:pt[He]},multipleMatchingAccounts:{code:Be,desc:pt[Be]},multipleMatchingAppMetadata:{code:xe,desc:pt[xe]},tokenRequestCannotBeMade:{code:De,desc:pt[De]},removeEmptyScopeError:{code:Fe,desc:pt[Fe]},appendScopeSetError:{code:Ke,desc:pt[Ke]},emptyInputScopeSetError:{code:ze,desc:pt[ze]},DeviceCodePollingCancelled:{code:Ge,desc:pt[Ge]},DeviceCodeExpired:{code:$e,desc:pt[$e]},DeviceCodeUnknownError:{code:Qe,desc:pt[Qe]},NoAccountInSilentRequest:{code:We,desc:pt[We]},invalidCacheRecord:{code:je,desc:pt[je]},invalidCacheEnvironment:{code:Ve,desc:pt[Ve]},noAccountFound:{code:Ye,desc:pt[Ye]},noCryptoObj:{code:Je,desc:pt[Je]},unexpectedCredentialType:{code:Xe,desc:pt[Xe]},invalidAssertion:{code:Ze,desc:pt[Ze]},invalidClientCredential:{code:et,desc:pt[et]},tokenRefreshRequired:{code:tt,desc:pt[tt]},userTimeoutReached:{code:rt,desc:pt[rt]},tokenClaimsRequired:{code:nt,desc:pt[nt]},noAuthorizationCodeFromServer:{code:ot,desc:pt[ot]},bindingKeyNotRemovedError:{code:it,desc:pt[it]},logoutNotSupported:{code:at,desc:pt[at]},keyIdMissing:{code:st,desc:pt[st]},noNetworkConnectivity:{code:ct,desc:pt[ct]},userCanceledError:{code:lt,desc:pt[lt]},missingTenantIdError:{code:ht,desc:pt[ht]},nestedAppAuthBridgeDisabled:{code:ut,desc:pt[ut]}};class ft extends Ie{constructor(e,t){super(e,t?`${pt[e]}: ${t}`:pt[e]),this.name="ClientAuthError",Object.setPrototypeOf(this,ft.prototype)}}function Ct(e,t){return new ft(e,t)}
/*! @azure/msal-common v14.15.0 2024-10-08 */const yt={createNewGuid:()=>{throw Ct(dt)},base64Decode:()=>{throw Ct(dt)},base64Encode:()=>{throw Ct(dt)},base64UrlEncode:()=>{throw Ct(dt)},encodeKid:()=>{throw Ct(dt)},async getPublicKeyThumbprint(){throw Ct(dt)},async removeTokenBindingKey(){throw Ct(dt)},async clearKeystore(){throw Ct(dt)},async signJwt(){throw Ct(dt)},async hashString(){throw Ct(dt)}};
/*! @azure/msal-common v14.15.0 2024-10-08 */var vt;e.LogLevel=void 0,(vt=e.LogLevel||(e.LogLevel={}))[vt.Error=0]="Error",vt[vt.Warning=1]="Warning",vt[vt.Info=2]="Info",vt[vt.Verbose=3]="Verbose",vt[vt.Trace=4]="Trace";class Tt{constructor(r,n,o){this.level=e.LogLevel.Info;const i=r||Tt.createDefaultLoggerOptions();this.localCallback=i.loggerCallback||(()=>{}),this.piiLoggingEnabled=i.piiLoggingEnabled||!1,this.level="number"==typeof i.logLevel?i.logLevel:e.LogLevel.Info,this.correlationId=i.correlationId||t.EMPTY_STRING,this.packageName=n||t.EMPTY_STRING,this.packageVersion=o||t.EMPTY_STRING}static createDefaultLoggerOptions(){return{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info}}clone(e,t,r){return new Tt({loggerCallback:this.localCallback,piiLoggingEnabled:this.piiLoggingEnabled,logLevel:this.level,correlationId:r||this.correlationId},e,t)}logMessage(t,r){if(r.logLevel>this.level||!this.piiLoggingEnabled&&r.containsPii)return;const n=`${`[${(new Date).toUTCString()}] : [${r.correlationId||this.correlationId||""}]`} : ${this.packageName}@${this.packageVersion} : ${e.LogLevel[r.logLevel]} - ${t}`;this.executeCallback(r.logLevel,n,r.containsPii||!1)}executeCallback(e,t,r){this.localCallback&&this.localCallback(e,t,r)}error(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!1,correlationId:n||t.EMPTY_STRING})}errorPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!0,correlationId:n||t.EMPTY_STRING})}warning(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!1,correlationId:n||t.EMPTY_STRING})}warningPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!0,correlationId:n||t.EMPTY_STRING})}info(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!1,correlationId:n||t.EMPTY_STRING})}infoPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!0,correlationId:n||t.EMPTY_STRING})}verbose(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!1,correlationId:n||t.EMPTY_STRING})}verbosePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!0,correlationId:n||t.EMPTY_STRING})}trace(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!1,correlationId:n||t.EMPTY_STRING})}tracePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!0,correlationId:n||t.EMPTY_STRING})}isPiiLoggingEnabled(){return this.piiLoggingEnabled||!1}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const It="@azure/msal-common",At="14.15.0",wt={None:"none",AzurePublic:"https://login.microsoftonline.com",AzurePpe:"https://login.windows-ppe.net",AzureChina:"https://login.chinacloudapi.cn",AzureGermany:"https://login.microsoftonline.de",AzureUsGovernment:"https://login.microsoftonline.us"};
/*! @azure/msal-common v14.15.0 2024-10-08 */
function kt(e,t){const r=function(e){if(!e)throw Ct(Ee);const t=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(e);if(!t||t.length<4)throw Ct(Se);return t[2]}(e);try{const e=t(r);return JSON.parse(e)}catch(e){throw Ct(Se)}}function St(e,t){if(0===t||Date.now()-3e5>e+t)throw Ct(Ue)}
/*! @azure/msal-common v14.15.0 2024-10-08 */function Et(){return Math.round((new Date).getTime()/1e3)}function Rt(e,t){const r=Number(e)||0;return Et()+t>r}function bt(e){return Number(e)>Et()}
/*! @azure/msal-common v14.15.0 2024-10-08 */function _t(e){return[Ht(e),Bt(e),xt(e),Dt(e),Ft(e)].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function Pt(e,t,r,n,o){return{credentialType:H.ID_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r,realm:o}}function Mt(e,t,r,n,o,i,a,s,c,l,h,d,u,g,p){const m={homeAccountId:e,credentialType:H.ACCESS_TOKEN,secret:r,cachedAt:Et().toString(),expiresOn:a.toString(),extendedExpiresOn:s.toString(),environment:t,clientId:n,realm:o,target:i,tokenType:h||W.BEARER};if(d&&(m.userAssertionHash=d),l&&(m.refreshOn=l.toString()),g&&(m.requestedClaims=g,m.requestedClaimsHash=p),m.tokenType?.toLowerCase()!==W.BEARER.toLowerCase())switch(m.credentialType=H.ACCESS_TOKEN_WITH_AUTH_SCHEME,m.tokenType){case W.POP:const e=kt(r,c);if(!e?.cnf?.kid)throw Ct(nt);m.keyId=e.cnf.kid;break;case W.SSH:m.keyId=u}return m}function Nt(e,t,r,n,o,i,a){const s={credentialType:H.REFRESH_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r};return i&&(s.userAssertionHash=i),o&&(s.familyId=o),a&&(s.expiresOn=a.toString()),s}function Ot(e){return e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("credentialType")&&e.hasOwnProperty("clientId")&&e.hasOwnProperty("secret")}function qt(e){return!!e&&(Ot(e)&&e.hasOwnProperty("realm")&&e.hasOwnProperty("target")&&(e.credentialType===H.ACCESS_TOKEN||e.credentialType===H.ACCESS_TOKEN_WITH_AUTH_SCHEME))}function Lt(e){return!!e&&(Ot(e)&&e.hasOwnProperty("realm")&&e.credentialType===H.ID_TOKEN)}function Ut(e){return!!e&&(Ot(e)&&e.credentialType===H.REFRESH_TOKEN)}function Ht(e){return[e.homeAccountId,e.environment].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function Bt(e){const t=e.credentialType===H.REFRESH_TOKEN&&e.familyId||e.clientId;return[e.credentialType,t,e.realm||""].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function xt(e){return(e.target||"").toLowerCase()}function Dt(e){return(e.requestedClaimsHash||"").toLowerCase()}function Ft(e){return e.tokenType&&e.tokenType.toLowerCase()!==W.BEARER.toLowerCase()?e.tokenType.toLowerCase():""}function Kt(){return Et()+F}function zt(e,t,r){e.authorization_endpoint=t.authorization_endpoint,e.token_endpoint=t.token_endpoint,e.end_session_endpoint=t.end_session_endpoint,e.issuer=t.issuer,e.endpointsFromNetwork=r,e.jwks_uri=t.jwks_uri}function Gt(e,t,r){e.aliases=t.aliases,e.preferred_cache=t.preferred_cache,e.preferred_network=t.preferred_network,e.aliasesFromNetwork=r}function $t(e){return e.expiresAt<=Et()}
/*! @azure/msal-common v14.15.0 2024-10-08 */const Qt="redirect_uri_empty",Wt="claims_request_parsing_error",jt="authority_uri_insecure",Vt="url_parse_error",Yt="empty_url_error",Jt="empty_input_scopes_error",Xt="invalid_prompt_value",Zt="invalid_claims",er="token_request_empty",tr="logout_request_empty",rr="invalid_code_challenge_method",nr="pkce_params_missing",or="invalid_cloud_discovery_metadata",ir="invalid_authority_metadata",ar="untrusted_authority",sr="missing_ssh_jwk",cr="missing_ssh_kid",lr="missing_nonce_authentication_header",hr="invalid_authentication_header",dr="cannot_set_OIDCOptions",ur="cannot_allow_native_broker",gr="authority_mismatch";var pr=Object.freeze({__proto__:null,authorityMismatch:gr,authorityUriInsecure:jt,cannotAllowNativeBroker:ur,cannotSetOIDCOptions:dr,claimsRequestParsingError:Wt,emptyInputScopesError:Jt,invalidAuthenticationHeader:hr,invalidAuthorityMetadata:ir,invalidClaims:Zt,invalidCloudDiscoveryMetadata:or,invalidCodeChallengeMethod:rr,invalidPromptValue:Xt,logoutRequestEmpty:tr,missingNonceAuthenticationHeader:lr,missingSshJwk:sr,missingSshKid:cr,pkceParamsMissing:nr,redirectUriEmpty:Qt,tokenRequestEmpty:er,untrustedAuthority:ar,urlEmptyError:Yt,urlParseError:Vt});
/*! @azure/msal-common v14.15.0 2024-10-08 */const mr={[Qt]:"A redirect URI is required for all calls, and none has been set.",[Wt]:"Could not parse the given claims request object.",[jt]:"Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",[Vt]:"URL could not be parsed into appropriate segments.",[Yt]:"URL was empty or null.",[Jt]:"Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token.",[Xt]:"Please see here for valid configuration options: https://azuread.github.io/microsoft-authentication-library-for-js/ref/modules/_azure_msal_common.html#commonauthorizationurlrequest",[Zt]:"Given claims parameter must be a stringified JSON object.",[er]:"Token request was empty and not found in cache.",[tr]:"The logout request was null or undefined.",[rr]:'code_challenge_method passed is invalid. Valid values are "plain" and "S256".',[nr]:"Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request",[or]:"Invalid cloudDiscoveryMetadata provided. Must be a stringified JSON object containing tenant_discovery_endpoint and metadata fields",[ir]:"Invalid authorityMetadata provided. Must by a stringified JSON object containing authorization_endpoint, token_endpoint, issuer fields.",[ar]:"The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter.",[sr]:"Missing sshJwk in SSH certificate request. A stringified JSON Web Key is required when using the SSH authentication scheme.",[cr]:"Missing sshKid in SSH certificate request. A string that uniquely identifies the public SSH key is required when using the SSH authentication scheme.",[lr]:"Unable to find an authentication header containing server nonce. Either the Authentication-Info or WWW-Authenticate headers must be present in order to obtain a server nonce.",[hr]:"Invalid authentication header provided",[dr]:"Cannot set OIDCOptions parameter. Please change the protocol mode to OIDC or use a non-Microsoft authority.",[ur]:"Cannot set allowNativeBroker parameter to true when not in AAD protocol mode.",[gr]:"Authority mismatch error. Authority provided in login request or PublicClientApplication config does not match the environment of the provided account. Please use a matching account or make an interactive request to login to this authority."},fr={redirectUriNotSet:{code:Qt,desc:mr[Qt]},claimsRequestParsingError:{code:Wt,desc:mr[Wt]},authorityUriInsecure:{code:jt,desc:mr[jt]},urlParseError:{code:Vt,desc:mr[Vt]},urlEmptyError:{code:Yt,desc:mr[Yt]},emptyScopesError:{code:Jt,desc:mr[Jt]},invalidPrompt:{code:Xt,desc:mr[Xt]},invalidClaimsRequest:{code:Zt,desc:mr[Zt]},tokenRequestEmptyError:{code:er,desc:mr[er]},logoutRequestEmptyError:{code:tr,desc:mr[tr]},invalidCodeChallengeMethod:{code:rr,desc:mr[rr]},invalidCodeChallengeParams:{code:nr,desc:mr[nr]},invalidCloudDiscoveryMetadata:{code:or,desc:mr[or]},invalidAuthorityMetadata:{code:ir,desc:mr[ir]},untrustedAuthority:{code:ar,desc:mr[ar]},missingSshJwk:{code:sr,desc:mr[sr]},missingSshKid:{code:cr,desc:mr[cr]},missingNonceAuthenticationHeader:{code:lr,desc:mr[lr]},invalidAuthenticationHeader:{code:hr,desc:mr[hr]},cannotSetOIDCOptions:{code:dr,desc:mr[dr]},cannotAllowNativeBroker:{code:ur,desc:mr[ur]},authorityMismatch:{code:gr,desc:mr[gr]}};class Cr extends Ie{constructor(e){super(e,mr[e]),this.name="ClientConfigurationError",Object.setPrototypeOf(this,Cr.prototype)}}function yr(e){return new Cr(e)}
/*! @azure/msal-common v14.15.0 2024-10-08 */class vr{static isEmptyObj(e){if(e)try{const t=JSON.parse(e);return 0===Object.keys(t).length}catch(e){}return!0}static startsWith(e,t){return 0===e.indexOf(t)}static endsWith(e,t){return e.length>=t.length&&e.lastIndexOf(t)===e.length-t.length}static queryStringToObject(e){const t={},r=e.split("&"),n=e=>decodeURIComponent(e.replace(/\+/g," "));return r.forEach((e=>{if(e.trim()){const[r,o]=e.split(/=(.+)/g,2);r&&o&&(t[n(r)]=n(o))}})),t}static trimArrayEntries(e){return e.map((e=>e.trim()))}static removeEmptyStringsFromArray(e){return e.filter((e=>!!e))}static jsonParseHelper(e){try{return JSON.parse(e)}catch(e){return null}}static matchPattern(e,t){return new RegExp(e.replace(/\\/g,"\\\\").replace(/\*/g,"[^ ]*").replace(/\?/g,"\\?")).test(t)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Tr{constructor(e){const t=e?vr.trimArrayEntries([...e]):[],r=t?vr.removeEmptyStringsFromArray(t):[];this.validateInputScopes(r),this.scopes=new Set,r.forEach((e=>this.scopes.add(e)))}static fromString(e){const r=(e||t.EMPTY_STRING).split(" ");return new Tr(r)}static createSearchScopes(e){const r=new Tr(e);return r.containsOnlyOIDCScopes()?r.removeScope(t.OFFLINE_ACCESS_SCOPE):r.removeOIDCScopes(),r}validateInputScopes(e){if(!e||e.length<1)throw yr(Jt)}containsScope(e){const t=this.printScopesLowerCase().split(" "),r=new Tr(t);return!!e&&r.scopes.has(e.toLowerCase())}containsScopeSet(e){return!(!e||e.scopes.size<=0)&&(this.scopes.size>=e.scopes.size&&e.asArray().every((e=>this.containsScope(e))))}containsOnlyOIDCScopes(){let e=0;return s.forEach((t=>{this.containsScope(t)&&(e+=1)})),this.scopes.size===e}appendScope(e){e&&this.scopes.add(e.trim())}appendScopes(e){try{e.forEach((e=>this.appendScope(e)))}catch(e){throw Ct(Ke)}}removeScope(e){if(!e)throw Ct(Fe);this.scopes.delete(e.trim())}removeOIDCScopes(){s.forEach((e=>{this.scopes.delete(e)}))}unionScopeSets(e){if(!e)throw Ct(ze);const t=new Set;return e.scopes.forEach((e=>t.add(e.toLowerCase()))),this.scopes.forEach((e=>t.add(e.toLowerCase()))),t}intersectingScopeSets(e){if(!e)throw Ct(ze);e.containsOnlyOIDCScopes()||e.removeOIDCScopes();const t=this.unionScopeSets(e),r=e.getScopeCount(),n=this.getScopeCount();return t.size<n+r}getScopeCount(){return this.scopes.size}asArray(){const e=[];return this.scopes.forEach((t=>e.push(t))),e}printScopes(){if(this.scopes){return this.asArray().join(" ")}return t.EMPTY_STRING}printScopesLowerCase(){return this.printScopes().toLowerCase()}}
/*! @azure/msal-common v14.15.0 2024-10-08 */function Ir(e,t){if(!e)throw Ct(ke);try{const r=t(e);return JSON.parse(r)}catch(e){throw Ct(we)}}function Ar(e){if(!e)throw Ct(we);const r=e.split(U.CLIENT_INFO_SEPARATOR,2);return{uid:r[0],utid:r.length<2?t.EMPTY_STRING:r[1]}}
/*! @azure/msal-common v14.15.0 2024-10-08 */function wr(e,t){return!!e&&!!t&&e===t.split(".")[1]}function kr(e,t,r,n){if(n){const{oid:t,sub:r,tid:o,name:i,tfp:a,acr:s}=n,c=o||a||s||"";return{tenantId:c,localAccountId:t||r||"",name:i,isHomeTenant:wr(c,e)}}return{tenantId:r,localAccountId:t,isHomeTenant:wr(r,e)}}function Sr(e,t,r,n){let o=e;if(t){const{isHomeTenant:r,...n}=t;o={...e,...n}}if(r){const{isHomeTenant:t,...i}=kr(e.homeAccountId,e.localAccountId,e.tenantId,r);return o={...o,...i,idTokenClaims:r,idToken:n},o}return o}
/*! @azure/msal-common v14.15.0 2024-10-08 */const Er=0,Rr=1,br=2,_r=3;
/*! @azure/msal-common v14.15.0 2024-10-08 */function Pr(e){if(e){return e.tid||e.tfp||e.acr||null}return null}
/*! @azure/msal-common v14.15.0 2024-10-08 */const Mr={AAD:"AAD",OIDC:"OIDC"};
/*! @azure/msal-common v14.15.0 2024-10-08 */class Nr{generateAccountId(){return[this.homeAccountId,this.environment].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}generateAccountKey(){return Nr.generateAccountCacheKey({homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId})}getAccountInfo(){return{homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId,name:this.name,nativeAccountId:this.nativeAccountId,authorityType:this.authorityType,tenantProfiles:new Map((this.tenantProfiles||[]).map((e=>[e.tenantId,e])))}}isSingleTenant(){return!this.tenantProfiles}static generateAccountCacheKey(e){const t=e.homeAccountId.split(".")[1];return[e.homeAccountId,e.environment||"",t||e.tenantId||""].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}static createAccount(e,t,r){const n=new Nr;let o;t.authorityType===Rr?n.authorityType=q:t.protocolMode===Mr.AAD?n.authorityType=O:n.authorityType=L,e.clientInfo&&r&&(o=Ir(e.clientInfo,r)),n.clientInfo=e.clientInfo,n.homeAccountId=e.homeAccountId,n.nativeAccountId=e.nativeAccountId;const i=e.environment||t&&t.getPreferredCache();if(!i)throw Ct(Ve);n.environment=i,n.realm=o?.utid||Pr(e.idTokenClaims)||"",n.localAccountId=o?.uid||e.idTokenClaims?.oid||e.idTokenClaims?.sub||"";const a=e.idTokenClaims?.preferred_username||e.idTokenClaims?.upn,s=e.idTokenClaims?.emails?e.idTokenClaims.emails[0]:null;if(n.username=a||s||"",n.name=e.idTokenClaims?.name||"",n.cloudGraphHostName=e.cloudGraphHostName,n.msGraphHost=e.msGraphHost,e.tenantProfiles)n.tenantProfiles=e.tenantProfiles;else{const t=kr(e.homeAccountId,n.localAccountId,n.realm,e.idTokenClaims);n.tenantProfiles=[t]}return n}static createFromAccountInfo(e,t,r){const n=new Nr;return n.authorityType=e.authorityType||L,n.homeAccountId=e.homeAccountId,n.localAccountId=e.localAccountId,n.nativeAccountId=e.nativeAccountId,n.realm=e.tenantId,n.environment=e.environment,n.username=e.username,n.name=e.name,n.cloudGraphHostName=t,n.msGraphHost=r,n.tenantProfiles=Array.from(e.tenantProfiles?.values()||[]),n}static generateHomeAccountId(e,t,r,n,o){if(t!==Rr&&t!==br){if(e)try{const t=Ir(e,n.base64Decode);if(t.uid&&t.utid)return`${t.uid}.${t.utid}`}catch(e){}r.warning("No client info in response")}return o?.sub||""}static isAccountEntity(e){return!!e&&(e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("realm")&&e.hasOwnProperty("localAccountId")&&e.hasOwnProperty("username")&&e.hasOwnProperty("authorityType"))}static accountInfoIsEqual(e,t,r){if(!e||!t)return!1;let n=!0;if(r){const r=e.idTokenClaims||{},o=t.idTokenClaims||{};n=r.iat===o.iat&&r.nonce===o.nonce}return e.homeAccountId===t.homeAccountId&&e.localAccountId===t.localAccountId&&e.username===t.username&&e.tenantId===t.tenantId&&e.environment===t.environment&&e.nativeAccountId===t.nativeAccountId&&n}}
/*! @azure/msal-common v14.15.0 2024-10-08 */function Or(e){return e.startsWith("#/")?e.substring(2):e.startsWith("#")||e.startsWith("?")?e.substring(1):e}function qr(e){if(!e||e.indexOf("=")<0)return null;try{const t=Or(e),r=Object.fromEntries(new URLSearchParams(t));if(r.code||r.error||r.error_description||r.state)return r}catch(e){throw Ct(Pe)}return null}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Lr{get urlString(){return this._urlString}constructor(e){if(this._urlString=e,!this._urlString)throw yr(Yt);e.includes("#")||(this._urlString=Lr.canonicalizeUri(e))}static canonicalizeUri(e){if(e){let t=e.toLowerCase();return vr.endsWith(t,"?")?t=t.slice(0,-1):vr.endsWith(t,"?/")&&(t=t.slice(0,-2)),vr.endsWith(t,"/")||(t+="/"),t}return e}validateAsUri(){let e;try{e=this.getUrlComponents()}catch(e){throw yr(Vt)}if(!e.HostNameAndPort||!e.PathSegments)throw yr(Vt);if(!e.Protocol||"https:"!==e.Protocol.toLowerCase())throw yr(jt)}static appendQueryString(e,t){return t?e.indexOf("?")<0?`${e}?${t}`:`${e}&${t}`:e}static removeHashFromUrl(e){return Lr.canonicalizeUri(e.split("#")[0])}replaceTenantPath(e){const t=this.getUrlComponents(),r=t.PathSegments;return!e||0===r.length||r[0]!==A&&r[0]!==w||(r[0]=e),Lr.constructAuthorityUriFromObject(t)}getUrlComponents(){const e=RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?"),t=this.urlString.match(e);if(!t)throw yr(Vt);const r={Protocol:t[1],HostNameAndPort:t[4],AbsolutePath:t[5],QueryString:t[7]};let n=r.AbsolutePath.split("/");return n=n.filter((e=>e&&e.length>0)),r.PathSegments=n,r.QueryString&&r.QueryString.endsWith("/")&&(r.QueryString=r.QueryString.substring(0,r.QueryString.length-1)),r}static getDomainFromUrl(e){const t=RegExp("^([^:/?#]+://)?([^/?#]*)"),r=e.match(t);if(!r)throw yr(Vt);return r[2]}static getAbsoluteUrl(e,r){if(e[0]===t.FORWARD_SLASH){const t=new Lr(r).getUrlComponents();return t.Protocol+"//"+t.HostNameAndPort+e}return e}static constructAuthorityUriFromObject(e){return new Lr(e.Protocol+"//"+e.HostNameAndPort+"/"+e.PathSegments.join("/"))}static hashContainsKnownProperties(e){return!!qr(e)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const Ur={"login.microsoftonline.com":{token_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.com/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.com/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/logout"},"login.chinacloudapi.cn":{token_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.chinacloudapi.cn/{tenantid}/discovery/v2.0/keys",issuer:"https://login.partner.microsoftonline.cn/{tenantid}/v2.0",authorization_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/logout"},"login.microsoftonline.us":{token_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.us/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.us/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/logout"}},Hr={tenant_discovery_endpoint:"https://{canonicalAuthority}/v2.0/.well-known/openid-configuration",metadata:[{preferred_network:"login.microsoftonline.com",preferred_cache:"login.windows.net",aliases:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"]},{preferred_network:"login.partner.microsoftonline.cn",preferred_cache:"login.partner.microsoftonline.cn",aliases:["login.partner.microsoftonline.cn","login.chinacloudapi.cn"]},{preferred_network:"login.microsoftonline.de",preferred_cache:"login.microsoftonline.de",aliases:["login.microsoftonline.de"]},{preferred_network:"login.microsoftonline.us",preferred_cache:"login.microsoftonline.us",aliases:["login.microsoftonline.us","login.usgovcloudapi.net"]},{preferred_network:"login-us.microsoftonline.com",preferred_cache:"login-us.microsoftonline.com",aliases:["login-us.microsoftonline.com"]}]},Br=new Set;function xr(e,t,r,n){if(n?.trace(`getAliasesFromMetadata called with source: ${r}`),e&&t){const o=Dr(t,e);if(o)return n?.trace(`getAliasesFromMetadata: found cloud discovery metadata in ${r}, returning aliases`),o.aliases;n?.trace(`getAliasesFromMetadata: did not find cloud discovery metadata in ${r}`)}return null}function Dr(e,t){for(let r=0;r<e.length;r++){const n=e[r];if(n.aliases.includes(t))return n}return null}
/*! @azure/msal-common v14.15.0 2024-10-08 */Hr.metadata.forEach((e=>{e.aliases.forEach((e=>{Br.add(e)}))}));const Fr="cache_quota_exceeded",Kr="cache_error_unknown",zr={[Fr]:"Exceeded cache storage capacity.",[Kr]:"Unexpected error occurred when using cache storage."};class Gr extends Error{constructor(e,t){const r=t||(zr[e]?zr[e]:zr[Kr]);super(`${e}: ${r}`),Object.setPrototypeOf(this,Gr.prototype),this.name="CacheError",this.errorCode=e,this.errorMessage=r}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class $r{constructor(e,t,r,n){this.clientId=e,this.cryptoImpl=t,this.commonLogger=r.clone(It,At),this.staticAuthorityOptions=n}getAllAccounts(e){return this.buildTenantProfiles(this.getAccountsFilteredBy(e||{}),e)}getAccountInfoFilteredBy(e){const t=this.getAllAccounts(e);if(t.length>1){return t.sort((e=>e.idTokenClaims?-1:1))[0]}return 1===t.length?t[0]:null}getBaseAccountInfo(e){const t=this.getAccountsFilteredBy(e);return t.length>0?t[0].getAccountInfo():null}buildTenantProfiles(e,t){return e.flatMap((e=>this.getTenantProfilesFromAccountEntity(e,t?.tenantId,t)))}getTenantedAccountInfoByFilter(e,t,r,n){let o,i=null;if(n&&!this.tenantProfileMatchesFilter(r,n))return null;const a=this.getIdToken(e,t,r.tenantId);return a&&(o=kt(a.secret,this.cryptoImpl.base64Decode),!this.idTokenClaimsMatchTenantProfileFilter(o,n))?null:(i=Sr(e,r,o,a?.secret),i)}getTenantProfilesFromAccountEntity(e,t,r){const n=e.getAccountInfo();let o=n.tenantProfiles||new Map;const i=this.getTokenKeys();if(t){const e=o.get(t);if(!e)return[];o=new Map([[t,e]])}const a=[];return o.forEach((e=>{const t=this.getTenantedAccountInfoByFilter(n,i,e,r);t&&a.push(t)})),a}tenantProfileMatchesFilter(e,t){return!(t.localAccountId&&!this.matchLocalAccountIdFromTenantProfile(e,t.localAccountId))&&((!t.name||e.name===t.name)&&(void 0===t.isHomeTenant||e.isHomeTenant===t.isHomeTenant))}idTokenClaimsMatchTenantProfileFilter(e,t){if(t){if(t.localAccountId&&!this.matchLocalAccountIdFromTokenClaims(e,t.localAccountId))return!1;if(t.loginHint&&!this.matchLoginHintFromTokenClaims(e,t.loginHint))return!1;if(t.username&&!this.matchUsername(e.preferred_username,t.username))return!1;if(t.name&&!this.matchName(e,t.name))return!1;if(t.sid&&!this.matchSid(e,t.sid))return!1}return!0}async saveCacheRecord(e,t,r){if(!e)throw Ct(je);try{e.account&&this.setAccount(e.account),e.idToken&&!1!==t?.idToken&&this.setIdTokenCredential(e.idToken),e.accessToken&&!1!==t?.accessToken&&await this.saveAccessToken(e.accessToken),e.refreshToken&&!1!==t?.refreshToken&&this.setRefreshTokenCredential(e.refreshToken),e.appMetadata&&this.setAppMetadata(e.appMetadata)}catch(e){throw this.commonLogger?.error("CacheManager.saveCacheRecord: failed"),e instanceof Error?(this.commonLogger?.errorPii(`CacheManager.saveCacheRecord: ${e.message}`,r),"QuotaExceededError"===e.name||"NS_ERROR_DOM_QUOTA_REACHED"===e.name||e.message.includes("exceeded the quota")?(this.commonLogger?.error("CacheManager.saveCacheRecord: exceeded storage quota",r),new Gr(Fr)):new Gr(e.name,e.message)):(this.commonLogger?.errorPii(`CacheManager.saveCacheRecord: ${e}`,r),new Gr(Kr))}}async saveAccessToken(e){const t={clientId:e.clientId,credentialType:e.credentialType,environment:e.environment,homeAccountId:e.homeAccountId,realm:e.realm,tokenType:e.tokenType,requestedClaimsHash:e.requestedClaimsHash},r=this.getTokenKeys(),n=Tr.fromString(e.target),o=[];r.accessToken.forEach((e=>{if(!this.accessTokenKeyMatchesFilter(e,t,!1))return;const r=this.getAccessTokenCredential(e);if(r&&this.credentialMatchesFilter(r,t)){Tr.fromString(r.target).intersectingScopeSets(n)&&o.push(this.removeAccessToken(e))}})),await Promise.all(o),this.setAccessTokenCredential(e)}getAccountsFilteredBy(e){const t=this.getAccountKeys(),r=[];return t.forEach((t=>{if(!this.isAccountKey(t,e.homeAccountId))return;const n=this.getAccount(t,this.commonLogger);if(!n)return;if(e.homeAccountId&&!this.matchHomeAccountId(n,e.homeAccountId))return;if(e.username&&!this.matchUsername(n.username,e.username))return;if(e.environment&&!this.matchEnvironment(n,e.environment))return;if(e.realm&&!this.matchRealm(n,e.realm))return;if(e.nativeAccountId&&!this.matchNativeAccountId(n,e.nativeAccountId))return;if(e.authorityType&&!this.matchAuthorityType(n,e.authorityType))return;const o={localAccountId:e?.localAccountId,name:e?.name},i=n.tenantProfiles?.filter((e=>this.tenantProfileMatchesFilter(e,o)));i&&0===i.length||r.push(n)})),r}isAccountKey(e,t,r){return!(e.split(U.CACHE_KEY_SEPARATOR).length<3)&&(!(t&&!e.toLowerCase().includes(t.toLowerCase()))&&!(r&&!e.toLowerCase().includes(r.toLowerCase())))}isCredentialKey(e){if(e.split(U.CACHE_KEY_SEPARATOR).length<6)return!1;const t=e.toLowerCase();if(-1===t.indexOf(H.ID_TOKEN.toLowerCase())&&-1===t.indexOf(H.ACCESS_TOKEN.toLowerCase())&&-1===t.indexOf(H.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase())&&-1===t.indexOf(H.REFRESH_TOKEN.toLowerCase()))return!1;if(t.indexOf(H.REFRESH_TOKEN.toLowerCase())>-1){const e=`${H.REFRESH_TOKEN}${U.CACHE_KEY_SEPARATOR}${this.clientId}${U.CACHE_KEY_SEPARATOR}`,r=`${H.REFRESH_TOKEN}${U.CACHE_KEY_SEPARATOR}${x}${U.CACHE_KEY_SEPARATOR}`;if(-1===t.indexOf(e.toLowerCase())&&-1===t.indexOf(r.toLowerCase()))return!1}else if(-1===t.indexOf(this.clientId.toLowerCase()))return!1;return!0}credentialMatchesFilter(e,t){if(t.clientId&&!this.matchClientId(e,t.clientId))return!1;if(t.userAssertionHash&&!this.matchUserAssertionHash(e,t.userAssertionHash))return!1;if("string"==typeof t.homeAccountId&&!this.matchHomeAccountId(e,t.homeAccountId))return!1;if(t.environment&&!this.matchEnvironment(e,t.environment))return!1;if(t.realm&&!this.matchRealm(e,t.realm))return!1;if(t.credentialType&&!this.matchCredentialType(e,t.credentialType))return!1;if(t.familyId&&!this.matchFamilyId(e,t.familyId))return!1;if(t.target&&!this.matchTarget(e,t.target))return!1;if((t.requestedClaimsHash||e.requestedClaimsHash)&&e.requestedClaimsHash!==t.requestedClaimsHash)return!1;if(e.credentialType===H.ACCESS_TOKEN_WITH_AUTH_SCHEME){if(t.tokenType&&!this.matchTokenType(e,t.tokenType))return!1;if(t.tokenType===W.SSH&&t.keyId&&!this.matchKeyId(e,t.keyId))return!1}return!0}getAppMetadataFilteredBy(e){const t=this.getKeys(),r={};return t.forEach((t=>{if(!this.isAppMetadata(t))return;const n=this.getAppMetadata(t);n&&(e.environment&&!this.matchEnvironment(n,e.environment)||e.clientId&&!this.matchClientId(n,e.clientId)||(r[t]=n))})),r}getAuthorityMetadataByAlias(e){const t=this.getAuthorityMetadataKeys();let r=null;return t.forEach((t=>{if(!this.isAuthorityMetadata(t)||-1===t.indexOf(this.clientId))return;const n=this.getAuthorityMetadata(t);n&&-1!==n.aliases.indexOf(e)&&(r=n)})),r}async removeAllAccounts(){const e=this.getAccountKeys(),t=[];e.forEach((e=>{t.push(this.removeAccount(e))})),await Promise.all(t)}async removeAccount(e){const t=this.getAccount(e,this.commonLogger);t&&(await this.removeAccountContext(t),this.removeItem(e))}async removeAccountContext(e){const t=this.getTokenKeys(),r=e.generateAccountId(),n=[];t.idToken.forEach((e=>{0===e.indexOf(r)&&this.removeIdToken(e)})),t.accessToken.forEach((e=>{0===e.indexOf(r)&&n.push(this.removeAccessToken(e))})),t.refreshToken.forEach((e=>{0===e.indexOf(r)&&this.removeRefreshToken(e)})),await Promise.all(n)}updateOutdatedCachedAccount(e,t,r){if(t&&t.isSingleTenant()){this.commonLogger?.verbose("updateOutdatedCachedAccount: Found a single-tenant (outdated) account entity in the cache, migrating to multi-tenant account entity");const n=this.getAccountKeys().filter((e=>e.startsWith(t.homeAccountId))),o=[];n.forEach((e=>{const t=this.getCachedAccountEntity(e);t&&o.push(t)}));const i=o.find((e=>wr(e.realm,e.homeAccountId)))||o[0];i.tenantProfiles=o.map((e=>({tenantId:e.realm,localAccountId:e.localAccountId,name:e.name,isHomeTenant:wr(e.realm,e.homeAccountId)})));const a=$r.toObject(new Nr,{...i}),s=a.generateAccountKey();return n.forEach((t=>{t!==s&&this.removeOutdatedAccount(e)})),this.setAccount(a),r?.verbose("Updated an outdated account entity in the cache"),a}return t}async removeAccessToken(e){const t=this.getAccessTokenCredential(e);if(t){if(t.credentialType.toLowerCase()===H.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase()&&t.tokenType===W.POP){const e=t.keyId;if(e)try{await this.cryptoImpl.removeTokenBindingKey(e)}catch(e){throw Ct(it)}}return this.removeItem(e)}}removeAppMetadata(){return this.getKeys().forEach((e=>{this.isAppMetadata(e)&&this.removeItem(e)})),!0}readAccountFromCache(e){const t=Nr.generateAccountCacheKey(e);return this.getAccount(t,this.commonLogger)}getIdToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getIdToken called");const i={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:H.ID_TOKEN,clientId:this.clientId,realm:r},a=this.getIdTokensByFilter(i,t),s=a.size;if(s<1)return this.commonLogger.info("CacheManager:getIdToken - No token found"),null;if(s>1){let t=a;if(!r){const r=new Map;a.forEach(((t,n)=>{t.realm===e.tenantId&&r.set(n,t)}));const n=r.size;if(n<1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account but none match account entity tenant id, returning first result"),a.values().next().value;if(1===n)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account, defaulting to home tenant profile"),r.values().next().value;t=r}return this.commonLogger.info("CacheManager:getIdToken - Multiple matching ID tokens found, clearing them"),t.forEach(((e,t)=>{this.removeIdToken(t)})),n&&o&&n.addFields({multiMatchedID:a.size},o),null}return this.commonLogger.info("CacheManager:getIdToken - Returning ID token"),a.values().next().value}getIdTokensByFilter(e,t){const r=t&&t.idToken||this.getTokenKeys().idToken,n=new Map;return r.forEach((t=>{if(!this.idTokenKeyMatchesFilter(t,{clientId:this.clientId,...e}))return;const r=this.getIdTokenCredential(t);r&&this.credentialMatchesFilter(r,e)&&n.set(t,r)})),n}idTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.clientId||-1!==r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase()))}removeIdToken(e){this.removeItem(e)}removeRefreshToken(e){this.removeItem(e)}getAccessToken(e,t,r,n,o,i){this.commonLogger.trace("CacheManager - getAccessToken called");const a=Tr.createSearchScopes(t.scopes),s=t.authenticationScheme||W.BEARER,c=s&&s.toLowerCase()!==W.BEARER.toLowerCase()?H.ACCESS_TOKEN_WITH_AUTH_SCHEME:H.ACCESS_TOKEN,l={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:c,clientId:this.clientId,realm:n||e.tenantId,target:a,tokenType:s,keyId:t.sshKid,requestedClaimsHash:t.requestedClaimsHash},h=r&&r.accessToken||this.getTokenKeys().accessToken,d=[];h.forEach((e=>{if(this.accessTokenKeyMatchesFilter(e,l,!0)){const t=this.getAccessTokenCredential(e);t&&this.credentialMatchesFilter(t,l)&&d.push(t)}}));const u=d.length;return u<1?(this.commonLogger.info("CacheManager:getAccessToken - No token found"),null):u>1?(this.commonLogger.info("CacheManager:getAccessToken - Multiple access tokens found, clearing them"),d.forEach((e=>{this.removeAccessToken(_t(e))})),o&&i&&o.addFields({multiMatchedAT:d.length},i),null):(this.commonLogger.info("CacheManager:getAccessToken - Returning access token"),d[0])}accessTokenKeyMatchesFilter(e,t,r){const n=e.toLowerCase();if(t.clientId&&-1===n.indexOf(t.clientId.toLowerCase()))return!1;if(t.homeAccountId&&-1===n.indexOf(t.homeAccountId.toLowerCase()))return!1;if(t.realm&&-1===n.indexOf(t.realm.toLowerCase()))return!1;if(t.requestedClaimsHash&&-1===n.indexOf(t.requestedClaimsHash.toLowerCase()))return!1;if(t.target){const e=t.target.asArray();for(let t=0;t<e.length;t++){if(r&&!n.includes(e[t].toLowerCase()))return!1;if(!r&&n.includes(e[t].toLowerCase()))return!0}}return!0}getAccessTokensByFilter(e){const t=this.getTokenKeys(),r=[];return t.accessToken.forEach((t=>{if(!this.accessTokenKeyMatchesFilter(t,e,!0))return;const n=this.getAccessTokenCredential(t);n&&this.credentialMatchesFilter(n,e)&&r.push(n)})),r}getRefreshToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getRefreshToken called");const i=t?x:void 0,a={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:H.REFRESH_TOKEN,clientId:this.clientId,familyId:i},s=r&&r.refreshToken||this.getTokenKeys().refreshToken,c=[];s.forEach((e=>{if(this.refreshTokenKeyMatchesFilter(e,a)){const t=this.getRefreshTokenCredential(e);t&&this.credentialMatchesFilter(t,a)&&c.push(t)}}));const l=c.length;return l<1?(this.commonLogger.info("CacheManager:getRefreshToken - No refresh token found."),null):(l>1&&n&&o&&n.addFields({multiMatchedRT:l},o),this.commonLogger.info("CacheManager:getRefreshToken - returning refresh token"),c[0])}refreshTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.familyId||-1!==r.indexOf(t.familyId.toLowerCase()))&&(!(!t.familyId&&t.clientId&&-1===r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase())))}readAppMetadataFromCache(e){const t={environment:e,clientId:this.clientId},r=this.getAppMetadataFilteredBy(t),n=Object.keys(r).map((e=>r[e])),o=n.length;if(o<1)return null;if(o>1)throw Ct(xe);return n[0]}isAppMetadataFOCI(e){const t=this.readAppMetadataFromCache(e);return!(!t||t.familyId!==x)}matchHomeAccountId(e,t){return!("string"!=typeof e.homeAccountId||t!==e.homeAccountId)}matchLocalAccountIdFromTokenClaims(e,t){return t===(e.oid||e.sub)}matchLocalAccountIdFromTenantProfile(e,t){return e.localAccountId===t}matchName(e,t){return!(t.toLowerCase()!==e.name?.toLowerCase())}matchUsername(e,t){return!(!e||"string"!=typeof e||t?.toLowerCase()!==e.toLowerCase())}matchUserAssertionHash(e,t){return!(!e.userAssertionHash||t!==e.userAssertionHash)}matchEnvironment(e,t){if(this.staticAuthorityOptions){const r=function(e,t){let r;const n=e.canonicalAuthority;if(n){const o=new Lr(n).getUrlComponents().HostNameAndPort;r=xr(o,e.cloudDiscoveryMetadata?.metadata,K,t)||xr(o,Hr.metadata,$,t)||e.knownAuthorities}return r||[]}(this.staticAuthorityOptions,this.commonLogger);if(r.includes(t)&&r.includes(e.environment))return!0}const r=this.getAuthorityMetadataByAlias(t);return!!(r&&r.aliases.indexOf(e.environment)>-1)}matchCredentialType(e,t){return e.credentialType&&t.toLowerCase()===e.credentialType.toLowerCase()}matchClientId(e,t){return!(!e.clientId||t!==e.clientId)}matchFamilyId(e,t){return!(!e.familyId||t!==e.familyId)}matchRealm(e,t){return!(e.realm?.toLowerCase()!==t.toLowerCase())}matchNativeAccountId(e,t){return!(!e.nativeAccountId||t!==e.nativeAccountId)}matchLoginHintFromTokenClaims(e,t){return e.login_hint===t||(e.preferred_username===t||e.upn===t)}matchSid(e,t){return e.sid===t}matchAuthorityType(e,t){return!(!e.authorityType||t.toLowerCase()!==e.authorityType.toLowerCase())}matchTarget(e,t){if(e.credentialType!==H.ACCESS_TOKEN&&e.credentialType!==H.ACCESS_TOKEN_WITH_AUTH_SCHEME||!e.target)return!1;return Tr.fromString(e.target).containsScopeSet(t)}matchTokenType(e,t){return!(!e.tokenType||e.tokenType!==t)}matchKeyId(e,t){return!(!e.keyId||e.keyId!==t)}isAppMetadata(e){return-1!==e.indexOf(B)}isAuthorityMetadata(e){return-1!==e.indexOf(D)}generateAuthorityMetadataCacheKey(e){return`${D}-${this.clientId}-${e}`}static toObject(e,t){for(const r in t)e[r]=t[r];return e}}class Qr extends $r{setAccount(){throw Ct(dt)}getAccount(){throw Ct(dt)}getCachedAccountEntity(){throw Ct(dt)}setIdTokenCredential(){throw Ct(dt)}getIdTokenCredential(){throw Ct(dt)}setAccessTokenCredential(){throw Ct(dt)}getAccessTokenCredential(){throw Ct(dt)}setRefreshTokenCredential(){throw Ct(dt)}getRefreshTokenCredential(){throw Ct(dt)}setAppMetadata(){throw Ct(dt)}getAppMetadata(){throw Ct(dt)}setServerTelemetry(){throw Ct(dt)}getServerTelemetry(){throw Ct(dt)}setAuthorityMetadata(){throw Ct(dt)}getAuthorityMetadata(){throw Ct(dt)}getAuthorityMetadataKeys(){throw Ct(dt)}setThrottlingCache(){throw Ct(dt)}getThrottlingCache(){throw Ct(dt)}removeItem(){throw Ct(dt)}getKeys(){throw Ct(dt)}getAccountKeys(){throw Ct(dt)}getTokenKeys(){throw Ct(dt)}async clear(){throw Ct(dt)}updateCredentialCacheKey(){throw Ct(dt)}removeOutdatedAccount(){throw Ct(dt)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const Wr={tokenRenewalOffsetSeconds:300,preventCorsPreflight:!1},jr={loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info,correlationId:t.EMPTY_STRING},Vr={claimsBasedCachingEnabled:!1},Yr={async sendGetRequestAsync(){throw Ct(dt)},async sendPostRequestAsync(){throw Ct(dt)}},Jr={sku:t.SKU,version:At,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},Xr={clientSecret:t.EMPTY_STRING,clientAssertion:void 0},Zr={azureCloudInstance:wt.None,tenant:`${t.DEFAULT_COMMON_TENANT}`},en={application:{appName:"",appVersion:""}};function tn(e){return e.authOptions.authority.options.protocolMode===Mr.OIDC}
/*! @azure/msal-common v14.15.0 2024-10-08 */class rn extends Ie{constructor(e,t,r,n,o){super(e,t,r),this.name="ServerError",this.errorNo=n,this.status=o,Object.setPrototypeOf(this,rn.prototype)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class nn{static generateThrottlingStorageKey(e){return`${Y}.${JSON.stringify(e)}`}static preProcess(e,r){const n=nn.generateThrottlingStorageKey(r),o=e.getThrottlingCache(n);if(o){if(o.throttleTime<Date.now())return void e.removeItem(n);throw new rn(o.errorCodes?.join(" ")||t.EMPTY_STRING,o.errorMessage,o.subError)}}static postProcess(e,t,r){if(nn.checkResponseStatus(r)||nn.checkResponseForRetryAfter(r)){const n={throttleTime:nn.calculateThrottleTime(parseInt(r.headers[l])),error:r.body.error,errorCodes:r.body.error_codes,errorMessage:r.body.error_description,subError:r.body.suberror};e.setThrottlingCache(nn.generateThrottlingStorageKey(t),n)}}static checkResponseStatus(e){return 429===e.status||e.status>=500&&e.status<600}static checkResponseForRetryAfter(e){return!!e.headers&&(e.headers.hasOwnProperty(l)&&(e.status<200||e.status>=300))}static calculateThrottleTime(e){const t=e<=0?0:e,r=Date.now()/1e3;return Math.floor(1e3*Math.min(r+(t||j),r+V))}static removeThrottle(e,t,r,n){const o={clientId:t,authority:r.authority,scopes:r.scopes,homeAccountIdentifier:n,claims:r.claims,authenticationScheme:r.authenticationScheme,resourceRequestMethod:r.resourceRequestMethod,resourceRequestUri:r.resourceRequestUri,shrClaims:r.shrClaims,sshKid:r.sshKid},i=this.generateThrottlingStorageKey(o);e.removeItem(i)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class on{constructor(e,t){this.networkClient=e,this.cacheManager=t}async sendPostRequest(e,t,r){let n;nn.preProcess(this.cacheManager,e);try{n=await this.networkClient.sendPostRequestAsync(t,r)}catch(e){throw e instanceof Ie?e:Ct(be)}return nn.postProcess(this.cacheManager,e,n),n}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const an="home_account_id",sn="UPN",cn="client_id",ln="response_type",hn="token_type",dn="req_cnf",un="return_spa_code",gn="x-client-xtra-sku";
/*! @azure/msal-common v14.15.0 2024-10-08 */
/*! @azure/msal-common v14.15.0 2024-10-08 */
class pn{static validateRedirectUri(e){if(!e)throw yr(Qt)}static validatePrompt(e){const t=[];for(const e in R)t.push(R[e]);if(t.indexOf(e)<0)throw yr(Xt)}static validateClaims(e){try{JSON.parse(e)}catch(e){throw yr(Zt)}}static validateCodeChallengeParams(e,t){if(!e||!t)throw yr(nr);this.validateCodeChallengeMethod(t)}static validateCodeChallengeMethod(e){if([b.PLAIN,b.S256].indexOf(e)<0)throw yr(rr)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class mn{constructor(){this.parameters=new Map}addResponseTypeCode(){this.parameters.set(ln,encodeURIComponent(t.CODE_RESPONSE_TYPE))}addResponseTypeForTokenAndIdToken(){this.parameters.set(ln,encodeURIComponent(`${t.TOKEN_RESPONSE_TYPE} ${t.ID_TOKEN_RESPONSE_TYPE}`))}addResponseMode(e){this.parameters.set("response_mode",encodeURIComponent(e||P.QUERY))}addNativeBroker(){this.parameters.set("nativebroker",encodeURIComponent("1"))}addScopes(e,t=!0,r=a){!t||r.includes("openid")||e.includes("openid")||r.push("openid");const n=t?[...e||[],...r]:e||[],o=new Tr(n);this.parameters.set("scope",encodeURIComponent(o.printScopes()))}addClientId(e){this.parameters.set(cn,encodeURIComponent(e))}addRedirectUri(e){pn.validateRedirectUri(e),this.parameters.set("redirect_uri",encodeURIComponent(e))}addPostLogoutRedirectUri(e){pn.validateRedirectUri(e),this.parameters.set("post_logout_redirect_uri",encodeURIComponent(e))}addIdTokenHint(e){this.parameters.set("id_token_hint",encodeURIComponent(e))}addDomainHint(e){this.parameters.set("domain_hint",encodeURIComponent(e))}addLoginHint(e){this.parameters.set("login_hint",encodeURIComponent(e))}addCcsUpn(e){this.parameters.set(h,encodeURIComponent(`UPN:${e}`))}addCcsOid(e){this.parameters.set(h,encodeURIComponent(`Oid:${e.uid}@${e.utid}`))}addSid(e){this.parameters.set("sid",encodeURIComponent(e))}addClaims(e,t){const r=this.addClientCapabilitiesToClaims(e,t);pn.validateClaims(r),this.parameters.set("claims",encodeURIComponent(r))}addCorrelationId(e){this.parameters.set("client-request-id",encodeURIComponent(e))}addLibraryInfo(e){this.parameters.set("x-client-SKU",e.sku),this.parameters.set("x-client-VER",e.version),e.os&&this.parameters.set("x-client-OS",e.os),e.cpu&&this.parameters.set("x-client-CPU",e.cpu)}addApplicationTelemetry(e){e?.appName&&this.parameters.set("x-app-name",e.appName),e?.appVersion&&this.parameters.set("x-app-ver",e.appVersion)}addPrompt(e){pn.validatePrompt(e),this.parameters.set("prompt",encodeURIComponent(e))}addState(e){e&&this.parameters.set("state",encodeURIComponent(e))}addNonce(e){this.parameters.set("nonce",encodeURIComponent(e))}addCodeChallengeParams(e,t){if(pn.validateCodeChallengeParams(e,t),!e||!t)throw yr(nr);this.parameters.set("code_challenge",encodeURIComponent(e)),this.parameters.set("code_challenge_method",encodeURIComponent(t))}addAuthorizationCode(e){this.parameters.set("code",encodeURIComponent(e))}addDeviceCode(e){this.parameters.set("device_code",encodeURIComponent(e))}addRefreshToken(e){this.parameters.set("refresh_token",encodeURIComponent(e))}addCodeVerifier(e){this.parameters.set("code_verifier",encodeURIComponent(e))}addClientSecret(e){this.parameters.set("client_secret",encodeURIComponent(e))}addClientAssertion(e){e&&this.parameters.set("client_assertion",encodeURIComponent(e))}addClientAssertionType(e){e&&this.parameters.set("client_assertion_type",encodeURIComponent(e))}addOboAssertion(e){this.parameters.set("assertion",encodeURIComponent(e))}addRequestTokenUse(e){this.parameters.set("requested_token_use",encodeURIComponent(e))}addGrantType(e){this.parameters.set("grant_type",encodeURIComponent(e))}addClientInfo(){this.parameters.set("client_info","1")}addExtraQueryParameters(e){Object.entries(e).forEach((([e,t])=>{!this.parameters.has(e)&&t&&this.parameters.set(e,t)}))}addClientCapabilitiesToClaims(e,t){let r;if(e)try{r=JSON.parse(e)}catch(e){throw yr(Zt)}else r={};return t&&t.length>0&&(r.hasOwnProperty(S)||(r[S]={}),r[S][E]={values:t}),JSON.stringify(r)}addUsername(e){this.parameters.set(ee,encodeURIComponent(e))}addPassword(e){this.parameters.set(te,encodeURIComponent(e))}addPopToken(e){e&&(this.parameters.set(hn,W.POP),this.parameters.set(dn,encodeURIComponent(e)))}addSshJwk(e){e&&(this.parameters.set(hn,W.SSH),this.parameters.set(dn,encodeURIComponent(e)))}addServerTelemetry(e){this.parameters.set("x-client-current-telemetry",e.generateCurrentRequestHeaderValue()),this.parameters.set("x-client-last-telemetry",e.generateLastRequestHeaderValue())}addThrottling(){this.parameters.set("x-ms-lib-capability",J)}addLogoutHint(e){this.parameters.set("logout_hint",encodeURIComponent(e))}createQueryString(){const e=new Array;return this.parameters.forEach(((t,r)=>{e.push(`${r}=${t}`)})),e.join("&")}}
/*! @azure/msal-common v14.15.0 2024-10-08 */
/*! @azure/msal-common v14.15.0 2024-10-08 */
const fn={AcquireTokenByCode:"acquireTokenByCode",AcquireTokenByRefreshToken:"acquireTokenByRefreshToken",AcquireTokenSilent:"acquireTokenSilent",AcquireTokenSilentAsync:"acquireTokenSilentAsync",AcquireTokenPopup:"acquireTokenPopup",AcquireTokenPreRedirect:"acquireTokenPreRedirect",AcquireTokenRedirect:"acquireTokenRedirect",CryptoOptsGetPublicKeyThumbprint:"cryptoOptsGetPublicKeyThumbprint",CryptoOptsSignJwt:"cryptoOptsSignJwt",SilentCacheClientAcquireToken:"silentCacheClientAcquireToken",SilentIframeClientAcquireToken:"silentIframeClientAcquireToken",AwaitConcurrentIframe:"awaitConcurrentIframe",SilentRefreshClientAcquireToken:"silentRefreshClientAcquireToken",SsoSilent:"ssoSilent",StandardInteractionClientGetDiscoveredAuthority:"standardInteractionClientGetDiscoveredAuthority",FetchAccountIdWithNativeBroker:"fetchAccountIdWithNativeBroker",NativeInteractionClientAcquireToken:"nativeInteractionClientAcquireToken",BaseClientCreateTokenRequestHeaders:"baseClientCreateTokenRequestHeaders",RefreshTokenClientExecutePostToTokenEndpoint:"refreshTokenClientExecutePostToTokenEndpoint",AuthorizationCodeClientExecutePostToTokenEndpoint:"authorizationCodeClientExecutePostToTokenEndpoint",BrokerHandhshake:"brokerHandshake",AcquireTokenByRefreshTokenInBroker:"acquireTokenByRefreshTokenInBroker",AcquireTokenByBroker:"acquireTokenByBroker",RefreshTokenClientExecuteTokenRequest:"refreshTokenClientExecuteTokenRequest",RefreshTokenClientAcquireToken:"refreshTokenClientAcquireToken",RefreshTokenClientAcquireTokenWithCachedRefreshToken:"refreshTokenClientAcquireTokenWithCachedRefreshToken",RefreshTokenClientAcquireTokenByRefreshToken:"refreshTokenClientAcquireTokenByRefreshToken",RefreshTokenClientCreateTokenRequestBody:"refreshTokenClientCreateTokenRequestBody",AcquireTokenFromCache:"acquireTokenFromCache",SilentFlowClientAcquireCachedToken:"silentFlowClientAcquireCachedToken",SilentFlowClientGenerateResultFromCacheRecord:"silentFlowClientGenerateResultFromCacheRecord",AcquireTokenBySilentIframe:"acquireTokenBySilentIframe",InitializeBaseRequest:"initializeBaseRequest",InitializeSilentRequest:"initializeSilentRequest",InitializeClientApplication:"initializeClientApplication",SilentIframeClientTokenHelper:"silentIframeClientTokenHelper",SilentHandlerInitiateAuthRequest:"silentHandlerInitiateAuthRequest",SilentHandlerMonitorIframeForHash:"silentHandlerMonitorIframeForHash",SilentHandlerLoadFrame:"silentHandlerLoadFrame",SilentHandlerLoadFrameSync:"silentHandlerLoadFrameSync",StandardInteractionClientCreateAuthCodeClient:"standardInteractionClientCreateAuthCodeClient",StandardInteractionClientGetClientConfiguration:"standardInteractionClientGetClientConfiguration",StandardInteractionClientInitializeAuthorizationRequest:"standardInteractionClientInitializeAuthorizationRequest",StandardInteractionClientInitializeAuthorizationCodeRequest:"standardInteractionClientInitializeAuthorizationCodeRequest",GetAuthCodeUrl:"getAuthCodeUrl",HandleCodeResponseFromServer:"handleCodeResponseFromServer",HandleCodeResponse:"handleCodeResponse",UpdateTokenEndpointAuthority:"updateTokenEndpointAuthority",AuthClientAcquireToken:"authClientAcquireToken",AuthClientExecuteTokenRequest:"authClientExecuteTokenRequest",AuthClientCreateTokenRequestBody:"authClientCreateTokenRequestBody",AuthClientCreateQueryString:"authClientCreateQueryString",PopTokenGenerateCnf:"popTokenGenerateCnf",PopTokenGenerateKid:"popTokenGenerateKid",HandleServerTokenResponse:"handleServerTokenResponse",DeserializeResponse:"deserializeResponse",AuthorityFactoryCreateDiscoveredInstance:"authorityFactoryCreateDiscoveredInstance",AuthorityResolveEndpointsAsync:"authorityResolveEndpointsAsync",AuthorityResolveEndpointsFromLocalSources:"authorityResolveEndpointsFromLocalSources",AuthorityGetCloudDiscoveryMetadataFromNetwork:"authorityGetCloudDiscoveryMetadataFromNetwork",AuthorityUpdateCloudDiscoveryMetadata:"authorityUpdateCloudDiscoveryMetadata",AuthorityGetEndpointMetadataFromNetwork:"authorityGetEndpointMetadataFromNetwork",AuthorityUpdateEndpointMetadata:"authorityUpdateEndpointMetadata",AuthorityUpdateMetadataWithRegionalInformation:"authorityUpdateMetadataWithRegionalInformation",RegionDiscoveryDetectRegion:"regionDiscoveryDetectRegion",RegionDiscoveryGetRegionFromIMDS:"regionDiscoveryGetRegionFromIMDS",RegionDiscoveryGetCurrentVersion:"regionDiscoveryGetCurrentVersion",AcquireTokenByCodeAsync:"acquireTokenByCodeAsync",GetEndpointMetadataFromNetwork:"getEndpointMetadataFromNetwork",GetCloudDiscoveryMetadataFromNetworkMeasurement:"getCloudDiscoveryMetadataFromNetworkMeasurement",HandleRedirectPromiseMeasurement:"handleRedirectPromise",HandleNativeRedirectPromiseMeasurement:"handleNativeRedirectPromise",UpdateCloudDiscoveryMetadataMeasurement:"updateCloudDiscoveryMetadataMeasurement",UsernamePasswordClientAcquireToken:"usernamePasswordClientAcquireToken",NativeMessageHandlerHandshake:"nativeMessageHandlerHandshake",NativeGenerateAuthResult:"nativeGenerateAuthResult",RemoveHiddenIframe:"removeHiddenIframe",ClearTokensAndKeysWithClaims:"clearTokensAndKeysWithClaims",CacheManagerGetRefreshToken:"cacheManagerGetRefreshToken",GeneratePkceCodes:"generatePkceCodes",GenerateCodeVerifier:"generateCodeVerifier",GenerateCodeChallengeFromVerifier:"generateCodeChallengeFromVerifier",Sha256Digest:"sha256Digest",GetRandomValues:"getRandomValues"},Cn=new Map([[fn.AcquireTokenByCode,"ATByCode"],[fn.AcquireTokenByRefreshToken,"ATByRT"],[fn.AcquireTokenSilent,"ATS"],[fn.AcquireTokenSilentAsync,"ATSAsync"],[fn.AcquireTokenPopup,"ATPopup"],[fn.AcquireTokenRedirect,"ATRedirect"],[fn.CryptoOptsGetPublicKeyThumbprint,"CryptoGetPKThumb"],[fn.CryptoOptsSignJwt,"CryptoSignJwt"],[fn.SilentCacheClientAcquireToken,"SltCacheClientAT"],[fn.SilentIframeClientAcquireToken,"SltIframeClientAT"],[fn.SilentRefreshClientAcquireToken,"SltRClientAT"],[fn.SsoSilent,"SsoSlt"],[fn.StandardInteractionClientGetDiscoveredAuthority,"StdIntClientGetDiscAuth"],[fn.FetchAccountIdWithNativeBroker,"FetchAccIdWithNtvBroker"],[fn.NativeInteractionClientAcquireToken,"NtvIntClientAT"],[fn.BaseClientCreateTokenRequestHeaders,"BaseClientCreateTReqHead"],[fn.RefreshTokenClientExecutePostToTokenEndpoint,"RTClientExecPost"],[fn.AuthorizationCodeClientExecutePostToTokenEndpoint,"AuthCodeClientExecPost"],[fn.BrokerHandhshake,"BrokerHandshake"],[fn.AcquireTokenByRefreshTokenInBroker,"ATByRTInBroker"],[fn.AcquireTokenByBroker,"ATByBroker"],[fn.RefreshTokenClientExecuteTokenRequest,"RTClientExecTReq"],[fn.RefreshTokenClientAcquireToken,"RTClientAT"],[fn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,"RTClientATWithCachedRT"],[fn.RefreshTokenClientAcquireTokenByRefreshToken,"RTClientATByRT"],[fn.RefreshTokenClientCreateTokenRequestBody,"RTClientCreateTReqBody"],[fn.AcquireTokenFromCache,"ATFromCache"],[fn.SilentFlowClientAcquireCachedToken,"SltFlowClientATCached"],[fn.SilentFlowClientGenerateResultFromCacheRecord,"SltFlowClientGenResFromCache"],[fn.AcquireTokenBySilentIframe,"ATBySltIframe"],[fn.InitializeBaseRequest,"InitBaseReq"],[fn.InitializeSilentRequest,"InitSltReq"],[fn.InitializeClientApplication,"InitClientApplication"],[fn.SilentIframeClientTokenHelper,"SIClientTHelper"],[fn.SilentHandlerInitiateAuthRequest,"SHandlerInitAuthReq"],[fn.SilentHandlerMonitorIframeForHash,"SltHandlerMonitorIframeForHash"],[fn.SilentHandlerLoadFrame,"SHandlerLoadFrame"],[fn.SilentHandlerLoadFrameSync,"SHandlerLoadFrameSync"],[fn.StandardInteractionClientCreateAuthCodeClient,"StdIntClientCreateAuthCodeClient"],[fn.StandardInteractionClientGetClientConfiguration,"StdIntClientGetClientConf"],[fn.StandardInteractionClientInitializeAuthorizationRequest,"StdIntClientInitAuthReq"],[fn.StandardInteractionClientInitializeAuthorizationCodeRequest,"StdIntClientInitAuthCodeReq"],[fn.GetAuthCodeUrl,"GetAuthCodeUrl"],[fn.HandleCodeResponseFromServer,"HandleCodeResFromServer"],[fn.HandleCodeResponse,"HandleCodeResp"],[fn.UpdateTokenEndpointAuthority,"UpdTEndpointAuth"],[fn.AuthClientAcquireToken,"AuthClientAT"],[fn.AuthClientExecuteTokenRequest,"AuthClientExecTReq"],[fn.AuthClientCreateTokenRequestBody,"AuthClientCreateTReqBody"],[fn.AuthClientCreateQueryString,"AuthClientCreateQueryStr"],[fn.PopTokenGenerateCnf,"PopTGenCnf"],[fn.PopTokenGenerateKid,"PopTGenKid"],[fn.HandleServerTokenResponse,"HandleServerTRes"],[fn.DeserializeResponse,"DeserializeRes"],[fn.AuthorityFactoryCreateDiscoveredInstance,"AuthFactCreateDiscInst"],[fn.AuthorityResolveEndpointsAsync,"AuthResolveEndpointsAsync"],[fn.AuthorityResolveEndpointsFromLocalSources,"AuthResolveEndpointsFromLocal"],[fn.AuthorityGetCloudDiscoveryMetadataFromNetwork,"AuthGetCDMetaFromNet"],[fn.AuthorityUpdateCloudDiscoveryMetadata,"AuthUpdCDMeta"],[fn.AuthorityGetEndpointMetadataFromNetwork,"AuthUpdCDMetaFromNet"],[fn.AuthorityUpdateEndpointMetadata,"AuthUpdEndpointMeta"],[fn.AuthorityUpdateMetadataWithRegionalInformation,"AuthUpdMetaWithRegInfo"],[fn.RegionDiscoveryDetectRegion,"RegDiscDetectReg"],[fn.RegionDiscoveryGetRegionFromIMDS,"RegDiscGetRegFromIMDS"],[fn.RegionDiscoveryGetCurrentVersion,"RegDiscGetCurrentVer"],[fn.AcquireTokenByCodeAsync,"ATByCodeAsync"],[fn.GetEndpointMetadataFromNetwork,"GetEndpointMetaFromNet"],[fn.GetCloudDiscoveryMetadataFromNetworkMeasurement,"GetCDMetaFromNet"],[fn.HandleRedirectPromiseMeasurement,"HandleRedirectPromise"],[fn.HandleNativeRedirectPromiseMeasurement,"HandleNtvRedirectPromise"],[fn.UpdateCloudDiscoveryMetadataMeasurement,"UpdateCDMeta"],[fn.UsernamePasswordClientAcquireToken,"UserPassClientAT"],[fn.NativeMessageHandlerHandshake,"NtvMsgHandlerHandshake"],[fn.NativeGenerateAuthResult,"NtvGenAuthRes"],[fn.RemoveHiddenIframe,"RemoveHiddenIframe"],[fn.ClearTokensAndKeysWithClaims,"ClearTAndKeysWithClaims"],[fn.CacheManagerGetRefreshToken,"CacheManagerGetRT"],[fn.GeneratePkceCodes,"GenPkceCodes"],[fn.GenerateCodeVerifier,"GenCodeVerifier"],[fn.GenerateCodeChallengeFromVerifier,"GenCodeChallengeFromVerifier"],[fn.Sha256Digest,"Sha256Digest"],[fn.GetRandomValues,"GetRandomValues"]]),yn=1,vn=2,Tn=new Set(["accessTokenSize","durationMs","idTokenSize","matsSilentStatus","matsHttpStatus","refreshTokenSize","queuedTimeMs","startTimeMs","status","multiMatchedAT","multiMatchedID","multiMatchedRT"]),In=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const a=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}try{const n=e(...i);return a?.end({success:!0}),r.trace(`Returning result from ${t}`),n}catch(e){r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw a?.end({success:!1},e),e}},An=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const a=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}return n?.setPreQueueTime(t,o),e(...i).then((e=>(r.trace(`Returning result from ${t}`),a?.end({success:!0}),e))).catch((e=>{r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw a?.end({success:!1},e),e}))};
/*! @azure/msal-common v14.15.0 2024-10-08 */
class wn{constructor(e,t,r,n){this.networkInterface=e,this.logger=t,this.performanceClient=r,this.correlationId=n}async detectRegion(e,r){this.performanceClient?.addQueueMeasurement(fn.RegionDiscoveryDetectRegion,this.correlationId);let n=e;if(n)r.region_source=ie;else{const e=wn.IMDS_OPTIONS;try{const o=await An(this.getRegionFromIMDS.bind(this),fn.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t.IMDS_VERSION,e);if(o.status===re&&(n=o.body,r.region_source=ae),o.status===ne){const t=await An(this.getCurrentVersion.bind(this),fn.RegionDiscoveryGetCurrentVersion,this.logger,this.performanceClient,this.correlationId)(e);if(!t)return r.region_source=oe,null;const o=await An(this.getRegionFromIMDS.bind(this),fn.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t,e);o.status===re&&(n=o.body,r.region_source=ae)}}catch(e){return r.region_source=oe,null}}return n||(r.region_source=oe),n||null}async getRegionFromIMDS(e,r){return this.performanceClient?.addQueueMeasurement(fn.RegionDiscoveryGetRegionFromIMDS,this.correlationId),this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?api-version=${e}&format=text`,r,t.IMDS_TIMEOUT)}async getCurrentVersion(e){this.performanceClient?.addQueueMeasurement(fn.RegionDiscoveryGetCurrentVersion,this.correlationId);try{const r=await this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?format=json`,e);return r.status===ne&&r.body&&r.body["newest-versions"]&&r.body["newest-versions"].length>0?r.body["newest-versions"][0]:null}catch(e){return null}}}wn.IMDS_OPTIONS={headers:{Metadata:"true"}};
/*! @azure/msal-common v14.15.0 2024-10-08 */
class kn{constructor(e,t,r,n,o,i,a,s){this.canonicalAuthority=e,this._canonicalAuthority.validateAsUri(),this.networkInterface=t,this.cacheManager=r,this.authorityOptions=n,this.regionDiscoveryMetadata={region_used:void 0,region_source:void 0,region_outcome:void 0},this.logger=o,this.performanceClient=a,this.correlationId=i,this.managedIdentity=s||!1,this.regionDiscovery=new wn(t,this.logger,this.performanceClient,this.correlationId)}getAuthorityType(e){if(e.HostNameAndPort.endsWith(t.CIAM_AUTH_URL))return _r;const r=e.PathSegments;if(r.length)switch(r[0].toLowerCase()){case t.ADFS:return Rr;case t.DSTS:return br}return Er}get authorityType(){return this.getAuthorityType(this.canonicalAuthorityUrlComponents)}get protocolMode(){return this.authorityOptions.protocolMode}get options(){return this.authorityOptions}get canonicalAuthority(){return this._canonicalAuthority.urlString}set canonicalAuthority(e){this._canonicalAuthority=new Lr(e),this._canonicalAuthority.validateAsUri(),this._canonicalAuthorityUrlComponents=null}get canonicalAuthorityUrlComponents(){return this._canonicalAuthorityUrlComponents||(this._canonicalAuthorityUrlComponents=this._canonicalAuthority.getUrlComponents()),this._canonicalAuthorityUrlComponents}get hostnameAndPort(){return this.canonicalAuthorityUrlComponents.HostNameAndPort.toLowerCase()}get tenant(){return this.canonicalAuthorityUrlComponents.PathSegments[0]}get authorizationEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.authorization_endpoint);throw Ct(Re)}get tokenEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint);throw Ct(Re)}get deviceCodeEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint.replace("/token","/devicecode"));throw Ct(Re)}get endSessionEndpoint(){if(this.discoveryComplete()){if(!this.metadata.end_session_endpoint)throw Ct(at);return this.replacePath(this.metadata.end_session_endpoint)}throw Ct(Re)}get selfSignedJwtAudience(){if(this.discoveryComplete())return this.replacePath(this.metadata.issuer);throw Ct(Re)}get jwksUri(){if(this.discoveryComplete())return this.replacePath(this.metadata.jwks_uri);throw Ct(Re)}canReplaceTenant(e){return 1===e.PathSegments.length&&!kn.reservedTenantDomains.has(e.PathSegments[0])&&this.getAuthorityType(e)===Er&&this.protocolMode===Mr.AAD}replaceTenant(e){return e.replace(/{tenant}|{tenantid}/g,this.tenant)}replacePath(e){let t=e;const r=new Lr(this.metadata.canonical_authority).getUrlComponents(),n=r.PathSegments;return this.canonicalAuthorityUrlComponents.PathSegments.forEach(((e,o)=>{let i=n[o];if(0===o&&this.canReplaceTenant(r)){const e=new Lr(this.metadata.authorization_endpoint).getUrlComponents().PathSegments[0];i!==e&&(this.logger.verbose(`Replacing tenant domain name ${i} with id ${e}`),i=e)}e!==i&&(t=t.replace(`/${i}/`,`/${e}/`))})),this.replaceTenant(t)}get defaultOpenIdConfigurationEndpoint(){const e=this.hostnameAndPort;return this.canonicalAuthority.endsWith("v2.0/")||this.authorityType===Rr||this.protocolMode!==Mr.AAD&&!this.isAliasOfKnownMicrosoftAuthority(e)?`${this.canonicalAuthority}.well-known/openid-configuration`:`${this.canonicalAuthority}v2.0/.well-known/openid-configuration`}discoveryComplete(){return!!this.metadata}async resolveEndpointsAsync(){this.performanceClient?.addQueueMeasurement(fn.AuthorityResolveEndpointsAsync,this.correlationId);const e=this.getCurrentMetadataEntity(),t=await An(this.updateCloudDiscoveryMetadata.bind(this),fn.AuthorityUpdateCloudDiscoveryMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.canonicalAuthority=this.canonicalAuthority.replace(this.hostnameAndPort,e.preferred_network);const r=await An(this.updateEndpointMetadata.bind(this),fn.AuthorityUpdateEndpointMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.updateCachedMetadata(e,t,{source:r}),this.performanceClient?.addFields({cloudDiscoverySource:t,authorityEndpointSource:r},this.correlationId)}getCurrentMetadataEntity(){let e=this.cacheManager.getAuthorityMetadataByAlias(this.hostnameAndPort);return e||(e={aliases:[],preferred_cache:this.hostnameAndPort,preferred_network:this.hostnameAndPort,canonical_authority:this.canonicalAuthority,authorization_endpoint:"",token_endpoint:"",end_session_endpoint:"",issuer:"",aliasesFromNetwork:!1,endpointsFromNetwork:!1,expiresAt:Kt(),jwks_uri:""}),e}updateCachedMetadata(e,t,r){t!==z&&r?.source!==z&&(e.expiresAt=Kt(),e.canonical_authority=this.canonicalAuthority);const n=this.cacheManager.generateAuthorityMetadataCacheKey(e.preferred_cache);this.cacheManager.setAuthorityMetadata(n,e),this.metadata=e}async updateEndpointMetadata(e){this.performanceClient?.addQueueMeasurement(fn.AuthorityUpdateEndpointMetadata,this.correlationId);const t=this.updateEndpointMetadataFromLocalSources(e);if(t){if(t.source===$&&this.authorityOptions.azureRegionConfiguration?.azureRegion&&t.metadata){zt(e,await An(this.updateMetadataWithRegionalInformation.bind(this),fn.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(t.metadata),!1),e.canonical_authority=this.canonicalAuthority}return t.source}let r=await An(this.getEndpointMetadataFromNetwork.bind(this),fn.AuthorityGetEndpointMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return this.authorityOptions.azureRegionConfiguration?.azureRegion&&(r=await An(this.updateMetadataWithRegionalInformation.bind(this),fn.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(r)),zt(e,r,!0),G;throw Ct(_e,this.defaultOpenIdConfigurationEndpoint)}updateEndpointMetadataFromLocalSources(e){this.logger.verbose("Attempting to get endpoint metadata from authority configuration");const t=this.getEndpointMetadataFromConfig();if(t)return this.logger.verbose("Found endpoint metadata in authority configuration"),zt(e,t,!1),{source:K};if(this.logger.verbose("Did not find endpoint metadata in the config... Attempting to get endpoint metadata from the hardcoded values."),this.authorityOptions.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get endpoint metadata from the network metadata cache.");else{const t=this.getEndpointMetadataFromHardcodedValues();if(t)return zt(e,t,!1),{source:$,metadata:t};this.logger.verbose("Did not find endpoint metadata in hardcoded values... Attempting to get endpoint metadata from the network metadata cache.")}const r=$t(e);return this.isAuthoritySameType(e)&&e.endpointsFromNetwork&&!r?(this.logger.verbose("Found endpoint metadata in the cache."),{source:z}):(r&&this.logger.verbose("The metadata entity is expired."),null)}isAuthoritySameType(e){return new Lr(e.canonical_authority).getUrlComponents().PathSegments.length===this.canonicalAuthorityUrlComponents.PathSegments.length}getEndpointMetadataFromConfig(){if(this.authorityOptions.authorityMetadata)try{return JSON.parse(this.authorityOptions.authorityMetadata)}catch(e){throw yr(ir)}return null}async getEndpointMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(fn.AuthorityGetEndpointMetadataFromNetwork,this.correlationId);const e={},t=this.defaultOpenIdConfigurationEndpoint;this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: attempting to retrieve OAuth endpoints from ${t}`);try{const r=await this.networkInterface.sendGetRequestAsync(t,e),n=function(e){return e.hasOwnProperty("authorization_endpoint")&&e.hasOwnProperty("token_endpoint")&&e.hasOwnProperty("issuer")&&e.hasOwnProperty("jwks_uri")}
/*! @azure/msal-common v14.15.0 2024-10-08 */(r.body);return n?r.body:(this.logger.verbose("Authority.getEndpointMetadataFromNetwork: could not parse response as OpenID configuration"),null)}catch(e){return this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: ${e}`),null}}getEndpointMetadataFromHardcodedValues(){return this.hostnameAndPort in Ur?Ur[this.hostnameAndPort]:null}async updateMetadataWithRegionalInformation(e){this.performanceClient?.addQueueMeasurement(fn.AuthorityUpdateMetadataWithRegionalInformation,this.correlationId);const r=this.authorityOptions.azureRegionConfiguration?.azureRegion;if(r){if(r!==t.AZURE_REGION_AUTO_DISCOVER_FLAG)return this.regionDiscoveryMetadata.region_outcome=se,this.regionDiscoveryMetadata.region_used=r,kn.replaceWithRegionalInformation(e,r);const n=await An(this.regionDiscovery.detectRegion.bind(this.regionDiscovery),fn.RegionDiscoveryDetectRegion,this.logger,this.performanceClient,this.correlationId)(this.authorityOptions.azureRegionConfiguration?.environmentRegion,this.regionDiscoveryMetadata);if(n)return this.regionDiscoveryMetadata.region_outcome=ce,this.regionDiscoveryMetadata.region_used=n,kn.replaceWithRegionalInformation(e,n);this.regionDiscoveryMetadata.region_outcome=le}return e}async updateCloudDiscoveryMetadata(e){this.performanceClient?.addQueueMeasurement(fn.AuthorityUpdateCloudDiscoveryMetadata,this.correlationId);const t=this.updateCloudDiscoveryMetadataFromLocalSources(e);if(t)return t;const r=await An(this.getCloudDiscoveryMetadataFromNetwork.bind(this),fn.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return Gt(e,r,!0),G;throw yr(ar)}updateCloudDiscoveryMetadataFromLocalSources(e){this.logger.verbose("Attempting to get cloud discovery metadata  from authority configuration"),this.logger.verbosePii(`Known Authorities: ${this.authorityOptions.knownAuthorities||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Authority Metadata: ${this.authorityOptions.authorityMetadata||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Canonical Authority: ${e.canonical_authority||t.NOT_APPLICABLE}`);const r=this.getCloudDiscoveryMetadataFromConfig();if(r)return this.logger.verbose("Found cloud discovery metadata in authority configuration"),Gt(e,r,!1),K;if(this.logger.verbose("Did not find cloud discovery metadata in the config... Attempting to get cloud discovery metadata from the hardcoded values."),this.options.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded cloud discovery metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get cloud discovery metadata from the network metadata cache.");else{const t=(n=this.hostnameAndPort,Dr(Hr.metadata,n));if(t)return this.logger.verbose("Found cloud discovery metadata from hardcoded values."),Gt(e,t,!1),$;this.logger.verbose("Did not find cloud discovery metadata in hardcoded values... Attempting to get cloud discovery metadata from the network metadata cache.")}var n;const o=$t(e);return this.isAuthoritySameType(e)&&e.aliasesFromNetwork&&!o?(this.logger.verbose("Found cloud discovery metadata in the cache."),z):(o&&this.logger.verbose("The metadata entity is expired."),null)}getCloudDiscoveryMetadataFromConfig(){if(this.authorityType===_r)return this.logger.verbose("CIAM authorities do not support cloud discovery metadata, generate the aliases from authority host."),kn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort);if(this.authorityOptions.cloudDiscoveryMetadata){this.logger.verbose("The cloud discovery metadata has been provided as a network response, in the config.");try{this.logger.verbose("Attempting to parse the cloud discovery metadata.");const e=Dr(JSON.parse(this.authorityOptions.cloudDiscoveryMetadata).metadata,this.hostnameAndPort);if(this.logger.verbose("Parsed the cloud discovery metadata."),e)return this.logger.verbose("There is returnable metadata attached to the parsed cloud discovery metadata."),e;this.logger.verbose("There is no metadata attached to the parsed cloud discovery metadata.")}catch(e){throw this.logger.verbose("Unable to parse the cloud discovery metadata. Throwing Invalid Cloud Discovery Metadata Error."),yr(or)}}return this.isInKnownAuthorities()?(this.logger.verbose("The host is included in knownAuthorities. Creating new cloud discovery metadata from the host."),kn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)):null}async getCloudDiscoveryMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(fn.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.correlationId);const e=`${t.AAD_INSTANCE_DISCOVERY_ENDPT}${this.canonicalAuthority}oauth2/v2.0/authorize`,r={};let n=null;try{const o=await this.networkInterface.sendGetRequestAsync(e,r);let i,a;if(function(e){return e.hasOwnProperty("tenant_discovery_endpoint")&&e.hasOwnProperty("metadata")}
/*! @azure/msal-common v14.15.0 2024-10-08 */(o.body))i=o.body,a=i.metadata,this.logger.verbosePii(`tenant_discovery_endpoint is: ${i.tenant_discovery_endpoint}`);else{if(!function(e){return e.hasOwnProperty("error")&&e.hasOwnProperty("error_description")}(o.body))return this.logger.error("AAD did not return a CloudInstanceDiscoveryResponse or CloudInstanceDiscoveryErrorResponse"),null;if(this.logger.warning(`A CloudInstanceDiscoveryErrorResponse was returned. The cloud instance discovery network request's status code is: ${o.status}`),i=o.body,i.error===t.INVALID_INSTANCE)return this.logger.error("The CloudInstanceDiscoveryErrorResponse error is invalid_instance."),null;this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error is ${i.error}`),this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error description is ${i.error_description}`),this.logger.warning("Setting the value of the CloudInstanceDiscoveryMetadata (returned from the network) to []"),a=[]}this.logger.verbose("Attempting to find a match between the developer's authority and the CloudInstanceDiscoveryMetadata returned from the network request."),n=Dr(a,this.hostnameAndPort)}catch(e){if(e instanceof Ie)this.logger.error(`There was a network error while attempting to get the cloud discovery instance metadata.\nError: ${e.errorCode}\nError Description: ${e.errorMessage}`);else{const t=e;this.logger.error(`A non-MSALJS error was thrown while attempting to get the cloud instance discovery metadata.\nError: ${t.name}\nError Description: ${t.message}`)}return null}return n||(this.logger.warning("The developer's authority was not found within the CloudInstanceDiscoveryMetadata returned from the network request."),this.logger.verbose("Creating custom Authority for custom domain scenario."),n=kn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)),n}isInKnownAuthorities(){return this.authorityOptions.knownAuthorities.filter((e=>e&&Lr.getDomainFromUrl(e).toLowerCase()===this.hostnameAndPort)).length>0}static generateAuthority(e,r){let n;if(r&&r.azureCloudInstance!==wt.None){const e=r.tenant?r.tenant:t.DEFAULT_COMMON_TENANT;n=`${r.azureCloudInstance}/${e}/`}return n||e}static createCloudDiscoveryMetadataFromHost(e){return{preferred_network:e,preferred_cache:e,aliases:[e]}}getPreferredCache(){if(this.managedIdentity)return t.DEFAULT_AUTHORITY_HOST;if(this.discoveryComplete())return this.metadata.preferred_cache;throw Ct(Re)}isAlias(e){return this.metadata.aliases.indexOf(e)>-1}isAliasOfKnownMicrosoftAuthority(e){return Br.has(e)}static isPublicCloudAuthority(e){return t.KNOWN_PUBLIC_CLOUDS.indexOf(e)>=0}static buildRegionalAuthorityString(e,r,n){const o=new Lr(e);o.validateAsUri();const i=o.getUrlComponents();let a=`${r}.${i.HostNameAndPort}`;this.isPublicCloudAuthority(i.HostNameAndPort)&&(a=`${r}.${t.REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX}`);const s=Lr.constructAuthorityUriFromObject({...o.getUrlComponents(),HostNameAndPort:a}).urlString;return n?`${s}?${n}`:s}static replaceWithRegionalInformation(e,t){const r={...e};return r.authorization_endpoint=kn.buildRegionalAuthorityString(r.authorization_endpoint,t),r.token_endpoint=kn.buildRegionalAuthorityString(r.token_endpoint,t),r.end_session_endpoint&&(r.end_session_endpoint=kn.buildRegionalAuthorityString(r.end_session_endpoint,t)),r}static transformCIAMAuthority(e){let r=e;const n=new Lr(e).getUrlComponents();if(0===n.PathSegments.length&&n.HostNameAndPort.endsWith(t.CIAM_AUTH_URL)){r=`${r}${n.HostNameAndPort.split(".")[0]}${t.AAD_TENANT_DOMAIN_SUFFIX}`}return r}}function Sn(e){return e.endsWith(t.FORWARD_SLASH)?e:`${e}${t.FORWARD_SLASH}`}function En(e){const t=e.cloudDiscoveryMetadata;let r;if(t)try{r=JSON.parse(t)}catch(e){throw yr(or)}return{canonicalAuthority:e.authority?Sn(e.authority):void 0,knownAuthorities:e.knownAuthorities,cloudDiscoveryMetadata:r}}
/*! @azure/msal-common v14.15.0 2024-10-08 */async function Rn(e,t,r,n,o,i,a){a?.addQueueMeasurement(fn.AuthorityFactoryCreateDiscoveredInstance,i);const s=kn.transformCIAMAuthority(Sn(e)),c=new kn(s,t,r,n,o,i,a);try{return await An(c.resolveEndpointsAsync.bind(c),fn.AuthorityResolveEndpointsAsync,o,a,i)(),c}catch(e){throw Ct(Re)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */kn.reservedTenantDomains=new Set(["{tenant}","{tenantid}",A,k,w]);class bn{constructor(e,t){this.config=function({authOptions:e,systemOptions:t,loggerOptions:r,cacheOptions:n,storageInterface:o,networkInterface:i,cryptoInterface:a,clientCredentials:s,libraryInfo:c,telemetry:l,serverTelemetryManager:h,persistencePlugin:d,serializableCache:u}){const g={...jr,...r};return{authOptions:(p=e,{clientCapabilities:[],azureCloudOptions:Zr,skipAuthorityMetadataCache:!1,instanceAware:!1,...p}),systemOptions:{...Wr,...t},loggerOptions:g,cacheOptions:{...Vr,...n},storageInterface:o||new Qr(e.clientId,yt,new Tt(g)),networkInterface:i||Yr,cryptoInterface:a||yt,clientCredentials:s||Xr,libraryInfo:{...Jr,...c},telemetry:{...en,...l},serverTelemetryManager:h||null,persistencePlugin:d||null,serializableCache:u||null};var p}(e),this.logger=new Tt(this.config.loggerOptions,It,At),this.cryptoUtils=this.config.cryptoInterface,this.cacheManager=this.config.storageInterface,this.networkClient=this.config.networkInterface,this.networkManager=new on(this.networkClient,this.cacheManager),this.serverTelemetryManager=this.config.serverTelemetryManager,this.authority=this.config.authOptions.authority,this.performanceClient=t}createTokenRequestHeaders(e){const r={};if(r[c]=t.URL_FORM_CONTENT_TYPE,!this.config.systemOptions.preventCorsPreflight&&e)switch(e.type){case an:try{const t=Ar(e.credential);r[h]=`Oid:${t.uid}@${t.utid}`}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case sn:r[h]=`UPN: ${e.credential}`}return r}async executePostToTokenEndpoint(e,t,r,n,o,i){i&&this.performanceClient?.addQueueMeasurement(i,o);const a=await this.networkManager.sendPostRequest(n,e,{body:t,headers:r});return this.performanceClient?.addFields({refreshTokenSize:a.body.refresh_token?.length||0,httpVerToken:a.headers?.[p]||""},o),this.config.serverTelemetryManager&&a.status<500&&429!==a.status&&this.config.serverTelemetryManager.clearTelemetryCache(),a}async updateAuthority(e,t){this.performanceClient?.addQueueMeasurement(fn.UpdateTokenEndpointAuthority,t);const r=`https://${e}/${this.authority.tenant}/`,n=await Rn(r,this.networkClient,this.cacheManager,this.authority.options,this.logger,t,this.performanceClient);this.authority=n}createTokenQueryParameters(e){const t=new mn;return e.tokenQueryParameters&&t.addExtraQueryParameters(e.tokenQueryParameters),t.createQueryString()}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const _n="no_tokens_found",Pn="native_account_unavailable",Mn="refresh_token_expired",Nn="interaction_required",On="consent_required",qn="login_required",Ln="bad_token";var Un=Object.freeze({__proto__:null,badToken:Ln,consentRequired:On,interactionRequired:Nn,loginRequired:qn,nativeAccountUnavailable:Pn,noTokensFound:_n,refreshTokenExpired:Mn});
/*! @azure/msal-common v14.15.0 2024-10-08 */const Hn=[Nn,On,qn,Ln],Bn=["message_only","additional_action","basic_action","user_password_expired","consent_required","bad_token"],xn={[_n]:"No refresh token found in the cache. Please sign-in.",[Pn]:"The requested account is not available in the native broker. It may have been deleted or logged out. Please sign-in again using an interactive API.",[Mn]:"Refresh token has expired.",[Ln]:"Identity provider returned bad_token due to an expired or invalid refresh token. Please invoke an interactive API to resolve."},Dn={noTokensFoundError:{code:_n,desc:xn[_n]},native_account_unavailable:{code:Pn,desc:xn[Pn]},bad_token:{code:Ln,desc:xn[Ln]}};class Fn extends Ie{constructor(e,r,n,o,i,a,s,c){super(e,r,n),Object.setPrototypeOf(this,Fn.prototype),this.timestamp=o||t.EMPTY_STRING,this.traceId=i||t.EMPTY_STRING,this.correlationId=a||t.EMPTY_STRING,this.claims=s||t.EMPTY_STRING,this.name="InteractionRequiredAuthError",this.errorNo=c}}function Kn(e,t,r){const n=!!e&&Hn.indexOf(e)>-1,o=!!r&&Bn.indexOf(r)>-1,i=!!t&&Hn.some((e=>t.indexOf(e)>-1));return n||i||o}function zn(e){return new Fn(e,xn[e])}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Gn{static setRequestState(e,r,n){const o=Gn.generateLibraryState(e,n);return r?`${o}${t.RESOURCE_DELIM}${r}`:o}static generateLibraryState(e,t){if(!e)throw Ct(Je);const r={id:e.createNewGuid()};t&&(r.meta=t);const n=JSON.stringify(r);return e.base64Encode(n)}static parseRequestState(e,r){if(!e)throw Ct(Je);if(!r)throw Ct(Me);try{const n=r.split(t.RESOURCE_DELIM),o=n[0],i=n.length>1?n.slice(1).join(t.RESOURCE_DELIM):t.EMPTY_STRING,a=e.base64Decode(o),s=JSON.parse(a);return{userRequestState:i||t.EMPTY_STRING,libraryState:s}}catch(e){throw Ct(Me)}}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const $n="sw";class Qn{constructor(e,t){this.cryptoUtils=e,this.performanceClient=t}async generateCnf(e,t){this.performanceClient?.addQueueMeasurement(fn.PopTokenGenerateCnf,e.correlationId);const r=await An(this.generateKid.bind(this),fn.PopTokenGenerateCnf,t,this.performanceClient,e.correlationId)(e),n=this.cryptoUtils.base64UrlEncode(JSON.stringify(r));return{kid:r.kid,reqCnfString:n}}async generateKid(e){this.performanceClient?.addQueueMeasurement(fn.PopTokenGenerateKid,e.correlationId);return{kid:await this.cryptoUtils.getPublicKeyThumbprint(e),xms_ksl:$n}}async signPopToken(e,t,r){return this.signPayload(e,t,r)}async signPayload(e,t,r,n){const{resourceRequestMethod:o,resourceRequestUri:i,shrClaims:a,shrNonce:s,shrOptions:c}=r,l=i?new Lr(i):void 0,h=l?.getUrlComponents();return this.cryptoUtils.signJwt({at:e,ts:Et(),m:o?.toUpperCase(),u:h?.HostNameAndPort,nonce:s||this.cryptoUtils.createNewGuid(),p:h?.AbsolutePath,q:h?.QueryString?[[],h.QueryString]:void 0,client_claims:a||void 0,...n},t,c,r.correlationId)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Wn{constructor(e,t){this.cache=e,this.hasChanged=t}get cacheHasChanged(){return this.hasChanged}get tokenCache(){return this.cache}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class jn{constructor(e,t,r,n,o,i,a){this.clientId=e,this.cacheStorage=t,this.cryptoObj=r,this.logger=n,this.serializableCache=o,this.persistencePlugin=i,this.performanceClient=a}validateServerAuthorizationCodeResponse(e,t){if(!e.state||!t)throw e.state?Ct(Oe,"Cached State"):Ct(Oe,"Server State");let r,n;try{r=decodeURIComponent(e.state)}catch(t){throw Ct(Me,e.state)}try{n=decodeURIComponent(t)}catch(t){throw Ct(Me,e.state)}if(r!==n)throw Ct(Ne);if(e.error||e.error_description||e.suberror){const t=function(e){const t="code=",r=e.error_uri?.lastIndexOf(t);return r&&r>=0?e.error_uri?.substring(r+5):void 0}(e);if(Kn(e.error,e.error_description,e.suberror))throw new Fn(e.error||"",e.error_description,e.suberror,e.timestamp||"",e.trace_id||"",e.correlation_id||"",e.claims||"",t);throw new rn(e.error||"",e.error_description,e.suberror,t)}}validateTokenResponse(e,a){if(e.error||e.error_description||e.suberror){const s=`Error(s): ${e.error_codes||t.NOT_AVAILABLE} - Timestamp: ${e.timestamp||t.NOT_AVAILABLE} - Description: ${e.error_description||t.NOT_AVAILABLE} - Correlation ID: ${e.correlation_id||t.NOT_AVAILABLE} - Trace ID: ${e.trace_id||t.NOT_AVAILABLE}`,c=e.error_codes?.length?e.error_codes[0]:void 0,l=new rn(e.error,s,e.suberror,c,e.status);if(a&&e.status&&e.status>=o&&e.status<=i)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently unavailable and the access token is unable to be refreshed.\n${l}`);if(a&&e.status&&e.status>=r&&e.status<=n)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently available but is unable to refresh the access token.\n${l}`);if(Kn(e.error,e.error_description,e.suberror))throw new Fn(e.error,e.error_description,e.suberror,e.timestamp||t.EMPTY_STRING,e.trace_id||t.EMPTY_STRING,e.correlation_id||t.EMPTY_STRING,e.claims||t.EMPTY_STRING,c);throw l}}async handleServerTokenResponse(e,r,n,o,i,a,s,c,l){let h,d;if(this.performanceClient?.addQueueMeasurement(fn.HandleServerTokenResponse,e.correlation_id),e.id_token){if(h=kt(e.id_token||t.EMPTY_STRING,this.cryptoObj.base64Decode),i&&i.nonce&&h.nonce!==i.nonce)throw Ct(qe);if(o.maxAge||0===o.maxAge){const e=h.auth_time;if(!e)throw Ct(Le);St(e,o.maxAge)}}this.homeAccountIdentifier=Nr.generateHomeAccountId(e.client_info||t.EMPTY_STRING,r.authorityType,this.logger,this.cryptoObj,h),i&&i.state&&(d=Gn.parseRequestState(this.cryptoObj,i.state)),e.key_id=e.key_id||o.sshKid||void 0;const u=this.generateCacheRecord(e,r,n,o,h,a,i);let g;try{if(this.persistencePlugin&&this.serializableCache&&(this.logger.verbose("Persistence enabled, calling beforeCacheAccess"),g=new Wn(this.serializableCache,!0),await this.persistencePlugin.beforeCacheAccess(g)),s&&!c&&u.account){const e=u.account.generateAccountKey();if(!this.cacheStorage.getAccount(e,this.logger))return this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache"),await jn.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,h,d,void 0,l)}await this.cacheStorage.saveCacheRecord(u,o.storeInCache,o.correlationId)}finally{this.persistencePlugin&&this.serializableCache&&g&&(this.logger.verbose("Persistence enabled, calling afterCacheAccess"),await this.persistencePlugin.afterCacheAccess(g))}return jn.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,h,d,e,l)}generateCacheRecord(e,t,r,n,o,i,a){const s=t.getPreferredCache();if(!s)throw Ct(Ve);const c=Pr(o);let l,h;e.id_token&&o&&(l=Pt(this.homeAccountIdentifier,s,e.id_token,this.clientId,c||""),h=Vn(this.cacheStorage,t,this.homeAccountIdentifier,this.cryptoObj.base64Decode,o,e.client_info,s,c,a,void 0,this.logger));let d=null;if(e.access_token){const o=e.scope?Tr.fromString(e.scope):new Tr(n.scopes||[]),a=("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0,l=("string"==typeof e.ext_expires_in?parseInt(e.ext_expires_in,10):e.ext_expires_in)||0,h=("string"==typeof e.refresh_in?parseInt(e.refresh_in,10):e.refresh_in)||void 0,u=r+a,g=u+l,p=h&&h>0?r+h:void 0;d=Mt(this.homeAccountIdentifier,s,e.access_token,this.clientId,c||t.tenant||"",o.printScopes(),u,g,this.cryptoObj.base64Decode,p,e.token_type,i,e.key_id,n.claims,n.requestedClaimsHash)}let u=null;if(e.refresh_token){let t;if(e.refresh_token_expires_in){t=r+("string"==typeof e.refresh_token_expires_in?parseInt(e.refresh_token_expires_in,10):e.refresh_token_expires_in)}u=Nt(this.homeAccountIdentifier,s,e.refresh_token,this.clientId,e.foci,i,t)}let g=null;return e.foci&&(g={clientId:this.clientId,environment:s,familyId:e.foci}),{account:h,idToken:l,accessToken:d,refreshToken:u,appMetadata:g}}static async generateAuthenticationResult(e,r,n,o,i,a,s,c,l){let h,d,u=t.EMPTY_STRING,g=[],p=null,m=t.EMPTY_STRING;if(n.accessToken){if(n.accessToken.tokenType!==W.POP||i.popKid)u=n.accessToken.secret;else{const t=new Qn(e),{secret:r,keyId:o}=n.accessToken;if(!o)throw Ct(st);u=await t.signPopToken(r,o,i)}g=Tr.fromString(n.accessToken.target).asArray(),p=new Date(1e3*Number(n.accessToken.expiresOn)),h=new Date(1e3*Number(n.accessToken.extendedExpiresOn)),n.accessToken.refreshOn&&(d=new Date(1e3*Number(n.accessToken.refreshOn)))}n.appMetadata&&(m=n.appMetadata.familyId===x?x:"");const f=a?.oid||a?.sub||"",C=a?.tid||"";c?.spa_accountid&&n.account&&(n.account.nativeAccountId=c?.spa_accountid);const y=n.account?Sr(n.account.getAccountInfo(),void 0,a,n.idToken?.secret):null;return{authority:r.canonicalAuthority,uniqueId:f,tenantId:C,scopes:g,account:y,idToken:n?.idToken?.secret||"",idTokenClaims:a||{},accessToken:u,fromCache:o,expiresOn:p,extExpiresOn:h,refreshOn:d,correlationId:i.correlationId,requestId:l||t.EMPTY_STRING,familyId:m,tokenType:n.accessToken?.tokenType||t.EMPTY_STRING,state:s?s.userRequestState:t.EMPTY_STRING,cloudGraphHostName:n.account?.cloudGraphHostName||t.EMPTY_STRING,msGraphHost:n.account?.msGraphHost||t.EMPTY_STRING,code:c?.spa_code,fromNativeBroker:!1}}}function Vn(e,t,r,n,o,i,a,s,c,l,h){h?.verbose("setCachedAccount called");const d=e.getAccountKeys().find((e=>e.startsWith(r)));let u=null;d&&(u=e.getAccount(d,h));const g=u||Nr.createAccount({homeAccountId:r,idTokenClaims:o,clientInfo:i,environment:a,cloudGraphHostName:c?.cloud_graph_host_name,msGraphHost:c?.msgraph_host,nativeAccountId:l},t,n),p=g.tenantProfiles||[],m=s||g.realm;if(m&&!p.find((e=>e.tenantId===m))){const e=kr(r,g.localAccountId,m,o);p.push(e)}return g.tenantProfiles=p,g}
/*! @azure/msal-common v14.15.0 2024-10-08 */async function Yn(e,t,r){if("string"==typeof e)return e;return e({clientId:t,tokenEndpoint:r})}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Jn extends bn{constructor(e,t){super(e,t),this.includeRedirectUri=!0,this.oidcDefaultScopes=this.config.authOptions.authority.options.OIDCOptions?.defaultScopes}async getAuthCodeUrl(e){this.performanceClient?.addQueueMeasurement(fn.GetAuthCodeUrl,e.correlationId);const t=await An(this.createAuthCodeUrlQueryString.bind(this),fn.AuthClientCreateQueryString,this.logger,this.performanceClient,e.correlationId)(e);return Lr.appendQueryString(this.authority.authorizationEndpoint,t)}async acquireToken(e,t){if(this.performanceClient?.addQueueMeasurement(fn.AuthClientAcquireToken,e.correlationId),!e.code)throw Ct(De);const r=Et(),n=await An(this.executeTokenRequest.bind(this),fn.AuthClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(this.authority,e),o=n.headers?.[g],i=new jn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin,this.performanceClient);return i.validateTokenResponse(n.body),An(i.handleServerTokenResponse.bind(i),fn.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(n.body,this.authority,r,e,t,void 0,void 0,void 0,o)}handleFragmentResponse(e,t){if(new jn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,null,null).validateServerAuthorizationCodeResponse(e,t),!e.code)throw Ct(ot);return e}getLogoutUri(e){if(!e)throw yr(tr);const t=this.createLogoutUrlQueryString(e);return Lr.appendQueryString(this.authority.endSessionEndpoint,t)}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(fn.AuthClientExecuteTokenRequest,t.correlationId);const r=this.createTokenQueryParameters(t),n=Lr.appendQueryString(e.tokenEndpoint,r),o=await An(this.createTokenRequestBody.bind(this),fn.AuthClientCreateTokenRequestBody,this.logger,this.performanceClient,t.correlationId)(t);let i;if(t.clientInfo)try{const e=Ir(t.clientInfo,this.cryptoUtils.base64Decode);i={credential:`${e.uid}${U.CLIENT_INFO_SEPARATOR}${e.utid}`,type:an}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}const a=this.createTokenRequestHeaders(i||t.ccsCredential),s={clientId:t.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:e.canonicalAuthority,scopes:t.scopes,claims:t.claims,authenticationScheme:t.authenticationScheme,resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,sshKid:t.sshKid};return An(this.executePostToTokenEndpoint.bind(this),fn.AuthorizationCodeClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,t.correlationId)(n,o,a,s,t.correlationId,fn.AuthorizationCodeClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(fn.AuthClientCreateTokenRequestBody,e.correlationId);const t=new mn;if(t.addClientId(e.tokenBodyParameters?.[cn]||this.config.authOptions.clientId),this.includeRedirectUri?t.addRedirectUri(e.redirectUri):pn.validateRedirectUri(e.redirectUri),t.addScopes(e.scopes,!0,this.oidcDefaultScopes),t.addAuthorizationCode(e.code),t.addLibraryInfo(this.config.libraryInfo),t.addApplicationTelemetry(this.config.telemetry.application),t.addThrottling(),this.serverTelemetryManager&&!tn(this.config)&&t.addServerTelemetry(this.serverTelemetryManager),e.codeVerifier&&t.addCodeVerifier(e.codeVerifier),this.config.clientCredentials.clientSecret&&t.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const r=this.config.clientCredentials.clientAssertion;t.addClientAssertion(await Yn(r.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),t.addClientAssertionType(r.assertionType)}if(t.addGrantType(M),t.addClientInfo(),e.authenticationScheme===W.POP){const r=new Qn(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await An(r.generateCnf.bind(r),fn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}t.addPopToken(n)}else if(e.authenticationScheme===W.SSH){if(!e.sshJwk)throw yr(sr);t.addSshJwk(e.sshJwk)}const r=e.correlationId||this.config.cryptoInterface.createNewGuid();let n;if(t.addCorrelationId(r),(!vr.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.clientInfo)try{const t=Ir(e.clientInfo,this.cryptoUtils.base64Decode);n={credential:`${t.uid}${U.CLIENT_INFO_SEPARATOR}${t.utid}`,type:an}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}else n=e.ccsCredential;if(this.config.systemOptions.preventCorsPreflight&&n)switch(n.type){case an:try{const e=Ar(n.credential);t.addCcsOid(e)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case sn:t.addCcsUpn(n.credential)}return e.tokenBodyParameters&&t.addExtraQueryParameters(e.tokenBodyParameters),!e.enableSpaAuthorizationCode||e.tokenBodyParameters&&e.tokenBodyParameters[un]||t.addExtraQueryParameters({[un]:"1"}),t.createQueryString()}async createAuthCodeUrlQueryString(e){this.performanceClient?.addQueueMeasurement(fn.AuthClientCreateQueryString,e.correlationId);const t=new mn;t.addClientId(e.extraQueryParameters?.[cn]||this.config.authOptions.clientId);const r=[...e.scopes||[],...e.extraScopesToConsent||[]];t.addScopes(r,!0,this.oidcDefaultScopes),t.addRedirectUri(e.redirectUri);const n=e.correlationId||this.config.cryptoInterface.createNewGuid();if(t.addCorrelationId(n),t.addResponseMode(e.responseMode),t.addResponseTypeCode(),t.addLibraryInfo(this.config.libraryInfo),tn(this.config)||t.addApplicationTelemetry(this.config.telemetry.application),t.addClientInfo(),e.codeChallenge&&e.codeChallengeMethod&&t.addCodeChallengeParams(e.codeChallenge,e.codeChallengeMethod),e.prompt&&t.addPrompt(e.prompt),e.domainHint&&t.addDomainHint(e.domainHint),e.prompt!==R.SELECT_ACCOUNT)if(e.sid&&e.prompt===R.NONE)this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from request"),t.addSid(e.sid);else if(e.account){const r=this.extractAccountSid(e.account);let n=this.extractLoginHint(e.account);if(n&&e.domainHint&&(this.logger.warning('AuthorizationCodeClient.createAuthCodeUrlQueryString: "domainHint" param is set, skipping opaque "login_hint" claim. Please consider not passing domainHint'),n=null),n){this.logger.verbose("createAuthCodeUrlQueryString: login_hint claim present on account"),t.addLoginHint(n);try{const r=Ar(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(r&&e.prompt===R.NONE){this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from account"),t.addSid(r);try{const r=Ar(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(e.loginHint)this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from request"),t.addLoginHint(e.loginHint),t.addCcsUpn(e.loginHint);else if(e.account.username){this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from account"),t.addLoginHint(e.account.username);try{const r=Ar(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}}else e.loginHint&&(this.logger.verbose("createAuthCodeUrlQueryString: No account, adding login_hint from request"),t.addLoginHint(e.loginHint),t.addCcsUpn(e.loginHint));else this.logger.verbose("createAuthCodeUrlQueryString: Prompt is select_account, ignoring account hints");if(e.nonce&&t.addNonce(e.nonce),e.state&&t.addState(e.state),(e.claims||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),this.addExtraQueryParams(e,t),e.nativeBroker&&(t.addNativeBroker(),e.authenticationScheme===W.POP)){const r=new Qn(this.cryptoUtils);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await An(r.generateCnf.bind(r),fn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}t.addPopToken(n)}return t.createQueryString()}createLogoutUrlQueryString(e){const t=new mn;return e.postLogoutRedirectUri&&t.addPostLogoutRedirectUri(e.postLogoutRedirectUri),e.correlationId&&t.addCorrelationId(e.correlationId),e.idTokenHint&&t.addIdTokenHint(e.idTokenHint),e.state&&t.addState(e.state),e.logoutHint&&t.addLogoutHint(e.logoutHint),this.addExtraQueryParams(e,t),t.createQueryString()}addExtraQueryParams(e,t){!(e.extraQueryParameters&&e.extraQueryParameters.hasOwnProperty("instance_aware"))&&this.config.authOptions.instanceAware&&(e.extraQueryParameters=e.extraQueryParameters||{},e.extraQueryParameters.instance_aware="true"),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters)}extractAccountSid(e){return e.idTokenClaims?.sid||null}extractLoginHint(e){return e.idTokenClaims?.login_hint||null}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Xn extends bn{constructor(e,t){super(e,t)}async acquireToken(e){this.performanceClient?.addQueueMeasurement(fn.RefreshTokenClientAcquireToken,e.correlationId);const t=Et(),r=await An(this.executeTokenRequest.bind(this),fn.RefreshTokenClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(e,this.authority),n=r.headers?.[g],o=new jn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin);return o.validateTokenResponse(r.body),An(o.handleServerTokenResponse.bind(o),fn.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(r.body,this.authority,t,e,void 0,void 0,!0,e.forceCache,n)}async acquireTokenByRefreshToken(e){if(!e)throw yr(er);if(this.performanceClient?.addQueueMeasurement(fn.RefreshTokenClientAcquireTokenByRefreshToken,e.correlationId),!e.account)throw Ct(We);if(this.cacheManager.isAppMetadataFOCI(e.account.environment))try{return await An(this.acquireTokenWithCachedRefreshToken.bind(this),fn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!0)}catch(t){const r=t instanceof Fn&&t.errorCode===_n,n=t instanceof rn&&t.errorCode===X&&t.subError===Z;if(r||n)return An(this.acquireTokenWithCachedRefreshToken.bind(this),fn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1);throw t}return An(this.acquireTokenWithCachedRefreshToken.bind(this),fn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1)}async acquireTokenWithCachedRefreshToken(e,t){this.performanceClient?.addQueueMeasurement(fn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,e.correlationId);const r=In(this.cacheManager.getRefreshToken.bind(this.cacheManager),fn.CacheManagerGetRefreshToken,this.logger,this.performanceClient,e.correlationId)(e.account,t,void 0,this.performanceClient,e.correlationId);if(!r)throw zn(_n);if(r.expiresOn&&Rt(r.expiresOn,e.refreshTokenExpirationOffsetSeconds||300))throw zn(Mn);const n={...e,refreshToken:r.secret,authenticationScheme:e.authenticationScheme||W.BEARER,ccsCredential:{credential:e.account.homeAccountId,type:an}};try{return await An(this.acquireToken.bind(this),fn.RefreshTokenClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(n)}catch(e){if(e instanceof Fn&&e.subError===Ln){this.logger.verbose("acquireTokenWithRefreshToken: bad refresh token, removing from cache");const e=_t(r);this.cacheManager.removeRefreshToken(e)}throw e}}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(fn.RefreshTokenClientExecuteTokenRequest,e.correlationId);const r=this.createTokenQueryParameters(e),n=Lr.appendQueryString(t.tokenEndpoint,r),o=await An(this.createTokenRequestBody.bind(this),fn.RefreshTokenClientCreateTokenRequestBody,this.logger,this.performanceClient,e.correlationId)(e),i=this.createTokenRequestHeaders(e.ccsCredential),a={clientId:e.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:t.canonicalAuthority,scopes:e.scopes,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid};return An(this.executePostToTokenEndpoint.bind(this),fn.RefreshTokenClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,e.correlationId)(n,o,i,a,e.correlationId,fn.RefreshTokenClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(fn.RefreshTokenClientCreateTokenRequestBody,e.correlationId);const t=e.correlationId,r=new mn;if(r.addClientId(e.tokenBodyParameters?.[cn]||this.config.authOptions.clientId),e.redirectUri&&r.addRedirectUri(e.redirectUri),r.addScopes(e.scopes,!0,this.config.authOptions.authority.options.OIDCOptions?.defaultScopes),r.addGrantType(N),r.addClientInfo(),r.addLibraryInfo(this.config.libraryInfo),r.addApplicationTelemetry(this.config.telemetry.application),r.addThrottling(),this.serverTelemetryManager&&!tn(this.config)&&r.addServerTelemetry(this.serverTelemetryManager),r.addCorrelationId(t),r.addRefreshToken(e.refreshToken),this.config.clientCredentials.clientSecret&&r.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const t=this.config.clientCredentials.clientAssertion;r.addClientAssertion(await Yn(t.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),r.addClientAssertionType(t.assertionType)}if(e.authenticationScheme===W.POP){const t=new Qn(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await An(t.generateCnf.bind(t),fn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}r.addPopToken(n)}else if(e.authenticationScheme===W.SSH){if(!e.sshJwk)throw yr(sr);r.addSshJwk(e.sshJwk)}if((!vr.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&r.addClaims(e.claims,this.config.authOptions.clientCapabilities),this.config.systemOptions.preventCorsPreflight&&e.ccsCredential)switch(e.ccsCredential.type){case an:try{const t=Ar(e.ccsCredential.credential);r.addCcsOid(t)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case sn:r.addCcsUpn(e.ccsCredential.credential)}return e.tokenBodyParameters&&r.addExtraQueryParameters(e.tokenBodyParameters),r.createQueryString()}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class Zn extends bn{constructor(e,t){super(e,t)}async acquireToken(e){try{const[t,r]=await this.acquireCachedToken({...e,scopes:e.scopes?.length?e.scopes:[...a]});if(r===pe){this.logger.info("SilentFlowClient:acquireCachedToken - Cached access token's refreshOn property has been exceeded'. It's not expired, but must be refreshed.");new Xn(this.config,this.performanceClient).acquireTokenByRefreshToken(e).catch((()=>{}))}return t}catch(t){if(t instanceof ft&&t.errorCode===tt){return new Xn(this.config,this.performanceClient).acquireTokenByRefreshToken(e)}throw t}}async acquireCachedToken(e){this.performanceClient?.addQueueMeasurement(fn.SilentFlowClientAcquireCachedToken,e.correlationId);let t=he;if(e.forceRefresh||!this.config.cacheOptions.claimsBasedCachingEnabled&&!vr.isEmptyObj(e.claims))throw this.setCacheOutcome(de,e.correlationId),Ct(tt);if(!e.account)throw Ct(We);const r=e.account.tenantId||function(e){const t=new Lr(e).getUrlComponents(),r=t.PathSegments.slice(-1)[0]?.toLowerCase();switch(r){case A:case w:case k:return;default:return r}}(e.authority),n=this.cacheManager.getTokenKeys(),o=this.cacheManager.getAccessToken(e.account,e,n,r,this.performanceClient,e.correlationId);if(!o)throw this.setCacheOutcome(ue,e.correlationId),Ct(tt);if(bt(o.cachedAt)||Rt(o.expiresOn,this.config.systemOptions.tokenRenewalOffsetSeconds))throw this.setCacheOutcome(ge,e.correlationId),Ct(tt);o.refreshOn&&Rt(o.refreshOn,0)&&(t=pe);const i=e.authority||this.authority.getPreferredCache(),a={account:this.cacheManager.readAccountFromCache(e.account),accessToken:o,idToken:this.cacheManager.getIdToken(e.account,n,r,this.performanceClient,e.correlationId),refreshToken:null,appMetadata:this.cacheManager.readAppMetadataFromCache(i)};return this.setCacheOutcome(t,e.correlationId),this.config.serverTelemetryManager&&this.config.serverTelemetryManager.incrementCacheHits(),[await An(this.generateResultFromCacheRecord.bind(this),fn.SilentFlowClientGenerateResultFromCacheRecord,this.logger,this.performanceClient,e.correlationId)(a,e),t]}setCacheOutcome(e,t){this.serverTelemetryManager?.setCacheOutcome(e),this.performanceClient?.addFields({cacheOutcome:e},t),e!==he&&this.logger.info(`Token refresh is required due to cache outcome: ${e}`)}async generateResultFromCacheRecord(e,t){let r;if(this.performanceClient?.addQueueMeasurement(fn.SilentFlowClientGenerateResultFromCacheRecord,t.correlationId),e.idToken&&(r=kt(e.idToken.secret,this.config.cryptoInterface.base64Decode)),t.maxAge||0===t.maxAge){const e=r?.auth_time;if(!e)throw Ct(Le);St(e,t.maxAge)}return jn.generateAuthenticationResult(this.cryptoUtils,this.authority,e,!0,t,r)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const eo={sendGetRequestAsync:()=>Promise.reject(Ct(dt)),sendPostRequestAsync:()=>Promise.reject(Ct(dt))};
/*! @azure/msal-common v14.15.0 2024-10-08 */
/*! @azure/msal-common v14.15.0 2024-10-08 */
const to="|";function ro(e){const{skus:t,libraryName:r,libraryVersion:n,extensionName:o,extensionVersion:i}=e,a=new Map([[0,[r,n]],[2,[o,i]]]);let s=[];if(t?.length){if(s=t.split(","),s.length<4)return t}else s=Array.from({length:4},(()=>to));return a.forEach(((e,t)=>{2===e.length&&e[0]?.length&&e[1]?.length&&function(e){const{skuArr:t,index:r,skuName:n,skuVersion:o}=e;if(r>=t.length)return;t[r]=[n,o].join(to)}({skuArr:s,index:t,skuName:e[0],skuVersion:e[1]})})),s.join(",")}class no{constructor(e,r){this.cacheOutcome=he,this.cacheManager=r,this.apiId=e.apiId,this.correlationId=e.correlationId,this.wrapperSKU=e.wrapperSKU||t.EMPTY_STRING,this.wrapperVer=e.wrapperVer||t.EMPTY_STRING,this.telemetryCacheKey=Q.CACHE_KEY+U.CACHE_KEY_SEPARATOR+e.clientId}generateCurrentRequestHeaderValue(){const e=`${this.apiId}${Q.VALUE_SEPARATOR}${this.cacheOutcome}`,t=[this.wrapperSKU,this.wrapperVer],r=this.getNativeBrokerErrorCode();r?.length&&t.push(`broker_error=${r}`);const n=t.join(Q.VALUE_SEPARATOR),o=[e,this.getRegionDiscoveryFields()].join(Q.VALUE_SEPARATOR);return[Q.SCHEMA_VERSION,o,n].join(Q.CATEGORY_SEPARATOR)}generateLastRequestHeaderValue(){const e=this.getLastRequests(),t=no.maxErrorsToSend(e),r=e.failedRequests.slice(0,2*t).join(Q.VALUE_SEPARATOR),n=e.errors.slice(0,t).join(Q.VALUE_SEPARATOR),o=e.errors.length,i=[o,t<o?Q.OVERFLOW_TRUE:Q.OVERFLOW_FALSE].join(Q.VALUE_SEPARATOR);return[Q.SCHEMA_VERSION,e.cacheHits,r,n,i].join(Q.CATEGORY_SEPARATOR)}cacheFailedRequest(e){const t=this.getLastRequests();t.errors.length>=Q.MAX_CACHED_ERRORS&&(t.failedRequests.shift(),t.failedRequests.shift(),t.errors.shift()),t.failedRequests.push(this.apiId,this.correlationId),e instanceof Error&&e&&e.toString()?e instanceof Ie?e.subError?t.errors.push(e.subError):e.errorCode?t.errors.push(e.errorCode):t.errors.push(e.toString()):t.errors.push(e.toString()):t.errors.push(Q.UNKNOWN_ERROR),this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}incrementCacheHits(){const e=this.getLastRequests();return e.cacheHits+=1,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e),e.cacheHits}getLastRequests(){return this.cacheManager.getServerTelemetry(this.telemetryCacheKey)||{failedRequests:[],errors:[],cacheHits:0}}clearTelemetryCache(){const e=this.getLastRequests(),t=no.maxErrorsToSend(e);if(t===e.errors.length)this.cacheManager.removeItem(this.telemetryCacheKey);else{const r={failedRequests:e.failedRequests.slice(2*t),errors:e.errors.slice(t),cacheHits:0};this.cacheManager.setServerTelemetry(this.telemetryCacheKey,r)}}static maxErrorsToSend(e){let r,n=0,o=0;const i=e.errors.length;for(r=0;r<i;r++){const i=e.failedRequests[2*r]||t.EMPTY_STRING,a=e.failedRequests[2*r+1]||t.EMPTY_STRING,s=e.errors[r]||t.EMPTY_STRING;if(o+=i.toString().length+a.toString().length+s.length+3,!(o<Q.MAX_LAST_HEADER_BYTES))break;n+=1}return n}getRegionDiscoveryFields(){const e=[];return e.push(this.regionUsed||t.EMPTY_STRING),e.push(this.regionSource||t.EMPTY_STRING),e.push(this.regionOutcome||t.EMPTY_STRING),e.join(",")}updateRegionDiscoveryMetadata(e){this.regionUsed=e.region_used,this.regionSource=e.region_source,this.regionOutcome=e.region_outcome}setCacheOutcome(e){this.cacheOutcome=e}setNativeBrokerErrorCode(e){const t=this.getLastRequests();t.nativeBrokerErrorCode=e,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}getNativeBrokerErrorCode(){return this.getLastRequests().nativeBrokerErrorCode}clearNativeBrokerErrorCode(){const e=this.getLastRequests();delete e.nativeBrokerErrorCode,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e)}static makeExtraSkuString(e){return ro(e)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */const oo="missing_kid_error",io="missing_alg_error",ao={[oo]:"The JOSE Header for the requested JWT, JWS or JWK object requires a keyId to be configured as the 'kid' header claim. No 'kid' value was provided.",[io]:"The JOSE Header for the requested JWT, JWS or JWK object requires an algorithm to be specified as the 'alg' header claim. No 'alg' value was provided."};class so extends Ie{constructor(e,t){super(e,t),this.name="JoseHeaderError",Object.setPrototypeOf(this,so.prototype)}}function co(e){return new so(e,ao[e])}
/*! @azure/msal-common v14.15.0 2024-10-08 */class lo{constructor(e){this.typ=e.typ,this.alg=e.alg,this.kid=e.kid}static getShrHeaderString(e){if(!e.kid)throw co(oo);if(!e.alg)throw co(io);const t=new lo({typ:e.typ||me.Pop,kid:e.kid,alg:e.alg});return JSON.stringify(t)}}
/*! @azure/msal-common v14.15.0 2024-10-08 */class ho{startMeasurement(){}endMeasurement(){}flushMeasurement(){return null}}class uo{generateId(){return"callback-id"}startMeasurement(e,t){return{end:()=>null,discard:()=>{},add:()=>{},increment:()=>{},event:{eventId:this.generateId(),status:yn,authority:"",libraryName:"",libraryVersion:"",clientId:"",name:e,startTimeMs:Date.now(),correlationId:t||""},measurement:new ho}}startPerformanceMeasurement(){return new ho}calculateQueuedTime(){return 0}addQueueMeasurement(){}setPreQueueTime(){}endMeasurement(){return null}discardMeasurements(){}removePerformanceCallback(){return!0}addPerformanceCallback(){return""}emitEvents(){}addFields(){}incrementFields(){}cacheEventByCorrelationId(){}}
/*! @azure/msal-common v14.15.0 2024-10-08 */function go(e,t,r,n=5){if(e instanceof Error)return e instanceof Ie?(r.errorCode=e.errorCode,r.subErrorCode=e.subError,void((e instanceof rn||e instanceof Fn)&&(r.serverErrorNo=e.errorNo))):void(e instanceof Gr?r.errorCode=e.errorCode:r.errorStack?.length?t.trace("PerformanceClient.addErrorStack: Stack already exist",r.correlationId):e.stack?.length?(e.stack&&(r.errorStack=function(e,t){if(t<0)return[];const r=e.split("\n")||[];if(r.length<2)return[];const n=[];for(let e=Math.max(r.length-t-1,1);e<r.length;e++){const o=r[e];if(n.length>=t)break;n.push(po(o))}return n}(e.stack,n)),r.errorName=e.name):t.trace("PerformanceClient.addErrorStack: Input stack is empty",r.correlationId));t.trace("PerformanceClient.addErrorStack: Input error is not instance of Error",r.correlationId)}function po(e){const t=e.lastIndexOf(" ")+1;if(t<1)return e;const r=e.substring(t);let n=r.lastIndexOf("/");return n=n<0?r.lastIndexOf("\\"):n,n>=0?(e.substring(0,t)+"("+r.substring(n+1)+(")"===r.charAt(r.length-1)?"":")")).trimStart():e.trimStart()}class mo{constructor(e,t,r,n,o,i,a,s){this.authority=t,this.libraryName=n,this.libraryVersion=o,this.applicationTelemetry=i,this.clientId=e,this.logger=r,this.callbacks=new Map,this.eventsByCorrelationId=new Map,this.eventStack=new Map,this.queueMeasurements=new Map,this.preQueueTimeByCorrelationId=new Map,this.intFields=a||new Set;for(const e of Tn)this.intFields.add(e);this.abbreviations=s||new Map;for(const[e,t]of Cn)this.abbreviations.set(e,t)}startPerformanceMeasurement(e,t){return{}}getPreQueueTime(e,t){const r=this.preQueueTimeByCorrelationId.get(t);if(r){if(r.name===e)return r.time;this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue time found for ${e}, unable to add queue measurement`)}else this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue times found for correlationId: ${t}, unable to add queue measurement`)}calculateQueuedTime(e,t){return e<1?(this.logger.trace(`PerformanceClient: preQueueTime should be a positive integer and not ${e}`),0):t<1?(this.logger.trace(`PerformanceClient: currentTime should be a positive integer and not ${t}`),0):t<e?(this.logger.trace("PerformanceClient: currentTime is less than preQueueTime, check how time is being retrieved"),0):t-e}addQueueMeasurement(e,t,r,n){if(!t)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: correlationId not provided for ${e}, cannot add queue measurement`);if(0===r)this.logger.trace(`PerformanceClient.addQueueMeasurement: queue time provided for ${e} is ${r}`);else if(!r)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: no queue time provided for ${e}`);const o={eventName:e,queueTime:n?0:r,manuallyCompleted:n},i=this.queueMeasurements.get(t);if(i)i.push(o),this.queueMeasurements.set(t,i);else{this.logger.trace(`PerformanceClient.addQueueMeasurement: adding correlationId ${t} to queue measurements`);const e=[o];this.queueMeasurements.set(t,e)}this.preQueueTimeByCorrelationId.delete(t)}startMeasurement(e,t){const r=t||this.generateId();t||this.logger.info(`PerformanceClient: No correlation id provided for ${e}, generating`,r),this.logger.trace(`PerformanceClient: Performance measurement started for ${e}`,r);const n={eventId:this.generateId(),status:yn,authority:this.authority,libraryName:this.libraryName,libraryVersion:this.libraryVersion,clientId:this.clientId,name:e,startTimeMs:Date.now(),correlationId:r,appName:this.applicationTelemetry?.appName,appVersion:this.applicationTelemetry?.appVersion};var o,i,a;return this.cacheEventByCorrelationId(n),o=n,i=this.abbreviations,(a=this.eventStack.get(r))&&a.push({name:i.get(o.name)||o.name}),{end:(e,t)=>this.endMeasurement({...n,...e},t),discard:()=>this.discardMeasurements(n.correlationId),add:e=>this.addFields(e,n.correlationId),increment:e=>this.incrementFields(e,n.correlationId),event:n,measurement:new ho}}endMeasurement(e,t){const r=this.eventsByCorrelationId.get(e.correlationId);if(!r)return this.logger.trace(`PerformanceClient: Measurement not found for ${e.eventId}`,e.correlationId),null;const n=e.eventId===r.eventId;let o={totalQueueTime:0,totalQueueCount:0,manuallyCompletedCount:0};e.durationMs=Math.round(e.durationMs||this.getDurationMs(e.startTimeMs));const i=JSON.stringify(function(e,t,r,n){if(!r?.length)return;const o=e=>e.length?e[e.length-1]:void 0,i=t.get(e.name)||e.name,a=o(r);if(a?.name!==i)return;const s=r?.pop();if(!s)return;const c=n instanceof Ie?n.errorCode:n instanceof Error?n.name:void 0,l=n instanceof Ie?n.subError:void 0;c&&s.childErr!==c&&(s.err=c,l&&(s.subErr=l)),delete s.name,delete s.childErr;const h={...s,dur:e.durationMs};e.success||(h.fail=1);const d=o(r);if(!d)return{[i]:h};let u;if(c&&(d.childErr=c),d[i]){const e=Object.keys(d).filter((e=>e.startsWith(i))).length;u=`${i}_${e+1}`}else u=i;return d[u]=h,d}(e,this.abbreviations,this.eventStack.get(r.correlationId),t));if(n?(o=this.getQueueInfo(e.correlationId),this.discardMeasurements(r.correlationId)):r.incompleteSubMeasurements?.delete(e.eventId),this.logger.trace(`PerformanceClient: Performance measurement ended for ${e.name}: ${e.durationMs} ms`,e.correlationId),!n)return r[e.name+"DurationMs"]=Math.floor(e.durationMs),{...r};t&&go(t,this.logger,r);let a={...r,...e},s=0;return a.incompleteSubMeasurements?.forEach((t=>{this.logger.trace(`PerformanceClient: Incomplete submeasurement ${t.name} found for ${e.name}`,a.correlationId),s++})),a.incompleteSubMeasurements=void 0,a={...a,queuedTimeMs:o.totalQueueTime,queuedCount:o.totalQueueCount,queuedManuallyCompletedCount:o.manuallyCompletedCount,status:vn,incompleteSubsCount:s,context:i},this.truncateIntegralFields(a),this.emitEvents([a],e.correlationId),a}addFields(e,t){this.logger.trace("PerformanceClient: Updating static fields");const r=this.eventsByCorrelationId.get(t);r?this.eventsByCorrelationId.set(t,{...r,...e}):this.logger.trace("PerformanceClient: Event not found for",t)}incrementFields(e,t){this.logger.trace("PerformanceClient: Updating counters");const r=this.eventsByCorrelationId.get(t);if(r)for(const t in e){if(r.hasOwnProperty(t)){if(isNaN(Number(r[t])))return}else r[t]=0;r[t]+=e[t]}else this.logger.trace("PerformanceClient: Event not found for",t)}cacheEventByCorrelationId(e){const t=this.eventsByCorrelationId.get(e.correlationId);t?(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} added/updated`,e.correlationId),t.incompleteSubMeasurements=t.incompleteSubMeasurements||new Map,t.incompleteSubMeasurements.set(e.eventId,{name:e.name,startTimeMs:e.startTimeMs})):(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} started`,e.correlationId),this.eventsByCorrelationId.set(e.correlationId,{...e}),this.eventStack.set(e.correlationId,[]))}getQueueInfo(e){const t=this.queueMeasurements.get(e);t||this.logger.trace(`PerformanceClient: no queue measurements found for for correlationId: ${e}`);let r=0,n=0,o=0;return t?.forEach((e=>{r+=e.queueTime,n++,o+=e.manuallyCompleted?1:0})),{totalQueueTime:r,totalQueueCount:n,manuallyCompletedCount:o}}discardMeasurements(e){this.logger.trace("PerformanceClient: Performance measurements discarded",e),this.eventsByCorrelationId.delete(e),this.logger.trace("PerformanceClient: QueueMeasurements discarded",e),this.queueMeasurements.delete(e),this.logger.trace("PerformanceClient: Pre-queue times discarded",e),this.preQueueTimeByCorrelationId.delete(e),this.logger.trace("PerformanceClient: Event stack discarded",e),this.eventStack.delete(e)}addPerformanceCallback(e){for(const[t,r]of this.callbacks)if(r.toString()===e.toString())return this.logger.warning(`PerformanceClient: Performance callback is already registered with id: ${t}`),t;const t=this.generateId();return this.callbacks.set(t,e),this.logger.verbose(`PerformanceClient: Performance callback registered with id: ${t}`),t}removePerformanceCallback(e){const t=this.callbacks.delete(e);return t?this.logger.verbose(`PerformanceClient: Performance callback ${e} removed.`):this.logger.verbose(`PerformanceClient: Performance callback ${e} not removed.`),t}emitEvents(e,t){this.logger.verbose("PerformanceClient: Emitting performance events",t),this.callbacks.forEach(((r,n)=>{this.logger.trace(`PerformanceClient: Emitting event to callback ${n}`,t),r.apply(null,[e])}))}truncateIntegralFields(e){this.intFields.forEach((t=>{t in e&&"number"==typeof e[t]&&(e[t]=Math.floor(e[t]))}))}getDurationMs(e){const t=Date.now()-e;return t<0?t:0}}const fo="pkce_not_created",Co="crypto_nonexistent",yo="empty_navigate_uri",vo="hash_empty_error",To="no_state_in_hash",Io="hash_does_not_contain_known_properties",Ao="unable_to_parse_state",wo="state_interaction_type_mismatch",ko="interaction_in_progress",So="popup_window_error",Eo="empty_window_error",Ro="user_cancelled",bo="monitor_popup_timeout",_o="monitor_window_timeout",Po="redirect_in_iframe",Mo="block_iframe_reload",No="block_nested_popups",Oo="iframe_closed_prematurely",qo="silent_logout_unsupported",Lo="no_account_error",Uo="silent_prompt_value_error",Ho="no_token_request_cache_error",Bo="unable_to_parse_token_request_cache_error",xo="no_cached_authority_error",Do="auth_request_not_set_error",Fo="invalid_cache_type",Ko="non_browser_environment",zo="database_not_open",Go="no_network_connectivity",$o="post_request_failed",Qo="get_request_failed",Wo="failed_to_parse_response",jo="unable_to_load_token",Vo="crypto_key_not_found",Yo="auth_code_required",Jo="auth_code_or_nativeAccountId_required",Xo="spa_code_and_nativeAccountId_present",Zo="database_unavailable",ei="unable_to_acquire_token_from_native_platform",ti="native_handshake_timeout",ri="native_extension_not_installed",ni="native_connection_not_established",oi="uninitialized_public_client_application",ii="native_prompt_not_supported",ai="invalid_base64_string",si="invalid_pop_token_request";var ci=Object.freeze({__proto__:null,authCodeOrNativeAccountIdRequired:Jo,authCodeRequired:Yo,authRequestNotSetError:Do,blockIframeReload:Mo,blockNestedPopups:No,cryptoKeyNotFound:Vo,cryptoNonExistent:Co,databaseNotOpen:zo,databaseUnavailable:Zo,emptyNavigateUri:yo,emptyWindowError:Eo,failedToParseResponse:Wo,getRequestFailed:Qo,hashDoesNotContainKnownProperties:Io,hashEmptyError:vo,iframeClosedPrematurely:Oo,interactionInProgress:ko,invalidBase64String:ai,invalidCacheType:Fo,invalidPopTokenRequest:si,monitorPopupTimeout:bo,monitorWindowTimeout:_o,nativeConnectionNotEstablished:ni,nativeExtensionNotInstalled:ri,nativeHandshakeTimeout:ti,nativePromptNotSupported:ii,noAccountError:Lo,noCachedAuthorityError:xo,noNetworkConnectivity:Go,noStateInHash:To,noTokenRequestCacheError:Ho,nonBrowserEnvironment:Ko,pkceNotCreated:fo,popupWindowError:So,postRequestFailed:$o,redirectInIframe:Po,silentLogoutUnsupported:qo,silentPromptValueError:Uo,spaCodeAndNativeAccountIdPresent:Xo,stateInteractionTypeMismatch:wo,unableToAcquireTokenFromNativePlatform:ei,unableToLoadToken:jo,unableToParseState:Ao,unableToParseTokenRequestCacheError:Bo,uninitializedPublicClientApplication:oi,userCancelled:Ro});const li="For more visit: aka.ms/msaljs/browser-errors",hi={[fo]:"The PKCE code challenge and verifier could not be generated.",[Co]:"The crypto object or function is not available.",[yo]:"Navigation URI is empty. Please check stack trace for more info.",[vo]:`Hash value cannot be processed because it is empty. Please verify that your redirectUri is not clearing the hash. ${li}`,[To]:"Hash does not contain state. Please verify that the request originated from msal.",[Io]:`Hash does not contain known properites. Please verify that your redirectUri is not changing the hash.  ${li}`,[Ao]:"Unable to parse state. Please verify that the request originated from msal.",[wo]:"Hash contains state but the interaction type does not match the caller.",[ko]:`Interaction is currently in progress. Please ensure that this interaction has been completed before calling an interactive API.   ${li}`,[So]:"Error opening popup window. This can happen if you are using IE or if popups are blocked in the browser.",[Eo]:"window.open returned null or undefined window object.",[Ro]:"User cancelled the flow.",[bo]:`Token acquisition in popup failed due to timeout.  ${li}`,[_o]:`Token acquisition in iframe failed due to timeout.  ${li}`,[Po]:"Redirects are not supported for iframed or brokered applications. Please ensure you are using MSAL.js in a top frame of the window if using the redirect APIs, or use the popup APIs.",[Mo]:`Request was blocked inside an iframe because MSAL detected an authentication response.  ${li}`,[No]:"Request was blocked inside a popup because MSAL detected it was running in a popup.",[Oo]:"The iframe being monitored was closed prematurely.",[qo]:"Silent logout not supported. Please call logoutRedirect or logoutPopup instead.",[Lo]:"No account object provided to acquireTokenSilent and no active account has been set. Please call setActiveAccount or provide an account on the request.",[Uo]:"The value given for the prompt value is not valid for silent requests - must be set to 'none' or 'no_session'.",[Ho]:"No token request found in cache.",[Bo]:"The cached token request could not be parsed.",[xo]:"No cached authority found.",[Do]:"Auth Request not set. Please ensure initiateAuthRequest was called from the InteractionHandler",[Fo]:"Invalid cache type",[Ko]:"Login and token requests are not supported in non-browser environments.",[zo]:"Database is not open!",[Go]:"No network connectivity. Check your internet connection.",[$o]:"Network request failed: If the browser threw a CORS error, check that the redirectUri is registered in the Azure App Portal as type 'SPA'",[Qo]:"Network request failed. Please check the network trace to determine root cause.",[Wo]:"Failed to parse network response. Check network trace.",[jo]:"Error loading token to cache.",[Vo]:"Cryptographic Key or Keypair not found in browser storage.",[Yo]:"An authorization code must be provided (as the `code` property on the request) to this flow.",[Jo]:"An authorization code or nativeAccountId must be provided to this flow.",[Xo]:"Request cannot contain both spa code and native account id.",[Zo]:"IndexedDB, which is required for persistent cryptographic key storage, is unavailable. This may be caused by browser privacy features which block persistent storage in third-party contexts.",[ei]:`Unable to acquire token from native platform.  ${li}`,[ti]:"Timed out while attempting to establish connection to browser extension",[ri]:"Native extension is not installed. If you think this is a mistake call the initialize function.",[ni]:`Connection to native platform has not been established. Please install a compatible browser extension and run initialize().  ${li}`,[oi]:`You must call and await the initialize function before attempting to call any other MSAL API.  ${li}`,[ii]:"The provided prompt is not supported by the native platform. This request should be routed to the web based flow.",[ai]:"Invalid base64 encoded string.",[si]:"Invalid PoP token request. The request should not have both a popKid value and signPopToken set to true."},di={pkceNotGenerated:{code:fo,desc:hi[fo]},cryptoDoesNotExist:{code:Co,desc:hi[Co]},emptyNavigateUriError:{code:yo,desc:hi[yo]},hashEmptyError:{code:vo,desc:hi[vo]},hashDoesNotContainStateError:{code:To,desc:hi[To]},hashDoesNotContainKnownPropertiesError:{code:Io,desc:hi[Io]},unableToParseStateError:{code:Ao,desc:hi[Ao]},stateInteractionTypeMismatchError:{code:wo,desc:hi[wo]},interactionInProgress:{code:ko,desc:hi[ko]},popupWindowError:{code:So,desc:hi[So]},emptyWindowError:{code:Eo,desc:hi[Eo]},userCancelledError:{code:Ro,desc:hi[Ro]},monitorPopupTimeoutError:{code:bo,desc:hi[bo]},monitorIframeTimeoutError:{code:_o,desc:hi[_o]},redirectInIframeError:{code:Po,desc:hi[Po]},blockTokenRequestsInHiddenIframeError:{code:Mo,desc:hi[Mo]},blockAcquireTokenInPopupsError:{code:No,desc:hi[No]},iframeClosedPrematurelyError:{code:Oo,desc:hi[Oo]},silentLogoutUnsupportedError:{code:qo,desc:hi[qo]},noAccountError:{code:Lo,desc:hi[Lo]},silentPromptValueError:{code:Uo,desc:hi[Uo]},noTokenRequestCacheError:{code:Ho,desc:hi[Ho]},unableToParseTokenRequestCacheError:{code:Bo,desc:hi[Bo]},noCachedAuthorityError:{code:xo,desc:hi[xo]},authRequestNotSet:{code:Do,desc:hi[Do]},invalidCacheType:{code:Fo,desc:hi[Fo]},notInBrowserEnvironment:{code:Ko,desc:hi[Ko]},databaseNotOpen:{code:zo,desc:hi[zo]},noNetworkConnectivity:{code:Go,desc:hi[Go]},postRequestFailed:{code:$o,desc:hi[$o]},getRequestFailed:{code:Qo,desc:hi[Qo]},failedToParseNetworkResponse:{code:Wo,desc:hi[Wo]},unableToLoadTokenError:{code:jo,desc:hi[jo]},signingKeyNotFoundInStorage:{code:Vo,desc:hi[Vo]},authCodeRequired:{code:Yo,desc:hi[Yo]},authCodeOrNativeAccountRequired:{code:Jo,desc:hi[Jo]},spaCodeAndNativeAccountPresent:{code:Xo,desc:hi[Xo]},databaseUnavailable:{code:Zo,desc:hi[Zo]},unableToAcquireTokenFromNativePlatform:{code:ei,desc:hi[ei]},nativeHandshakeTimeout:{code:ti,desc:hi[ti]},nativeExtensionNotInstalled:{code:ri,desc:hi[ri]},nativeConnectionNotEstablished:{code:ni,desc:hi[ni]},uninitializedPublicClientApplication:{code:oi,desc:hi[oi]},nativePromptNotSupported:{code:ii,desc:hi[ii]},invalidBase64StringError:{code:ai,desc:hi[ai]},invalidPopTokenRequest:{code:si,desc:hi[si]}};class ui extends Ie{constructor(e){super(e,hi[e]),Object.setPrototypeOf(this,ui.prototype),this.name="BrowserAuthError"}}function gi(e){return new ui(e)}const pi={INTERACTION_IN_PROGRESS_VALUE:"interaction_in_progress",INVALID_GRANT_ERROR:"invalid_grant",POPUP_WIDTH:483,POPUP_HEIGHT:600,POPUP_NAME_PREFIX:"msal",DEFAULT_POLL_INTERVAL_MS:30,MSAL_SKU:"msal.js.browser"},mi="53ee284d-920a-4b59-9d30-a60315b26836",fi="ppnbnpeolgkicgegkbkbjmhlideopiji",Ci="MATS",yi="Handshake",vi="HandshakeResponse",Ti="GetToken",Ii="Response",Ai={LocalStorage:"localStorage",SessionStorage:"sessionStorage",MemoryStorage:"memoryStorage"},wi="GET",ki="POST",Si="authority",Ei="request.state",Ri="nonce.id_token",bi="request.origin",_i="urlHash",Pi="request.params",Mi="interaction.status",Ni="ccs.credential",Oi="request.correlationId",qi="request.native",Li="msal.account.keys",Ui="msal.token.keys",Hi="wrapper.sku",Bi="wrapper.version",xi={acquireTokenRedirect:861,acquireTokenPopup:862,ssoSilent:863,acquireTokenSilent_authCode:864,handleRedirectPromise:865,acquireTokenByCode:866,acquireTokenSilent_silentFlow:61,logout:961,logoutPopup:962};var Di;e.InteractionType=void 0,(Di=e.InteractionType||(e.InteractionType={})).Redirect="redirect",Di.Popup="popup",Di.Silent="silent",Di.None="none";const Fi={Startup:"startup",Login:"login",Logout:"logout",AcquireToken:"acquireToken",SsoSilent:"ssoSilent",HandleRedirect:"handleRedirect",None:"none"},Ki={scopes:a},zi="msal.db",Gi=`${zi}.keys`,$i={Default:0,AccessToken:1,AccessTokenAndRefreshToken:2,RefreshToken:3,RefreshTokenAndNetwork:4,Skip:5},Qi=[$i.Default,$i.Skip,$i.RefreshTokenAndNetwork];function Wi(e){return encodeURIComponent(Vi(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_"))}function ji(e){return Yi(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function Vi(e){return Yi((new TextEncoder).encode(e))}function Yi(e){const t=Array.from(e,(e=>String.fromCodePoint(e))).join("");return btoa(t)}const Ji="SHA-256",Xi=new Uint8Array([1,0,1]),Zi="0123456789abcdef",ea=new Uint32Array(1),ta={name:"RSASSA-PKCS1-v1_5",hash:Ji,modulusLength:2048,publicExponent:Xi};async function ra(e,t,r){t?.addQueueMeasurement(fn.Sha256Digest,r);const n=(new TextEncoder).encode(e);return window.crypto.subtle.digest(Ji,n)}function na(e){return window.crypto.getRandomValues(e)}function oa(){return window.crypto.getRandomValues(ea),ea[0]}function ia(){const e=Date.now(),t=1024*oa()+(1023&oa()),r=new Uint8Array(16),n=Math.trunc(t/2**30),o=t&2**30-1,i=oa();r[0]=e/2**40,r[1]=e/2**32,r[2]=e/2**24,r[3]=e/65536,r[4]=e/256,r[5]=e,r[6]=112|n>>>8,r[7]=n,r[8]=128|o>>>24,r[9]=o>>>16,r[10]=o>>>8,r[11]=o,r[12]=i>>>24,r[13]=i>>>16,r[14]=i>>>8,r[15]=i;let a="";for(let e=0;e<r.length;e++)a+=Zi.charAt(r[e]>>>4),a+=Zi.charAt(15&r[e]),3!==e&&5!==e&&7!==e&&9!==e||(a+="-");return a}async function aa(e){return window.crypto.subtle.exportKey("jwk",e)}async function sa(e){const t=await ra(e);return ji(new Uint8Array(t))}const ca="storage_not_supported",la="stubbed_public_client_application_called",ha="in_mem_redirect_unavailable";var da=Object.freeze({__proto__:null,inMemRedirectUnavailable:ha,storageNotSupported:ca,stubbedPublicClientApplicationCalled:la});const ua={[ca]:"Given storage configuration option was not supported.",[la]:"Stub instance of Public Client Application was called. If using msal-react, please ensure context is not used without a provider. For more visit: aka.ms/msaljs/browser-errors",[ha]:"Redirect cannot be supported. In-memory storage was selected and storeAuthStateInCookie=false, which would cause the library to be unable to handle the incoming hash. If you would like to use the redirect API, please use session/localStorage or set storeAuthStateInCookie=true."},ga={storageNotSupportedError:{code:ca,desc:ua[ca]},stubPcaInstanceCalled:{code:la,desc:ua[la]},inMemRedirectUnavailable:{code:ha,desc:ua[ha]}};class pa extends Ie{constructor(e,t){super(e,t),this.name="BrowserConfigurationAuthError",Object.setPrototypeOf(this,pa.prototype)}}function ma(e){return new pa(e,ua[e])}function fa(e){e.location.hash="","function"==typeof e.history.replaceState&&e.history.replaceState(null,"",`${e.location.origin}${e.location.pathname}${e.location.search}`)}function Ca(e){const t=e.split("#");t.shift(),window.location.hash=t.length>0?t.join("#"):""}function ya(){return window.parent!==window}function va(){return"undefined"!=typeof window&&!!window.opener&&window.opener!==window&&"string"==typeof window.name&&0===window.name.indexOf(`${pi.POPUP_NAME_PREFIX}.`)}function Ta(){return window.location.href.split("?")[0].split("#")[0]}function Ia(){const e=new Lr(window.location.href).getUrlComponents();return`${e.Protocol}//${e.HostNameAndPort}/`}function Aa(){if(Lr.hashContainsKnownProperties(window.location.hash)&&ya())throw gi(Mo)}function wa(e){if(ya()&&!e)throw gi(Po)}function ka(){if(va())throw gi(No)}function Sa(){if("undefined"==typeof window)throw gi(Ko)}function Ea(e){if(!e)throw gi(oi)}function Ra(e){Sa(),Aa(),ka(),Ea(e)}function ba(e,t){if(Ra(e),wa(t.system.allowRedirectInIframe),t.cache.cacheLocation===Ai.MemoryStorage&&!t.cache.storeAuthStateInCookie)throw ma(ha)}function _a(e){const t=document.createElement("link");t.rel="preconnect",t.href=new URL(e).origin,t.crossOrigin="anonymous",document.head.appendChild(t),window.setTimeout((()=>{try{document.head.removeChild(t)}catch{}}),1e4)}function Pa(){return ia()}var Ma=Object.freeze({__proto__:null,blockAPICallsBeforeInitialize:Ea,blockAcquireTokenInPopups:ka,blockNonBrowserEnvironment:Sa,blockRedirectInIframe:wa,blockReloadInHiddenIframes:Aa,clearHash:fa,createGuid:Pa,getCurrentUri:Ta,getHomepage:Ia,invoke:In,invokeAsync:An,isInIframe:ya,isInPopup:va,preconnect:_a,preflightCheck:Ra,redirectPreflightCheck:ba,replaceHash:Ca});class Na{navigateInternal(e,t){return Na.defaultNavigateWindow(e,t)}navigateExternal(e,t){return Na.defaultNavigateWindow(e,t)}static defaultNavigateWindow(e,t){return t.noHistory?window.location.replace(e):window.location.assign(e),new Promise((e=>{setTimeout((()=>{e(!0)}),t.timeout)}))}}class Oa{async sendGetRequestAsync(e,t){let r;try{r=await fetch(e,{method:wi,headers:this.getFetchHeaders(t)})}catch(e){throw window.navigator.onLine?gi(Qo):gi(Go)}try{return{headers:this.getHeaderDict(r.headers),body:await r.json(),status:r.status}}catch(e){throw gi(Wo)}}async sendPostRequestAsync(e,r){const n=r&&r.body||t.EMPTY_STRING;let o;try{o=await fetch(e,{method:ki,headers:this.getFetchHeaders(r),body:n})}catch(e){throw window.navigator.onLine?gi($o):gi(Go)}try{return{headers:this.getHeaderDict(o.headers),body:await o.json(),status:o.status}}catch(e){throw gi(Wo)}}getFetchHeaders(e){const t=new Headers;if(!e||!e.headers)return t;const r=e.headers;return Object.keys(r).forEach((e=>{t.append(e,r[e])})),t}getHeaderDict(e){const t={};return e.forEach(((e,r)=>{t[r]=e})),t}}const qa=1e4;const La="@azure/msal-browser",Ua="3.26.1";class Ha{static loggerCallback(t,r){switch(t){case e.LogLevel.Error:return void console.error(r);case e.LogLevel.Info:return void console.info(r);case e.LogLevel.Verbose:return void console.debug(r);case e.LogLevel.Warning:return void console.warn(r);default:return void console.log(r)}}constructor(r){let n;this.browserEnvironment="undefined"!=typeof window,this.config=function({auth:r,cache:n,system:o,telemetry:i},a){const s={clientId:t.EMPTY_STRING,authority:`${t.DEFAULT_AUTHORITY}`,knownAuthorities:[],cloudDiscoveryMetadata:t.EMPTY_STRING,authorityMetadata:t.EMPTY_STRING,redirectUri:t.EMPTY_STRING,postLogoutRedirectUri:t.EMPTY_STRING,navigateToLoginRequestUrl:!0,clientCapabilities:[],protocolMode:Mr.AAD,OIDCOptions:{serverResponseType:_.FRAGMENT,defaultScopes:[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE]},azureCloudOptions:{azureCloudInstance:wt.None,tenant:t.EMPTY_STRING},skipAuthorityMetadataCache:!1,supportsNestedAppAuth:!1,instanceAware:!1},c={cacheLocation:Ai.SessionStorage,temporaryCacheLocation:Ai.SessionStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!(!n||n.cacheLocation!==Ai.LocalStorage),claimsBasedCachingEnabled:!1},l={loggerCallback:()=>{},logLevel:e.LogLevel.Info,piiLoggingEnabled:!1},h={...{...Wr,loggerOptions:l,networkClient:a?new Oa:eo,navigationClient:new Na,loadFrameTimeout:0,windowHashTimeout:o?.loadFrameTimeout||6e4,iframeHashTimeout:o?.loadFrameTimeout||qa,navigateFrameWait:0,redirectNavigationTimeout:3e4,asyncPopups:!1,allowRedirectInIframe:!1,allowNativeBroker:!1,nativeBrokerHandshakeTimeout:o?.nativeBrokerHandshakeTimeout||2e3,pollIntervalMilliseconds:pi.DEFAULT_POLL_INTERVAL_MS},...o,loggerOptions:o?.loggerOptions||l},d={application:{appName:t.EMPTY_STRING,appVersion:t.EMPTY_STRING},client:new uo};r?.protocolMode!==Mr.OIDC&&r?.OIDCOptions&&new Tt(h.loggerOptions).warning(JSON.stringify(yr(dr)));if(r?.protocolMode&&r.protocolMode!==Mr.AAD&&h?.allowNativeBroker)throw yr(ur);return{auth:{...s,...r,OIDCOptions:{...s.OIDCOptions,...r?.OIDCOptions}},cache:{...c,...n},system:h,telemetry:{...d,...i}}}(r,this.browserEnvironment);try{n=window[Ai.SessionStorage]}catch(e){}const o=n?.getItem("msal.browser.log.level"),i=n?.getItem("msal.browser.log.pii")?.toLowerCase(),a="true"===i||"false"!==i&&void 0,s={...this.config.system.loggerOptions},c=o&&Object.keys(e.LogLevel).includes(o)?e.LogLevel[o]:void 0;c&&(s.loggerCallback=Ha.loggerCallback,s.logLevel=c),void 0!==a&&(s.piiLoggingEnabled=a),this.logger=new Tt(s,La,Ua),this.available=!1}getConfig(){return this.config}getLogger(){return this.logger}isAvailable(){return this.available}isBrowserEnvironment(){return this.browserEnvironment}}const Ba="USER_INTERACTION_REQUIRED",xa="USER_CANCEL",Da="NO_NETWORK",Fa="TRANSIENT_ERROR",Ka="PERSISTENT_ERROR",za="DISABLED",Ga="ACCOUNT_UNAVAILABLE",$a="NESTED_APP_AUTH_UNAVAILABLE";class Qa{static async initializeNestedAppAuthBridge(){if(void 0===window)throw new Error("window is undefined");if(void 0===window.nestedAppAuthBridge)throw new Error("window.nestedAppAuthBridge is undefined");try{window.nestedAppAuthBridge.addEventListener("message",(e=>{const t="string"==typeof e?e:e.data,r=JSON.parse(t),n=Qa.bridgeRequests.find((e=>e.requestId===r.requestId));void 0!==n&&(Qa.bridgeRequests.splice(Qa.bridgeRequests.indexOf(n),1),r.success?n.resolve(r):n.reject(r.error))}));const e=await new Promise(((e,t)=>{const r=Qa.buildRequest("GetInitContext"),n={requestId:r.requestId,method:r.method,resolve:e,reject:t};Qa.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}));return Qa.validateBridgeResultOrThrow(e.initContext)}catch(e){throw window.console.log(e),e}}getTokenInteractive(e){return this.getToken("GetTokenPopup",e)}getTokenSilent(e){return this.getToken("GetToken",e)}async getToken(e,t){const r=await this.sendRequest(e,{tokenParams:t});return{token:Qa.validateBridgeResultOrThrow(r.token),account:Qa.validateBridgeResultOrThrow(r.account)}}getHostCapabilities(){return this.capabilities??null}getAccountContext(){return this.accountContext?this.accountContext:null}static buildRequest(e,t){return{messageType:"NestedAppAuthRequest",method:e,requestId:ia(),sendTime:Date.now(),clientLibrary:pi.MSAL_SKU,clientLibraryVersion:Ua,...t}}sendRequest(e,t){const r=Qa.buildRequest(e,t);return new Promise(((e,t)=>{const n={requestId:r.requestId,method:r.method,resolve:e,reject:t};Qa.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}))}static validateBridgeResultOrThrow(e){if(void 0===e){throw{status:$a}}return e}constructor(e,t,r,n){this.sdkName=e,this.sdkVersion=t,this.accountContext=r,this.capabilities=n}static async create(){const e=await Qa.initializeNestedAppAuthBridge();return new Qa(e.sdkName,e.sdkVersion,e.accountContext,e.capabilities)}}Qa.bridgeRequests=[];class Wa extends Ha{constructor(){super(...arguments),this.bridgeProxy=void 0,this.accountContext=null}getModuleName(){return Wa.MODULE_NAME}getId(){return Wa.ID}getBridgeProxy(){return this.bridgeProxy}async initialize(){try{if("undefined"!=typeof window){"function"==typeof window.__initializeNestedAppAuth&&await window.__initializeNestedAppAuth();const e=await Qa.create();this.accountContext=e.getAccountContext(),this.bridgeProxy=e,this.available=void 0!==e}}catch(e){this.logger.infoPii(`Could not initialize Nested App Auth bridge (${e})`)}return this.logger.info(`Nested App Auth Bridge available: ${this.available}`),this.available}}Wa.MODULE_NAME="",Wa.ID="NestedAppOperatingContext";class ja extends Ha{getModuleName(){return ja.MODULE_NAME}getId(){return ja.ID}async initialize(){return this.available="undefined"!=typeof window,this.available}}function Va(e){return(new TextDecoder).decode(function(e){let t=e.replace(/-/g,"+").replace(/_/g,"/");switch(t.length%4){case 0:break;case 2:t+="==";break;case 3:t+="=";break;default:throw gi(ai)}const r=atob(t);return Uint8Array.from(r,(e=>e.codePointAt(0)||0))}(e))}ja.MODULE_NAME="",ja.ID="StandardOperatingContext";class Ya{constructor(){this.dbName=zi,this.version=1,this.tableName=Gi,this.dbOpen=!1}async open(){return new Promise(((e,t)=>{const r=window.indexedDB.open(this.dbName,this.version);r.addEventListener("upgradeneeded",(e=>{e.target.result.createObjectStore(this.tableName)})),r.addEventListener("success",(t=>{const r=t;this.db=r.target.result,this.dbOpen=!0,e()})),r.addEventListener("error",(()=>t(gi(Zo))))}))}closeConnection(){const e=this.db;e&&this.dbOpen&&(e.close(),this.dbOpen=!1)}async validateDbIsOpen(){if(!this.dbOpen)return this.open()}async getItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(gi(zo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).get(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async setItem(e,t){return await this.validateDbIsOpen(),new Promise(((r,n)=>{if(!this.db)return n(gi(zo));const o=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).put(t,e);o.addEventListener("success",(()=>{this.closeConnection(),r()})),o.addEventListener("error",(e=>{this.closeConnection(),n(e)}))}))}async removeItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(gi(zo));const n=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).delete(e);n.addEventListener("success",(()=>{this.closeConnection(),t()})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async getKeys(){return await this.validateDbIsOpen(),new Promise(((e,t)=>{if(!this.db)return t(gi(zo));const r=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).getAllKeys();r.addEventListener("success",(t=>{const r=t;this.closeConnection(),e(r.target.result)})),r.addEventListener("error",(e=>{this.closeConnection(),t(e)}))}))}async containsKey(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(gi(zo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).count(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(1===r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async deleteDatabase(){return this.db&&this.dbOpen&&this.closeConnection(),new Promise(((e,t)=>{const r=window.indexedDB.deleteDatabase(zi),n=setTimeout((()=>t(!1)),200);r.addEventListener("success",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("blocked",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("error",(()=>(clearTimeout(n),t(!1))))}))}}class Ja{constructor(){this.cache=new Map}getItem(e){return this.cache.get(e)||null}setItem(e,t){this.cache.set(e,t)}removeItem(e){this.cache.delete(e)}getKeys(){const e=[];return this.cache.forEach(((t,r)=>{e.push(r)})),e}containsKey(e){return this.cache.has(e)}clear(){this.cache.clear()}}class Xa{constructor(e){this.inMemoryCache=new Ja,this.indexedDBCache=new Ya,this.logger=e}handleDatabaseAccessError(e){if(!(e instanceof ui&&e.errorCode===Zo))throw e;this.logger.error("Could not access persistent storage. This may be caused by browser privacy features which block persistent storage in third-party contexts.")}async getItem(e){const t=this.inMemoryCache.getItem(e);if(!t)try{return this.logger.verbose("Queried item not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.getItem(e)}catch(e){this.handleDatabaseAccessError(e)}return t}async setItem(e,t){this.inMemoryCache.setItem(e,t);try{await this.indexedDBCache.setItem(e,t)}catch(e){this.handleDatabaseAccessError(e)}}async removeItem(e){this.inMemoryCache.removeItem(e);try{await this.indexedDBCache.removeItem(e)}catch(e){this.handleDatabaseAccessError(e)}}async getKeys(){const e=this.inMemoryCache.getKeys();if(0===e.length)try{return this.logger.verbose("In-memory cache is empty, now querying persistent storage."),await this.indexedDBCache.getKeys()}catch(e){this.handleDatabaseAccessError(e)}return e}async containsKey(e){const t=this.inMemoryCache.containsKey(e);if(!t)try{return this.logger.verbose("Key not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.containsKey(e)}catch(e){this.handleDatabaseAccessError(e)}return t}clearInMemory(){this.logger.verbose("Deleting in-memory keystore"),this.inMemoryCache.clear(),this.logger.verbose("In-memory keystore deleted")}async clearPersistent(){try{this.logger.verbose("Deleting persistent keystore");const e=await this.indexedDBCache.deleteDatabase();return e&&this.logger.verbose("Persistent keystore deleted"),e}catch(e){return this.handleDatabaseAccessError(e),!1}}}class Za{constructor(e,t){this.logger=e,function(e){if(!("crypto"in window))throw e.error("BrowserCrypto: crypto interface is unavailable"),gi(Co);e.verbose("BrowserCrypto: modern crypto interface available")}(e),this.cache=new Xa(this.logger),this.performanceClient=t}createNewGuid(){return ia()}base64Encode(e){return Vi(e)}base64Decode(e){return Va(e)}base64UrlEncode(e){return Wi(e)}encodeKid(e){return this.base64UrlEncode(JSON.stringify({kid:e}))}async getPublicKeyThumbprint(e){const t=this.performanceClient?.startMeasurement(fn.CryptoOptsGetPublicKeyThumbprint,e.correlationId),r=await async function(e,t){return window.crypto.subtle.generateKey(ta,e,t)}(Za.EXTRACTABLE,Za.POP_KEY_USAGES),n=await aa(r.publicKey),o=es({e:n.e,kty:n.kty,n:n.n}),i=await this.hashString(o),a=await aa(r.privateKey),s=await async function(e,t,r){return window.crypto.subtle.importKey("jwk",e,ta,t,r)}(a,!1,["sign"]);return await this.cache.setItem(i,{privateKey:s,publicKey:r.publicKey,requestMethod:e.resourceRequestMethod,requestUri:e.resourceRequestUri}),t&&t.end({success:!0}),i}async removeTokenBindingKey(e){await this.cache.removeItem(e);return!await this.cache.containsKey(e)}async clearKeystore(){this.cache.clearInMemory();try{return await this.cache.clearPersistent(),!0}catch(e){return e instanceof Error?this.logger.error(`Clearing keystore failed with error: ${e.message}`):this.logger.error("Clearing keystore failed with unknown error"),!1}}async signJwt(e,t,r,n){const o=this.performanceClient?.startMeasurement(fn.CryptoOptsSignJwt,n),i=await this.cache.getItem(t);if(!i)throw gi(Vo);const a=await aa(i.publicKey),s=es(a),c=Wi(JSON.stringify({kid:t})),l=Wi(lo.getShrHeaderString({...r?.header,alg:a.alg,kid:c}));e.cnf={jwk:JSON.parse(s)};const h=`${l}.${Wi(JSON.stringify(e))}`,d=(new TextEncoder).encode(h),u=await async function(e,t){return window.crypto.subtle.sign(ta,e,t)}(i.privateKey,d),g=`${h}.${ji(new Uint8Array(u))}`;return o&&o.end({success:!0}),g}async hashString(e){return sa(e)}}function es(e){return JSON.stringify(e,Object.keys(e).sort())}Za.POP_KEY_USAGES=["sign","verify"],Za.EXTRACTABLE=!0;class ts{constructor(e){this.validateWindowStorage(e),this.windowStorage=window[e]}validateWindowStorage(e){if(e!==Ai.LocalStorage&&e!==Ai.SessionStorage||!window[e])throw ma(ca)}getItem(e){return this.windowStorage.getItem(e)}setItem(e,t){this.windowStorage.setItem(e,t)}removeItem(e){this.windowStorage.removeItem(e)}getKeys(){return Object.keys(this.windowStorage)}containsKey(e){return this.windowStorage.hasOwnProperty(e)}}function rs(e,t){if(!t)return null;try{return Gn.parseRequestState(e,t).libraryState.meta}catch(e){throw Ct(Me)}}class ns extends $r{constructor(e,t,r,n,o,i){super(e,r,n,o),this.COOKIE_LIFE_MULTIPLIER=864e5,this.cacheConfig=t,this.logger=n,this.internalStorage=new Ja,this.browserStorage=this.setupBrowserStorage(this.cacheConfig.cacheLocation),this.temporaryCacheStorage=this.setupTemporaryCacheStorage(this.cacheConfig.temporaryCacheLocation,this.cacheConfig.cacheLocation),t.cacheMigrationEnabled&&(this.migrateCacheEntries(),this.createKeyMaps()),this.performanceClient=i}setupBrowserStorage(e){switch(e){case Ai.LocalStorage:case Ai.SessionStorage:try{return new ts(e)}catch(e){this.logger.verbose(e);break}}return this.cacheConfig.cacheLocation=Ai.MemoryStorage,new Ja}setupTemporaryCacheStorage(e,t){switch(t){case Ai.LocalStorage:case Ai.SessionStorage:try{return new ts(e||Ai.SessionStorage)}catch(e){return this.logger.verbose(e),this.internalStorage}default:return this.internalStorage}}migrateCacheEntries(){const e=`${t.CACHE_PREFIX}.${m}`,r=`${t.CACHE_PREFIX}.${f}`,n=`${t.CACHE_PREFIX}.${y}`,o=`${t.CACHE_PREFIX}.${v}`,i=[this.browserStorage.getItem(e),this.browserStorage.getItem(r),this.browserStorage.getItem(n),this.browserStorage.getItem(o)];[m,f,y,v].forEach(((e,t)=>{const r=i[t];r&&this.setTemporaryCache(e,r,!0)}))}createKeyMaps(){this.logger.trace("BrowserCacheManager - createKeyMaps called.");const e=this.getItem(Li),t=this.getItem(`${Ui}.${this.clientId}`);if(e&&t)return void this.logger.verbose("BrowserCacheManager:createKeyMaps - account and token key maps already exist, skipping migration.");this.browserStorage.getKeys().forEach((e=>{if(this.isCredentialKey(e)){const t=this.getItem(e);if(t){const r=this.validateAndParseJson(t);if(r&&r.hasOwnProperty("credentialType"))switch(r.credentialType){case H.ID_TOKEN:if(Lt(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - idToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - idToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.ID_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching idToken schema with value containing idToken credentialType field but value failed IdTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed idToken validation on key: ${e}`);break;case H.ACCESS_TOKEN:case H.ACCESS_TOKEN_WITH_AUTH_SCHEME:if(qt(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - accessToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - accessToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.ACCESS_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching accessToken schema with value containing accessToken credentialType field but value failed AccessTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed accessToken validation on key: ${e}`);break;case H.REFRESH_TOKEN:if(Ut(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - refreshToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - refreshToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.REFRESH_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching refreshToken schema with value containing refreshToken credentialType field but value failed RefreshTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed refreshToken validation on key: ${e}`)}}}if(this.isAccountKey(e)){const t=this.getItem(e);if(t){const r=this.validateAndParseJson(t);r&&Nr.isAccountEntity(r)&&(this.logger.trace("BrowserCacheManager:createKeyMaps - account found, saving key to account key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - account with key: ${e} found, saving key to account key map`),this.addAccountKeyToMap(e))}}}))}validateAndParseJson(e){try{const t=JSON.parse(e);return t&&"object"==typeof t?t:null}catch(e){return null}}getItem(e){return this.browserStorage.getItem(e)}setItem(e,t){this.browserStorage.setItem(e,t)}getAccount(e,t){this.logger.trace("BrowserCacheManager.getAccount called");const r=this.getCachedAccountEntity(e);return this.updateOutdatedCachedAccount(e,r,t)}getCachedAccountEntity(e){const t=this.getItem(e);if(!t)return this.removeAccountKeyFromMap(e),null;const r=this.validateAndParseJson(t);return r&&Nr.isAccountEntity(r)?$r.toObject(new Nr,r):(this.removeAccountKeyFromMap(e),null)}setAccount(e){this.logger.trace("BrowserCacheManager.setAccount called");const t=e.generateAccountKey();this.setItem(t,JSON.stringify(e)),this.addAccountKeyToMap(t)}getAccountKeys(){this.logger.trace("BrowserCacheManager.getAccountKeys called");const e=this.getItem(Li);return e?JSON.parse(e):(this.logger.verbose("BrowserCacheManager.getAccountKeys - No account keys found"),[])}addAccountKeyToMap(e){this.logger.trace("BrowserCacheManager.addAccountKeyToMap called"),this.logger.tracePii(`BrowserCacheManager.addAccountKeyToMap called with key: ${e}`);const t=this.getAccountKeys();-1===t.indexOf(e)?(t.push(e),this.setItem(Li,JSON.stringify(t)),this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key added")):this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key already exists in map")}removeAccountKeyFromMap(e){this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap called"),this.logger.tracePii(`BrowserCacheManager.removeAccountKeyFromMap called with key: ${e}`);const t=this.getAccountKeys(),r=t.indexOf(e);r>-1?(t.splice(r,1),this.setItem(Li,JSON.stringify(t)),this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap account key removed")):this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap key not found in existing map")}async removeAccount(e){super.removeAccount(e),this.removeAccountKeyFromMap(e)}removeOutdatedAccount(e){this.removeItem(e),this.removeAccountKeyFromMap(e)}removeIdToken(e){super.removeIdToken(e),this.removeTokenKey(e,H.ID_TOKEN)}async removeAccessToken(e){super.removeAccessToken(e),this.removeTokenKey(e,H.ACCESS_TOKEN)}removeRefreshToken(e){super.removeRefreshToken(e),this.removeTokenKey(e,H.REFRESH_TOKEN)}getTokenKeys(){this.logger.trace("BrowserCacheManager.getTokenKeys called");const e=this.getItem(`${Ui}.${this.clientId}`);if(e){const t=this.validateAndParseJson(e);if(t&&t.hasOwnProperty("idToken")&&t.hasOwnProperty("accessToken")&&t.hasOwnProperty("refreshToken"))return t;this.logger.error("BrowserCacheManager.getTokenKeys - Token keys found but in an unknown format. Returning empty key map.")}else this.logger.verbose("BrowserCacheManager.getTokenKeys - No token keys found");return{idToken:[],accessToken:[],refreshToken:[]}}addTokenKey(e,t){this.logger.trace("BrowserCacheManager addTokenKey called");const r=this.getTokenKeys();switch(t){case H.ID_TOKEN:-1===r.idToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - idToken added to map"),r.idToken.push(e));break;case H.ACCESS_TOKEN:-1===r.accessToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - accessToken added to map"),r.accessToken.push(e));break;case H.REFRESH_TOKEN:-1===r.refreshToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - refreshToken added to map"),r.refreshToken.push(e));break;default:throw this.logger.error(`BrowserCacheManager:addTokenKey - CredentialType provided invalid. CredentialType: ${t}`),Ct(Xe)}this.setItem(`${Ui}.${this.clientId}`,JSON.stringify(r))}removeTokenKey(e,t){this.logger.trace("BrowserCacheManager removeTokenKey called");const r=this.getTokenKeys();switch(t){case H.ID_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove idToken with key: ${e} from map`);const n=r.idToken.indexOf(e);n>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - idToken removed from map"),r.idToken.splice(n,1)):this.logger.info("BrowserCacheManager: removeTokenKey - idToken does not exist in map. Either it was previously removed or it was never added.");break;case H.ACCESS_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove accessToken with key: ${e} from map`);const o=r.accessToken.indexOf(e);o>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - accessToken removed from map"),r.accessToken.splice(o,1)):this.logger.info("BrowserCacheManager: removeTokenKey - accessToken does not exist in map. Either it was previously removed or it was never added.");break;case H.REFRESH_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove refreshToken with key: ${e} from map`);const i=r.refreshToken.indexOf(e);i>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken removed from map"),r.refreshToken.splice(i,1)):this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken does not exist in map. Either it was previously removed or it was never added.");break;default:throw this.logger.error(`BrowserCacheManager:removeTokenKey - CredentialType provided invalid. CredentialType: ${t}`),Ct(Xe)}this.setItem(`${Ui}.${this.clientId}`,JSON.stringify(r))}getIdTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ID_TOKEN),null;const r=this.validateAndParseJson(t);return r&&Lt(r)?(this.logger.trace("BrowserCacheManager.getIdTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ID_TOKEN),null)}setIdTokenCredential(e){this.logger.trace("BrowserCacheManager.setIdTokenCredential called");const t=_t(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.ID_TOKEN)}getAccessTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ACCESS_TOKEN),null;const r=this.validateAndParseJson(t);return r&&qt(r)?(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ACCESS_TOKEN),null)}setAccessTokenCredential(e){this.logger.trace("BrowserCacheManager.setAccessTokenCredential called");const t=_t(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.ACCESS_TOKEN)}getRefreshTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.REFRESH_TOKEN),null;const r=this.validateAndParseJson(t);return r&&Ut(r)?(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.REFRESH_TOKEN),null)}setRefreshTokenCredential(e){this.logger.trace("BrowserCacheManager.setRefreshTokenCredential called");const t=_t(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.REFRESH_TOKEN)}getAppMetadata(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&(n=e,(o=r)&&0===n.indexOf(B)&&o.hasOwnProperty("clientId")&&o.hasOwnProperty("environment"))?(this.logger.trace("BrowserCacheManager.getAppMetadata: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null);var n,o}setAppMetadata(e){this.logger.trace("BrowserCacheManager.setAppMetadata called");const t=function({environment:e,clientId:t}){return[B,e,t].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}(e);this.setItem(t,JSON.stringify(e))}getServerTelemetry(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){const r=0===e.indexOf(Q.CACHE_KEY);let n=!0;return t&&(n=t.hasOwnProperty("failedRequests")&&t.hasOwnProperty("errors")&&t.hasOwnProperty("cacheHits")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getServerTelemetry: cache hit"),r):(this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null)}setServerTelemetry(e,t){this.logger.trace("BrowserCacheManager.setServerTelemetry called"),this.setItem(e,JSON.stringify(t))}getAuthorityMetadata(e){const t=this.internalStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAuthorityMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){return!!t&&0===e.indexOf(D)&&t.hasOwnProperty("aliases")&&t.hasOwnProperty("preferred_cache")&&t.hasOwnProperty("preferred_network")&&t.hasOwnProperty("canonical_authority")&&t.hasOwnProperty("authorization_endpoint")&&t.hasOwnProperty("token_endpoint")&&t.hasOwnProperty("issuer")&&t.hasOwnProperty("aliasesFromNetwork")&&t.hasOwnProperty("endpointsFromNetwork")&&t.hasOwnProperty("expiresAt")&&t.hasOwnProperty("jwks_uri")}(e,r)?(this.logger.trace("BrowserCacheManager.getAuthorityMetadata: cache hit"),r):null}getAuthorityMetadataKeys(){return this.internalStorage.getKeys().filter((e=>this.isAuthorityMetadata(e)))}setWrapperMetadata(e,t){this.internalStorage.setItem(Hi,e),this.internalStorage.setItem(Bi,t)}getWrapperMetadata(){return[this.internalStorage.getItem(Hi)||t.EMPTY_STRING,this.internalStorage.getItem(Bi)||t.EMPTY_STRING]}setAuthorityMetadata(e,t){this.logger.trace("BrowserCacheManager.setAuthorityMetadata called"),this.internalStorage.setItem(e,JSON.stringify(t))}getActiveAccount(){const e=this.generateCacheKey(I),t=this.getItem(e);if(!t){this.logger.trace("BrowserCacheManager.getActiveAccount: No active account filters cache schema found, looking for legacy schema");const e=this.generateCacheKey(T),t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null;const r=this.getAccountInfoFilteredBy({localAccountId:t});return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Legacy active account cache schema found"),this.logger.trace("BrowserCacheManager.getActiveAccount: Adding active account filters cache schema"),this.setActiveAccount(r),r):null}const r=this.validateAndParseJson(t);return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Active account filters schema found"),this.getAccountInfoFilteredBy({homeAccountId:r.homeAccountId,localAccountId:r.localAccountId,tenantId:r.tenantId})):(this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null)}setActiveAccount(e){const t=this.generateCacheKey(I),r=this.generateCacheKey(T);if(e){this.logger.verbose("setActiveAccount: Active account set");const n={homeAccountId:e.homeAccountId,localAccountId:e.localAccountId,tenantId:e.tenantId};this.browserStorage.setItem(t,JSON.stringify(n)),this.browserStorage.setItem(r,e.localAccountId)}else this.logger.verbose("setActiveAccount: No account passed, active account not set"),this.browserStorage.removeItem(t),this.browserStorage.removeItem(r)}getThrottlingCache(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){let r=!1;e&&(r=0===e.indexOf(Y));let n=!0;return t&&(n=t.hasOwnProperty("throttleTime")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getThrottlingCache: cache hit"),r):(this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null)}setThrottlingCache(e,t){this.logger.trace("BrowserCacheManager.setThrottlingCache called"),this.setItem(e,JSON.stringify(t))}getTemporaryCache(e,t){const r=t?this.generateCacheKey(e):e;if(this.cacheConfig.storeAuthStateInCookie){const e=this.getItemCookie(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: storeAuthStateInCookies set to true, retrieving from cookies"),e}const n=this.temporaryCacheStorage.getItem(r);if(!n){if(this.cacheConfig.cacheLocation===Ai.LocalStorage){const e=this.browserStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item found in local storage"),e}return this.logger.trace("BrowserCacheManager.getTemporaryCache: No cache item found in local storage"),null}return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item returned"),n}setTemporaryCache(e,t,r){const n=r?this.generateCacheKey(e):e;this.temporaryCacheStorage.setItem(n,t),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.setTemporaryCache: storeAuthStateInCookie set to true, setting item cookie"),this.setItemCookie(n,t))}removeItem(e){this.browserStorage.removeItem(e)}removeTemporaryItem(e){this.temporaryCacheStorage.removeItem(e),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.removeItem: storeAuthStateInCookie is true, clearing item cookie"),this.clearItemCookie(e))}getKeys(){return this.browserStorage.getKeys()}async clear(){await this.removeAllAccounts(),this.removeAppMetadata(),this.temporaryCacheStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.removeTemporaryItem(e)})),this.browserStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.browserStorage.removeItem(e)})),this.internalStorage.clear()}async clearTokensAndKeysWithClaims(e,t){e.addQueueMeasurement(fn.ClearTokensAndKeysWithClaims,t);const r=this.getTokenKeys(),n=[];r.accessToken.forEach((e=>{const t=this.getAccessTokenCredential(e);t?.requestedClaimsHash&&e.includes(t.requestedClaimsHash.toLowerCase())&&n.push(this.removeAccessToken(e))})),await Promise.all(n),n.length>0&&this.logger.warning(`${n.length} access tokens with claims in the cache keys have been removed from the cache.`)}setItemCookie(e,t,r){let n=`${encodeURIComponent(e)}=${encodeURIComponent(t)};path=/;SameSite=Lax;`;if(r){n+=`expires=${this.getCookieExpirationTime(r)};`}this.cacheConfig.secureCookies&&(n+="Secure;"),document.cookie=n}getItemCookie(e){const r=`${encodeURIComponent(e)}=`,n=document.cookie.split(";");for(let e=0;e<n.length;e++){let t=n[e];for(;" "===t.charAt(0);)t=t.substring(1);if(0===t.indexOf(r))return decodeURIComponent(t.substring(r.length,t.length))}return t.EMPTY_STRING}clearMsalCookies(){const e=`${t.CACHE_PREFIX}.${this.clientId}`;document.cookie.split(";").forEach((t=>{for(;" "===t.charAt(0);)t=t.substring(1);if(0===t.indexOf(e)){const e=t.split("=")[0];this.clearItemCookie(e)}}))}clearItemCookie(e){this.setItemCookie(e,t.EMPTY_STRING,-1)}getCookieExpirationTime(e){const t=new Date;return new Date(t.getTime()+e*this.COOKIE_LIFE_MULTIPLIER).toUTCString()}generateCacheKey(e){return this.validateAndParseJson(e)?JSON.stringify(e):vr.startsWith(e,t.CACHE_PREFIX)||vr.startsWith(e,C)?e:`${t.CACHE_PREFIX}.${this.clientId}.${e}`}generateAuthorityKey(e){const{libraryState:{id:t}}=Gn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${Si}.${t}`)}generateNonceKey(e){const{libraryState:{id:t}}=Gn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${Ri}.${t}`)}generateStateKey(e){const{libraryState:{id:t}}=Gn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${Ei}.${t}`)}getCachedAuthority(e){const t=this.generateStateKey(e),r=this.getTemporaryCache(t);if(!r)return null;const n=this.generateAuthorityKey(r);return this.getTemporaryCache(n)}updateCacheEntries(e,t,r,n,o){this.logger.trace("BrowserCacheManager.updateCacheEntries called");const i=this.generateStateKey(e);this.setTemporaryCache(i,e,!1);const a=this.generateNonceKey(e);this.setTemporaryCache(a,t,!1);const s=this.generateAuthorityKey(e);if(this.setTemporaryCache(s,r,!1),o){const e={credential:o.homeAccountId,type:an};this.setTemporaryCache(Ni,JSON.stringify(e),!0)}else if(n){const e={credential:n,type:sn};this.setTemporaryCache(Ni,JSON.stringify(e),!0)}}resetRequestCache(e){this.logger.trace("BrowserCacheManager.resetRequestCache called"),e&&(this.temporaryCacheStorage.getKeys().forEach((t=>{-1!==t.indexOf(e)&&this.removeTemporaryItem(t)})),this.removeTemporaryItem(this.generateStateKey(e)),this.removeTemporaryItem(this.generateNonceKey(e)),this.removeTemporaryItem(this.generateAuthorityKey(e))),this.removeTemporaryItem(this.generateCacheKey(Pi)),this.removeTemporaryItem(this.generateCacheKey(bi)),this.removeTemporaryItem(this.generateCacheKey(_i)),this.removeTemporaryItem(this.generateCacheKey(Oi)),this.removeTemporaryItem(this.generateCacheKey(Ni)),this.removeTemporaryItem(this.generateCacheKey(qi)),this.setInteractionInProgress(!1)}cleanRequestByState(e){if(this.logger.trace("BrowserCacheManager.cleanRequestByState called"),e){const r=this.generateStateKey(e),n=this.temporaryCacheStorage.getItem(r);this.logger.infoPii(`BrowserCacheManager.cleanRequestByState: Removing temporary cache items for state: ${n}`),this.resetRequestCache(n||t.EMPTY_STRING)}this.clearMsalCookies()}cleanRequestByInteractionType(e){this.logger.trace("BrowserCacheManager.cleanRequestByInteractionType called"),this.temporaryCacheStorage.getKeys().forEach((t=>{if(-1===t.indexOf(Ei))return;const r=this.temporaryCacheStorage.getItem(t);if(!r)return;const n=rs(this.cryptoImpl,r);n&&n.interactionType===e&&(this.logger.infoPii(`BrowserCacheManager.cleanRequestByInteractionType: Removing temporary cache items for state: ${r}`),this.resetRequestCache(r))})),this.clearMsalCookies(),this.setInteractionInProgress(!1)}cacheCodeRequest(e){this.logger.trace("BrowserCacheManager.cacheCodeRequest called");const t=Vi(JSON.stringify(e));this.setTemporaryCache(Pi,t,!0)}getCachedRequest(e){this.logger.trace("BrowserCacheManager.getCachedRequest called");const t=this.getTemporaryCache(Pi,!0);if(!t)throw gi(Ho);let r;try{r=JSON.parse(Va(t))}catch(e){throw this.logger.errorPii(`Attempted to parse: ${t}`),this.logger.error(`Parsing cached token request threw with error: ${e}`),gi(Bo)}if(this.removeTemporaryItem(this.generateCacheKey(Pi)),!r.authority){const t=this.generateAuthorityKey(e),n=this.getTemporaryCache(t);if(!n)throw gi(xo);r.authority=n}return r}getCachedNativeRequest(){this.logger.trace("BrowserCacheManager.getCachedNativeRequest called");const e=this.getTemporaryCache(qi,!0);if(!e)return this.logger.trace("BrowserCacheManager.getCachedNativeRequest: No cached native request found"),null;const t=this.validateAndParseJson(e);return t||(this.logger.error("BrowserCacheManager.getCachedNativeRequest: Unable to parse native request"),null)}isInteractionInProgress(e){const t=this.getInteractionInProgress();return e?t===this.clientId:!!t}getInteractionInProgress(){const e=`${t.CACHE_PREFIX}.${Mi}`;return this.getTemporaryCache(e,!1)}setInteractionInProgress(e){const r=`${t.CACHE_PREFIX}.${Mi}`;if(e){if(this.getInteractionInProgress())throw gi(ko);this.setTemporaryCache(r,this.clientId,!1)}else e||this.getInteractionInProgress()!==this.clientId||this.removeTemporaryItem(r)}getLegacyLoginHint(){const e=this.getTemporaryCache(C);e&&(this.browserStorage.removeItem(C),this.logger.verbose("Cached ADAL id token retrieved."));const t=this.getTemporaryCache(m,!0);t&&(this.browserStorage.removeItem(this.generateCacheKey(m)),this.logger.verbose("Cached MSAL.js v1 id token retrieved"));const r=t||e;if(r){const e=kt(r,Va);if(e.preferred_username)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 preferred_username as loginHint"),e.preferred_username;if(e.upn)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 upn as loginHint"),e.upn;this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, however, no account hint claim found. Enable preferred_username or upn id token claim to get SSO.")}return null}updateCredentialCacheKey(e,t){const r=_t(t);if(e!==r){const n=this.getItem(e);if(n)return this.browserStorage.removeItem(e),this.setItem(r,n),this.logger.verbose(`Updated an outdated ${t.credentialType} cache key`),r;this.logger.error(`Attempted to update an outdated ${t.credentialType} cache key but no item matching the outdated key was found in storage`)}return e}async hydrateCache(e,t){const r=Pt(e.account?.homeAccountId,e.account?.environment,e.idToken,this.clientId,e.tenantId);let n;t.claims&&(n=await this.cryptoImpl.hashString(t.claims));const o={idToken:r,accessToken:Mt(e.account?.homeAccountId,e.account.environment,e.accessToken,this.clientId,e.tenantId,e.scopes.join(" "),e.expiresOn?e.expiresOn.getTime()/1e3:0,e.extExpiresOn?e.extExpiresOn.getTime()/1e3:0,Va,void 0,e.tokenType,void 0,t.sshKid,t.claims,n)};return this.saveCacheRecord(o)}async saveCacheRecord(e,t,r){try{await super.saveCacheRecord(e,t,r)}catch(e){if(e instanceof Gr&&this.performanceClient&&r)try{const e=this.getTokenKeys();this.performanceClient.addFields({cacheRtCount:e.refreshToken.length,cacheIdCount:e.idToken.length,cacheAtCount:e.accessToken.length},r)}catch(e){}throw e}}}const os=(e,t)=>new ns(e,{cacheLocation:Ai.MemoryStorage,temporaryCacheLocation:Ai.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1},yt,t);function is(e,t,r,n){return e.verbose("getAllAccounts called"),r?t.getAllAccounts(n):[]}function as(e,t,r){if(t.trace("getAccount called"),0===Object.keys(e).length)return t.warning("getAccount: No accountFilter provided"),null;const n=r.getAccountInfoFilteredBy(e);return n?(t.verbose("getAccount: Account matching provided filter found, returning"),n):(t.verbose("getAccount: No matching account found, returning null"),null)}function ss(e,t,r){if(t.trace("getAccountByUsername called"),!e)return t.warning("getAccountByUsername: No username provided"),null;const n=r.getAccountInfoFilteredBy({username:e});return n?(t.verbose("getAccountByUsername: Account matching username found, returning"),t.verbosePii(`getAccountByUsername: Returning signed-in accounts matching username: ${e}`),n):(t.verbose("getAccountByUsername: No matching account found, returning null"),null)}function cs(e,t,r){if(t.trace("getAccountByHomeId called"),!e)return t.warning("getAccountByHomeId: No homeAccountId provided"),null;const n=r.getAccountInfoFilteredBy({homeAccountId:e});return n?(t.verbose("getAccountByHomeId: Account matching homeAccountId found, returning"),t.verbosePii(`getAccountByHomeId: Returning signed-in accounts matching homeAccountId: ${e}`),n):(t.verbose("getAccountByHomeId: No matching account found, returning null"),null)}function ls(e,t,r){if(t.trace("getAccountByLocalId called"),!e)return t.warning("getAccountByLocalId: No localAccountId provided"),null;const n=r.getAccountInfoFilteredBy({localAccountId:e});return n?(t.verbose("getAccountByLocalId: Account matching localAccountId found, returning"),t.verbosePii(`getAccountByLocalId: Returning signed-in accounts matching localAccountId: ${e}`),n):(t.verbose("getAccountByLocalId: No matching account found, returning null"),null)}function hs(e,t){t.setActiveAccount(e)}function ds(e){return e.getActiveAccount()}const us={INITIALIZE_START:"msal:initializeStart",INITIALIZE_END:"msal:initializeEnd",ACCOUNT_ADDED:"msal:accountAdded",ACCOUNT_REMOVED:"msal:accountRemoved",ACTIVE_ACCOUNT_CHANGED:"msal:activeAccountChanged",LOGIN_START:"msal:loginStart",LOGIN_SUCCESS:"msal:loginSuccess",LOGIN_FAILURE:"msal:loginFailure",ACQUIRE_TOKEN_START:"msal:acquireTokenStart",ACQUIRE_TOKEN_SUCCESS:"msal:acquireTokenSuccess",ACQUIRE_TOKEN_FAILURE:"msal:acquireTokenFailure",ACQUIRE_TOKEN_NETWORK_START:"msal:acquireTokenFromNetworkStart",SSO_SILENT_START:"msal:ssoSilentStart",SSO_SILENT_SUCCESS:"msal:ssoSilentSuccess",SSO_SILENT_FAILURE:"msal:ssoSilentFailure",ACQUIRE_TOKEN_BY_CODE_START:"msal:acquireTokenByCodeStart",ACQUIRE_TOKEN_BY_CODE_SUCCESS:"msal:acquireTokenByCodeSuccess",ACQUIRE_TOKEN_BY_CODE_FAILURE:"msal:acquireTokenByCodeFailure",HANDLE_REDIRECT_START:"msal:handleRedirectStart",HANDLE_REDIRECT_END:"msal:handleRedirectEnd",POPUP_OPENED:"msal:popupOpened",LOGOUT_START:"msal:logoutStart",LOGOUT_SUCCESS:"msal:logoutSuccess",LOGOUT_FAILURE:"msal:logoutFailure",LOGOUT_END:"msal:logoutEnd",RESTORE_FROM_BFCACHE:"msal:restoreFromBFCache"};class gs{constructor(e){this.eventCallbacks=new Map,this.logger=e||new Tt({})}addEventCallback(e,t,r){if("undefined"!=typeof window){const n=r||Pa();return this.eventCallbacks.has(n)?(this.logger.error(`Event callback with id: ${n} is already registered. Please provide a unique id or remove the existing callback and try again.`),null):(this.eventCallbacks.set(n,[e,t||[]]),this.logger.verbose(`Event callback registered with id: ${n}`),n)}return null}removeEventCallback(e){this.eventCallbacks.delete(e),this.logger.verbose(`Event callback ${e} removed.`)}emitEvent(e,t,r,n){if("undefined"!=typeof window){const o={eventType:e,interactionType:t||null,payload:r||null,error:n||null,timestamp:Date.now()};this.eventCallbacks.forEach((([t,r],n)=>{(0===r.length||r.includes(e))&&(this.logger.verbose(`Emitting event to callback ${n}: ${e}`),t.apply(null,[o]))}))}}}class ps{constructor(e,t,r,n,o,i,a,s,c){this.config=e,this.browserStorage=t,this.browserCrypto=r,this.networkClient=this.config.system.networkClient,this.eventHandler=o,this.navigationClient=i,this.nativeMessageHandler=s,this.correlationId=c||ia(),this.logger=n.clone(pi.MSAL_SKU,Ua,this.correlationId),this.performanceClient=a}async clearCacheOnLogout(e){if(e){Nr.accountInfoIsEqual(e,this.browserStorage.getActiveAccount(),!1)&&(this.logger.verbose("Setting active account to null"),this.browserStorage.setActiveAccount(null));try{await this.browserStorage.removeAccount(Nr.generateAccountCacheKey(e)),this.logger.verbose("Cleared cache items belonging to the account provided in the logout request.")}catch(e){this.logger.error("Account provided in logout request was not found. Local cache unchanged.")}}else try{this.logger.verbose("No account provided in logout request, clearing all cache items.",this.correlationId),await this.browserStorage.clear(),await this.browserCrypto.clearKeystore()}catch(e){this.logger.error("Attempted to clear all MSAL cache items and failed. Local cache unchanged.")}}getRedirectUri(e){this.logger.verbose("getRedirectUri called");const t=e||this.config.auth.redirectUri||Ta();return Lr.getAbsoluteUrl(t,Ta())}initializeServerTelemetryManager(e,t){this.logger.verbose("initializeServerTelemetryManager called");const r={clientId:this.config.auth.clientId,correlationId:this.correlationId,apiId:e,forceRefresh:t||!1,wrapperSKU:this.browserStorage.getWrapperMetadata()[0],wrapperVer:this.browserStorage.getWrapperMetadata()[1]};return new no(r,this.browserStorage)}async getDiscoveredAuthority(e){const{account:t}=e,r=e.requestExtraQueryParameters&&e.requestExtraQueryParameters.hasOwnProperty("instance_aware")?e.requestExtraQueryParameters.instance_aware:void 0;this.performanceClient.addQueueMeasurement(fn.StandardInteractionClientGetDiscoveredAuthority,this.correlationId);const n={protocolMode:this.config.auth.protocolMode,OIDCOptions:this.config.auth.OIDCOptions,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},o=e.requestAuthority||this.config.auth.authority,i=r?.length?"true"===r:this.config.auth.instanceAware,a=t&&i?this.config.auth.authority.replace(Lr.getDomainFromUrl(o),t.environment):o,s=kn.generateAuthority(a,e.requestAzureCloudOptions||this.config.auth.azureCloudOptions),c=await An(Rn,fn.AuthorityFactoryCreateDiscoveredInstance,this.logger,this.performanceClient,this.correlationId)(s,this.config.system.networkClient,this.browserStorage,n,this.logger,this.correlationId,this.performanceClient);if(t&&!c.isAlias(t.environment))throw yr(gr);return c}}const ms=32;async function fs(e,t,r){e.addQueueMeasurement(fn.GeneratePkceCodes,r);const n=In(Cs,fn.GenerateCodeVerifier,t,e,r)(e,t,r);return{verifier:n,challenge:await An(ys,fn.GenerateCodeChallengeFromVerifier,t,e,r)(n,e,t,r)}}function Cs(e,t,r){try{const n=new Uint8Array(ms);In(na,fn.GetRandomValues,t,e,r)(n);return ji(n)}catch(e){throw gi(fo)}}async function ys(e,t,r,n){t.addQueueMeasurement(fn.GenerateCodeChallengeFromVerifier,n);try{const o=await An(ra,fn.Sha256Digest,r,t,n)(e,t,n);return ji(new Uint8Array(o))}catch(e){throw gi(fo)}}async function vs(e,t,r,n){r.addQueueMeasurement(fn.InitializeBaseRequest,e.correlationId);const o=e.authority||t.auth.authority,i=[...e&&e.scopes||[]],a={...e,correlationId:e.correlationId,authority:o,scopes:i};if(a.authenticationScheme){if(a.authenticationScheme===W.SSH){if(!e.sshJwk)throw yr(sr);if(!e.sshKid)throw yr(cr)}n.verbose(`Authentication Scheme set to "${a.authenticationScheme}" as configured in Auth request`)}else a.authenticationScheme=W.BEARER,n.verbose('Authentication Scheme wasn\'t explicitly set in request, defaulting to "Bearer" request');return t.cache.claimsBasedCachingEnabled&&e.claims&&!vr.isEmptyObj(e.claims)&&(a.requestedClaimsHash=await sa(e.claims)),a}async function Ts(e,t,r,n,o){n.addQueueMeasurement(fn.InitializeSilentRequest,e.correlationId);const i=await An(vs,fn.InitializeBaseRequest,o,n,e.correlationId)(e,r,n,o);return{...e,...i,account:t,forceRefresh:e.forceRefresh||!1}}class Is extends ps{async initializeAuthorizationCodeRequest(e){this.performanceClient.addQueueMeasurement(fn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.correlationId);const r=await An(fs,fn.GeneratePkceCodes,this.logger,this.performanceClient,this.correlationId)(this.performanceClient,this.logger,this.correlationId),n={...e,redirectUri:e.redirectUri,code:t.EMPTY_STRING,codeVerifier:r.verifier};return e.codeChallenge=r.challenge,e.codeChallengeMethod=t.S256_CODE_CHALLENGE_METHOD,n}initializeLogoutRequest(e){this.logger.verbose("initializeLogoutRequest called",e?.correlationId);const t={correlationId:this.correlationId||ia(),...e};if(e)if(e.logoutHint)this.logger.verbose("logoutHint has already been set in logoutRequest");else if(e.account){const r=this.getLogoutHintFromIdTokenClaims(e.account);r&&(this.logger.verbose("Setting logoutHint to login_hint ID Token Claim value for the account provided"),t.logoutHint=r)}else this.logger.verbose("logoutHint was not set and account was not passed into logout request, logoutHint will not be set");else this.logger.verbose("logoutHint will not be set since no logout request was configured");return e&&null===e.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri passed as null, not setting post logout redirect uri",t.correlationId):e&&e.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to uri set on logout request",t.correlationId),t.postLogoutRedirectUri=Lr.getAbsoluteUrl(e.postLogoutRedirectUri,Ta())):null===this.config.auth.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri configured as null and no uri set on request, not passing post logout redirect",t.correlationId):this.config.auth.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to configured uri",t.correlationId),t.postLogoutRedirectUri=Lr.getAbsoluteUrl(this.config.auth.postLogoutRedirectUri,Ta())):(this.logger.verbose("Setting postLogoutRedirectUri to current page",t.correlationId),t.postLogoutRedirectUri=Lr.getAbsoluteUrl(Ta(),Ta())),t}getLogoutHintFromIdTokenClaims(e){const t=e.idTokenClaims;if(t){if(t.login_hint)return t.login_hint;this.logger.verbose("The ID Token Claims tied to the provided account do not contain a login_hint claim, logoutHint will not be added to logout request")}else this.logger.verbose("The provided account does not contain ID Token Claims, logoutHint will not be added to logout request");return null}async createAuthCodeClient(e){this.performanceClient.addQueueMeasurement(fn.StandardInteractionClientCreateAuthCodeClient,this.correlationId);const t=await An(this.getClientConfiguration.bind(this),fn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e);return new Jn(t,this.performanceClient)}async getClientConfiguration(e){const{serverTelemetryManager:r,requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:i,account:a}=e;this.performanceClient.addQueueMeasurement(fn.StandardInteractionClientGetClientConfiguration,this.correlationId);const s=await An(this.getDiscoveredAuthority.bind(this),fn.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,this.correlationId)({requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:i,account:a}),c=this.config.system.loggerOptions;return{authOptions:{clientId:this.config.auth.clientId,authority:s,clientCapabilities:this.config.auth.clientCapabilities},systemOptions:{tokenRenewalOffsetSeconds:this.config.system.tokenRenewalOffsetSeconds,preventCorsPreflight:!0},loggerOptions:{loggerCallback:c.loggerCallback,piiLoggingEnabled:c.piiLoggingEnabled,logLevel:c.logLevel,correlationId:this.correlationId},cacheOptions:{claimsBasedCachingEnabled:this.config.cache.claimsBasedCachingEnabled},cryptoInterface:this.browserCrypto,networkInterface:this.networkClient,storageInterface:this.browserStorage,serverTelemetryManager:r,libraryInfo:{sku:pi.MSAL_SKU,version:Ua,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},telemetry:this.config.telemetry}}async initializeAuthorizationRequest(e,r){this.performanceClient.addQueueMeasurement(fn.StandardInteractionClientInitializeAuthorizationRequest,this.correlationId);const n=this.getRedirectUri(e.redirectUri),o={interactionType:r},i=Gn.setRequestState(this.browserCrypto,e&&e.state||t.EMPTY_STRING,o),a={...await An(vs,fn.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)({...e,correlationId:this.correlationId},this.config,this.performanceClient,this.logger),redirectUri:n,state:i,nonce:e.nonce||ia(),responseMode:this.config.auth.OIDCOptions.serverResponseType},s=e.account||this.browserStorage.getActiveAccount();if(s&&(this.logger.verbose("Setting validated request account",this.correlationId),this.logger.verbosePii(`Setting validated request account: ${s.homeAccountId}`,this.correlationId),a.account=s),!a.loginHint&&!s){const e=this.browserStorage.getLegacyLoginHint();e&&(a.loginHint=e)}return a}}const As="user_switch",ws={[As]:"User attempted to switch accounts in the native broker, which is not allowed. All new accounts must sign-in through the standard web flow first, please try again."};class ks extends Ie{constructor(e,t,r){super(e,t),Object.setPrototypeOf(this,ks.prototype),this.name="NativeAuthError",this.ext=r}}function Ss(e){return!(!e.ext||!e.ext.status||"PERSISTENT_ERROR"!==e.ext.status&&"DISABLED"!==e.ext.status)||(!(!e.ext||!e.ext.error||-2147186943!==e.ext.error)||"ContentError"===e.errorCode)}function Es(e,t,r){if(r&&r.status)switch(r.status){case"ACCOUNT_UNAVAILABLE":return zn(Pn);case"USER_INTERACTION_REQUIRED":return new Fn(e,t);case"USER_CANCEL":return gi(Ro);case"NO_NETWORK":return gi(Go)}return new ks(e,ws[e]||t,r)}class Rs extends Is{async acquireToken(e){this.performanceClient.addQueueMeasurement(fn.SilentCacheClientAcquireToken,e.correlationId);const t=this.initializeServerTelemetryManager(xi.acquireTokenSilent_silentFlow),r=await An(this.getClientConfiguration.bind(this),fn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,account:e.account}),n=new Zn(r,this.performanceClient);this.logger.verbose("Silent auth client created");try{const t=(await An(n.acquireCachedToken.bind(n),fn.SilentFlowClientAcquireCachedToken,this.logger,this.performanceClient,e.correlationId)(e))[0];return this.performanceClient.addFields({fromCache:!0},e.correlationId),t}catch(e){throw e instanceof ui&&e.errorCode===Vo&&this.logger.verbose("Signing keypair for bound access token not found. Refreshing bound access token and generating a new crypto keypair."),e}}logout(e){this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e);return this.clearCacheOnLogout(t?.account)}}const bs="brk_client_id",_s="brk_redirect_uri";class Ps extends ps{constructor(e,t,r,n,o,i,a,s,c,l,h,d){super(e,t,r,n,o,i,s,c,d),this.apiId=a,this.accountId=l,this.nativeMessageHandler=c,this.nativeStorageManager=h,this.silentCacheClient=new Rs(e,this.nativeStorageManager,r,n,o,i,s,c,d),this.serverTelemetryManager=this.initializeServerTelemetryManager(this.apiId);const u=this.nativeMessageHandler.getExtensionId()===fi?"chrome":this.nativeMessageHandler.getExtensionId()?.length?"unknown":void 0;this.skus=no.makeExtraSkuString({libraryName:pi.MSAL_SKU,libraryVersion:Ua,extensionName:u,extensionVersion:this.nativeMessageHandler.getExtensionVersion()})}addRequestSKUs(e){e.extraParameters={...e.extraParameters,[gn]:this.skus}}async acquireToken(e){this.performanceClient.addQueueMeasurement(fn.NativeInteractionClientAcquireToken,e.correlationId),this.logger.trace("NativeInteractionClient - acquireToken called.");const t=this.performanceClient.startMeasurement(fn.NativeInteractionClientAcquireToken,e.correlationId),r=Et();try{const n=await this.initializeNativeRequest(e);try{const e=await this.acquireTokensFromCache(this.accountId,n);return t.end({success:!0,isNativeBroker:!1,fromCache:!0}),e}catch(e){this.logger.info("MSAL internal Cache does not contain tokens, proceed to make a native call")}const{...o}=n,i={method:Ti,request:o},a=await this.nativeMessageHandler.sendMessage(i),s=this.validateNativeResponse(a);return await this.handleNativeResponse(s,n,r).then((e=>(t.end({success:!0,isNativeBroker:!0,requestId:e.requestId}),this.serverTelemetryManager.clearNativeBrokerErrorCode(),e))).catch((e=>{throw t.end({success:!1,errorCode:e.errorCode,subErrorCode:e.subError,isNativeBroker:!0}),e}))}catch(e){throw e instanceof ks&&this.serverTelemetryManager.setNativeBrokerErrorCode(e.errorCode),e}}createSilentCacheRequest(e,t){return{authority:e.authority,correlationId:this.correlationId,scopes:Tr.fromString(e.scope).asArray(),account:t,forceRefresh:!1}}async acquireTokensFromCache(e,t){if(!e)throw this.logger.warning("NativeInteractionClient:acquireTokensFromCache - No nativeAccountId provided"),Ct(Ye);const r=this.browserStorage.getBaseAccountInfo({nativeAccountId:e});if(!r)throw Ct(Ye);try{const e=this.createSilentCacheRequest(t,r),n=await this.silentCacheClient.acquireToken(e),o={...r,idTokenClaims:n?.idTokenClaims,idToken:n?.idToken};return{...n,account:o}}catch(e){throw e}}async acquireTokenRedirect(e,t){this.logger.trace("NativeInteractionClient - acquireTokenRedirect called.");const{...r}=e;delete r.onRedirectNavigate;const n=await this.initializeNativeRequest(r),o={method:Ti,request:n};try{const e=await this.nativeMessageHandler.sendMessage(o);this.validateNativeResponse(e)}catch(e){if(e instanceof ks&&(this.serverTelemetryManager.setNativeBrokerErrorCode(e.errorCode),Ss(e)))throw e}this.browserStorage.setTemporaryCache(qi,JSON.stringify(n),!0);const i={apiId:xi.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},a=this.config.auth.navigateToLoginRequestUrl?window.location.href:this.getRedirectUri(e.redirectUri);t.end({success:!0}),await this.navigationClient.navigateExternal(a,i)}async handleRedirectPromise(e,t){if(this.logger.trace("NativeInteractionClient - handleRedirectPromise called."),!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const r=this.browserStorage.getCachedNativeRequest();if(!r)return this.logger.verbose("NativeInteractionClient - handleRedirectPromise called but there is no cached request, returning null."),e&&t&&e?.addFields({errorCode:"no_cached_request"},t),null;const{prompt:n,...o}=r;n&&this.logger.verbose("NativeInteractionClient - handleRedirectPromise called and prompt was included in the original request, removing prompt from cached request to prevent second interaction with native broker window."),this.browserStorage.removeItem(this.browserStorage.generateCacheKey(qi));const i={method:Ti,request:o},a=Et();try{this.logger.verbose("NativeInteractionClient - handleRedirectPromise sending message to native broker.");const e=await this.nativeMessageHandler.sendMessage(i);this.validateNativeResponse(e);const t=this.handleNativeResponse(e,o,a);this.browserStorage.setInteractionInProgress(!1);const r=await t;return this.serverTelemetryManager.clearNativeBrokerErrorCode(),r}catch(e){throw this.browserStorage.setInteractionInProgress(!1),e}}logout(){return this.logger.trace("NativeInteractionClient - logout called."),Promise.reject("Logout not implemented yet")}async handleNativeResponse(e,t,r){this.logger.trace("NativeInteractionClient - handleNativeResponse called.");const n=kt(e.id_token,Va),o=this.createHomeAccountIdentifier(e,n),i=this.browserStorage.getAccountInfoFilteredBy({nativeAccountId:t.accountId})?.homeAccountId;if(o!==i&&e.account.id!==t.accountId)throw Es(As);const a=await this.getDiscoveredAuthority({requestAuthority:t.authority}),s=Vn(this.browserStorage,a,o,Va,n,e.client_info,void 0,n.tid,void 0,e.account.id,this.logger),c=await this.generateAuthenticationResult(e,t,n,s,a.canonicalAuthority,r);return this.cacheAccount(s),this.cacheNativeTokens(e,t,o,n,e.access_token,c.tenantId,r),c}createHomeAccountIdentifier(e,r){return Nr.generateHomeAccountId(e.client_info||t.EMPTY_STRING,Er,this.logger,this.browserCrypto,r)}generateScopes(e,t){return e.scope?Tr.fromString(e.scope):Tr.fromString(t.scope)}async generatePopAccessToken(e,t){if(t.tokenType===W.POP&&t.signPopToken){if(e.shr)return this.logger.trace("handleNativeServerResponse: SHR is enabled in native layer"),e.shr;const r=new Qn(this.browserCrypto),n={resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,shrNonce:t.shrNonce};if(!t.keyId)throw Ct(st);return r.signPopToken(e.access_token,t.keyId,n)}return e.access_token}async generateAuthenticationResult(e,r,n,o,i,a){const s=this.addTelemetryFromNativeResponse(e),c=e.scope?Tr.fromString(e.scope):Tr.fromString(r.scope),l=e.account.properties||{},h=l.UID||n.oid||n.sub||t.EMPTY_STRING,d=l.TenantId||n.tid||t.EMPTY_STRING,u=Sr(o.getAccountInfo(),void 0,n,e.id_token);u.nativeAccountId!==e.account.id&&(u.nativeAccountId=e.account.id);const g=await this.generatePopAccessToken(e,r),p=r.tokenType===W.POP?W.POP:W.BEARER;return{authority:i,uniqueId:h,tenantId:d,scopes:c.asArray(),account:u,idToken:e.id_token,idTokenClaims:n,accessToken:g,fromCache:!!s&&this.isResponseFromCache(s),expiresOn:new Date(1e3*Number(a+e.expires_in)),tokenType:p,correlationId:this.correlationId,state:e.state,fromNativeBroker:!0}}cacheAccount(e){this.browserStorage.setAccount(e),this.browserStorage.removeAccountContext(e).catch((e=>{this.logger.error(`Error occurred while removing account context from browser storage. ${e}`)}))}cacheNativeTokens(e,r,n,o,i,a,s){const c=Pt(n,r.authority,e.id_token||"",r.clientId,o.tid||""),l=s+(r.tokenType===W.POP?t.SHR_NONCE_VALIDITY:("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0),h=this.generateScopes(e,r),d={idToken:c,accessToken:Mt(n,r.authority,i,r.clientId,o.tid||a,h.printScopes(),l,0,Va,void 0,r.tokenType,void 0,r.keyId)};this.nativeStorageManager.saveCacheRecord(d,r.storeInCache)}addTelemetryFromNativeResponse(e){const t=this.getMATSFromResponse(e);return t?(this.performanceClient.addFields({extensionId:this.nativeMessageHandler.getExtensionId(),extensionVersion:this.nativeMessageHandler.getExtensionVersion(),matsBrokerVersion:t.broker_version,matsAccountJoinOnStart:t.account_join_on_start,matsAccountJoinOnEnd:t.account_join_on_end,matsDeviceJoin:t.device_join,matsPromptBehavior:t.prompt_behavior,matsApiErrorCode:t.api_error_code,matsUiVisible:t.ui_visible,matsSilentCode:t.silent_code,matsSilentBiSubCode:t.silent_bi_sub_code,matsSilentMessage:t.silent_message,matsSilentStatus:t.silent_status,matsHttpStatus:t.http_status,matsHttpEventCount:t.http_event_count},this.correlationId),t):null}validateNativeResponse(e){if(e.hasOwnProperty("access_token")&&e.hasOwnProperty("id_token")&&e.hasOwnProperty("client_info")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scope")&&e.hasOwnProperty("expires_in"))return e;throw Ae(fe,"Response missing expected properties.")}getMATSFromResponse(e){if(e.properties.MATS)try{return JSON.parse(e.properties.MATS)}catch(e){this.logger.error("NativeInteractionClient - Error parsing MATS telemetry, returning null instead")}return null}isResponseFromCache(e){return void 0===e.is_cached?(this.logger.verbose("NativeInteractionClient - MATS telemetry does not contain field indicating if response was served from cache. Returning false."),!1):!!e.is_cached}async initializeNativeRequest(e){this.logger.trace("NativeInteractionClient - initializeNativeRequest called");const t=e.authority||this.config.auth.authority;e.account&&await this.getDiscoveredAuthority({requestAuthority:t,requestAzureCloudOptions:e.azureCloudOptions,account:e.account});const r=new Lr(t);r.validateAsUri();const{scopes:n,...o}=e,i=new Tr(n||[]);i.appendScopes(a);const s={...o,accountId:this.accountId,clientId:this.config.auth.clientId,authority:r.urlString,scope:i.printScopes(),redirectUri:this.getRedirectUri(e.redirectUri),prompt:(()=>{switch(this.apiId){case xi.ssoSilent:case xi.acquireTokenSilent_silentFlow:return this.logger.trace("initializeNativeRequest: silent request sets prompt to none"),R.NONE}if(e.prompt)switch(e.prompt){case R.NONE:case R.CONSENT:case R.LOGIN:return this.logger.trace("initializeNativeRequest: prompt is compatible with native flow"),e.prompt;default:throw this.logger.trace(`initializeNativeRequest: prompt = ${e.prompt} is not compatible with native flow`),gi(ii)}else this.logger.trace("initializeNativeRequest: prompt was not provided")})(),correlationId:this.correlationId,tokenType:e.authenticationScheme,windowTitleSubstring:document.title,extraParameters:{...e.extraQueryParameters,...e.tokenQueryParameters},extendedExpiryToken:!1,keyId:e.popKid};if(s.signPopToken&&e.popKid)throw gi(si);if(this.handleExtraBrokerParams(s),s.extraParameters=s.extraParameters||{},s.extraParameters.telemetry=Ci,e.authenticationScheme===W.POP){const t={resourceRequestUri:e.resourceRequestUri,resourceRequestMethod:e.resourceRequestMethod,shrClaims:e.shrClaims,shrNonce:e.shrNonce},r=new Qn(this.browserCrypto);let n;if(s.keyId)n=this.browserCrypto.base64UrlEncode(JSON.stringify({kid:s.keyId})),s.signPopToken=!1;else{const o=await An(r.generateCnf.bind(r),fn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(t,this.logger);n=o.reqCnfString,s.keyId=o.kid,s.signPopToken=!0}s.reqCnf=n}return this.addRequestSKUs(s),s}handleExtraBrokerParams(e){if(e.extraParameters&&e.extraParameters.hasOwnProperty(bs)&&e.extraParameters.hasOwnProperty(_s)&&e.extraParameters.hasOwnProperty(cn)){const t=e.extraParameters[cn],r=e.redirectUri,n=e.extraParameters[_s];e.extraParameters={child_client_id:t,child_redirect_uri:r},e.redirectUri=n}}}class Ms{constructor(e,t,r,n){this.logger=e,this.handshakeTimeoutMs=t,this.extensionId=n,this.resolvers=new Map,this.handshakeResolvers=new Map,this.messageChannel=new MessageChannel,this.windowListener=this.onWindowMessage.bind(this),this.performanceClient=r,this.handshakeEvent=r.startMeasurement(fn.NativeMessageHandlerHandshake)}async sendMessage(e){this.logger.trace("NativeMessageHandler - sendMessage called.");const t={channel:mi,extensionId:this.extensionId,responseId:ia(),body:e};return this.logger.trace("NativeMessageHandler - Sending request to browser extension"),this.logger.tracePii(`NativeMessageHandler - Sending request to browser extension: ${JSON.stringify(t)}`),this.messageChannel.port1.postMessage(t),new Promise(((e,r)=>{this.resolvers.set(t.responseId,{resolve:e,reject:r})}))}static async createProvider(e,t,r){e.trace("NativeMessageHandler - createProvider called.");try{const n=new Ms(e,t,r,fi);return await n.sendHandshakeRequest(),n}catch(n){const o=new Ms(e,t,r);return await o.sendHandshakeRequest(),o}}async sendHandshakeRequest(){this.logger.trace("NativeMessageHandler - sendHandshakeRequest called."),window.addEventListener("message",this.windowListener,!1);const e={channel:mi,extensionId:this.extensionId,responseId:ia(),body:{method:yi}};return this.handshakeEvent.add({extensionId:this.extensionId,extensionHandshakeTimeoutMs:this.handshakeTimeoutMs}),this.messageChannel.port1.onmessage=e=>{this.onChannelMessage(e)},window.postMessage(e,window.origin,[this.messageChannel.port2]),new Promise(((t,r)=>{this.handshakeResolvers.set(e.responseId,{resolve:t,reject:r}),this.timeoutId=window.setTimeout((()=>{window.removeEventListener("message",this.windowListener,!1),this.messageChannel.port1.close(),this.messageChannel.port2.close(),this.handshakeEvent.end({extensionHandshakeTimedOut:!0,success:!1}),r(gi(ti)),this.handshakeResolvers.delete(e.responseId)}),this.handshakeTimeoutMs)}))}onWindowMessage(e){if(this.logger.trace("NativeMessageHandler - onWindowMessage called"),e.source!==window)return;const t=e.data;if(t.channel&&t.channel===mi&&(!t.extensionId||t.extensionId===this.extensionId)&&t.body.method===yi){const e=this.handshakeResolvers.get(t.responseId);if(!e)return void this.logger.trace(`NativeMessageHandler.onWindowMessage - resolver can't be found for request ${t.responseId}`);this.logger.verbose(t.extensionId?`Extension with id: ${t.extensionId} not installed`:"No extension installed"),clearTimeout(this.timeoutId),this.messageChannel.port1.close(),this.messageChannel.port2.close(),window.removeEventListener("message",this.windowListener,!1),this.handshakeEvent.end({success:!1,extensionInstalled:!1}),e.reject(gi(ri))}}onChannelMessage(e){this.logger.trace("NativeMessageHandler - onChannelMessage called.");const t=e.data,r=this.resolvers.get(t.responseId),n=this.handshakeResolvers.get(t.responseId);try{const e=t.body.method;if(e===Ii){if(!r)return;const e=t.body.response;if(this.logger.trace("NativeMessageHandler - Received response from browser extension"),this.logger.tracePii(`NativeMessageHandler - Received response from browser extension: ${JSON.stringify(e)}`),"Success"!==e.status)r.reject(Es(e.code,e.description,e.ext));else{if(!e.result)throw Ae(fe,"Event does not contain result.");e.result.code&&e.result.description?r.reject(Es(e.result.code,e.result.description,e.result.ext)):r.resolve(e.result)}this.resolvers.delete(t.responseId)}else if(e===vi){if(!n)return void this.logger.trace(`NativeMessageHandler.onChannelMessage - resolver can't be found for request ${t.responseId}`);clearTimeout(this.timeoutId),window.removeEventListener("message",this.windowListener,!1),this.extensionId=t.extensionId,this.extensionVersion=t.body.version,this.logger.verbose(`NativeMessageHandler - Received HandshakeResponse from extension: ${this.extensionId}`),this.handshakeEvent.end({extensionInstalled:!0,success:!0}),n.resolve(),this.handshakeResolvers.delete(t.responseId)}}catch(t){this.logger.error("Error parsing response from WAM Extension"),this.logger.errorPii(`Error parsing response from WAM Extension: ${t}`),this.logger.errorPii(`Unable to parse ${e}`),r?r.reject(t):n&&n.reject(t)}}getExtensionId(){return this.extensionId}getExtensionVersion(){return this.extensionVersion}static isNativeAvailable(e,t,r,n){if(t.trace("isNativeAvailable called"),!e.system.allowNativeBroker)return t.trace("isNativeAvailable: allowNativeBroker is not enabled, returning false"),!1;if(!r)return t.trace("isNativeAvailable: WAM extension provider is not initialized, returning false"),!1;if(n)switch(n){case W.BEARER:case W.POP:return t.trace("isNativeAvailable: authenticationScheme is supported, returning true"),!0;default:return t.trace("isNativeAvailable: authenticationScheme is not supported, returning false"),!1}return!0}}class Ns{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async handleCodeResponse(e,t){let r;this.performanceClient.addQueueMeasurement(fn.HandleCodeResponse,t.correlationId);try{r=this.authModule.handleFragmentResponse(e,t.state)}catch(e){throw e instanceof rn&&e.subError===Ro?gi(Ro):e}return An(this.handleCodeResponseFromServer.bind(this),fn.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)(r,t)}async handleCodeResponseFromServer(e,t,r=!0){if(this.performanceClient.addQueueMeasurement(fn.HandleCodeResponseFromServer,t.correlationId),this.logger.trace("InteractionHandler.handleCodeResponseFromServer called"),this.authCodeRequest.code=e.code,e.cloud_instance_host_name&&await An(this.authModule.updateAuthority.bind(this.authModule),fn.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,t.correlationId)(e.cloud_instance_host_name,t.correlationId),r&&(e.nonce=t.nonce||void 0),e.state=t.state,e.client_info)this.authCodeRequest.clientInfo=e.client_info;else{const e=this.createCcsCredentials(t);e&&(this.authCodeRequest.ccsCredential=e)}return await An(this.authModule.acquireToken.bind(this.authModule),fn.AuthClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(this.authCodeRequest,e)}createCcsCredentials(e){return e.account?{credential:e.account.homeAccountId,type:an}:e.loginHint?{credential:e.loginHint,type:sn}:null}}function Os(e,t,r){const n=qr(e);if(!n)throw Or(e)?(r.error(`A ${t} is present in the iframe but it does not contain known properties. It's likely that the ${t} has been replaced by code running on the redirectUri page.`),r.errorPii(`The ${t} detected is: ${e}`),gi(Io)):(r.error(`The request has returned to the redirectUri but a ${t} is not present. It's likely that the ${t} has been removed or the page has been redirected by code running on the redirectUri page.`),gi(vo));return n}class qs extends Is{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,a,c,l),this.unloadWindow=this.unloadWindow.bind(this),this.nativeStorage=s}acquireToken(e){try{const t={popupName:this.generatePopupName(e.scopes||a,e.authority||this.config.auth.authority),popupWindowAttributes:e.popupWindowAttributes||{},popupWindowParent:e.popupWindowParent??window};return this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true, acquiring token"),this.acquireTokenPopupAsync(e,t)):(this.logger.verbose("asyncPopup set to false, opening popup before acquiring token"),t.popup=this.openSizedPopup("about:blank",t),this.acquireTokenPopupAsync(e,t))}catch(e){return Promise.reject(e)}}logout(e){try{this.logger.verbose("logoutPopup called");const t=this.initializeLogoutRequest(e),r={popupName:this.generateLogoutPopupName(t),popupWindowAttributes:e?.popupWindowAttributes||{},popupWindowParent:e?.popupWindowParent??window},n=e&&e.authority,o=e&&e.mainWindowRedirectUri;return this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true"),this.logoutPopupAsync(t,r,n,o)):(this.logger.verbose("asyncPopup set to false, opening popup"),r.popup=this.openSizedPopup("about:blank",r),this.logoutPopupAsync(t,r,n,o))}catch(e){return Promise.reject(e)}}async acquireTokenPopupAsync(t,r){this.logger.verbose("acquireTokenPopupAsync called");const n=this.initializeServerTelemetryManager(xi.acquireTokenPopup),o=await An(this.initializeAuthorizationRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Popup);_a(o.authority);try{const i=await An(this.initializeAuthorizationCodeRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(o),a=await An(this.createAuthCodeClient.bind(this),fn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:o.authority,requestAzureCloudOptions:o.azureCloudOptions,requestExtraQueryParameters:o.extraQueryParameters,account:o.account}),s=Ms.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme);let c;s&&(c=this.performanceClient.startMeasurement(fn.FetchAccountIdWithNativeBroker,t.correlationId));const l=await a.getAuthCodeUrl({...o,nativeBroker:s}),h=new Ns(a,this.browserStorage,i,this.logger,this.performanceClient),d=this.initiateAuthRequest(l,r);this.eventHandler.emitEvent(us.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:d},null);const u=await this.monitorPopupForHash(d,r.popupWindowParent),g=In(Os,fn.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(u,this.config.auth.OIDCOptions.serverResponseType,this.logger);if(nn.removeThrottle(this.browserStorage,this.config.auth.clientId,i),g.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),c&&c.end({success:!0,isNativeBroker:!0}),!this.nativeMessageHandler)throw gi(ni);const e=new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,xi.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,g.accountId,this.nativeStorage,o.correlationId),{userRequestState:t}=Gn.parseRequestState(this.browserCrypto,o.state);return await e.acquireToken({...o,state:t,prompt:void 0})}return await h.handleCodeResponse(g,o)}catch(e){throw r.popup?.close(),e instanceof Ie&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}async logoutPopupAsync(t,r,n,o){this.logger.verbose("logoutPopupAsync called"),this.eventHandler.emitEvent(us.LOGOUT_START,e.InteractionType.Popup,t);const i=this.initializeServerTelemetryManager(xi.logoutPopup);try{await this.clearCacheOnLogout(t.account);const a=await An(this.createAuthCodeClient.bind(this),fn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:i,requestAuthority:n,account:t.account||void 0});try{a.authority.endSessionEndpoint}catch{if(t.account?.homeAccountId&&t.postLogoutRedirectUri&&a.authority.protocolMode===Mr.OIDC){if(this.browserStorage.removeAccount(t.account?.homeAccountId),this.eventHandler.emitEvent(us.LOGOUT_SUCCESS,e.InteractionType.Popup,t),o){const e={apiId:xi.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=Lr.getAbsoluteUrl(o,Ta());await this.navigationClient.navigateInternal(t,e)}return void r.popup?.close()}}const s=a.getLogoutUri(t);this.eventHandler.emitEvent(us.LOGOUT_SUCCESS,e.InteractionType.Popup,t);const c=this.openPopup(s,r);if(this.eventHandler.emitEvent(us.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:c},null),await this.monitorPopupForHash(c,r.popupWindowParent).catch((()=>{})),o){const e={apiId:xi.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=Lr.getAbsoluteUrl(o,Ta());this.logger.verbose("Redirecting main window to url specified in the request"),this.logger.verbosePii(`Redirecting main window to: ${t}`),await this.navigationClient.navigateInternal(t,e)}else this.logger.verbose("No main window navigation requested")}catch(t){throw r.popup?.close(),t instanceof Ie&&(t.setCorrelationId(this.correlationId),i.cacheFailedRequest(t)),this.browserStorage.setInteractionInProgress(!1),this.eventHandler.emitEvent(us.LOGOUT_FAILURE,e.InteractionType.Popup,null,t),this.eventHandler.emitEvent(us.LOGOUT_END,e.InteractionType.Popup),t}this.eventHandler.emitEvent(us.LOGOUT_END,e.InteractionType.Popup)}initiateAuthRequest(e,t){if(e)return this.logger.infoPii(`Navigate to: ${e}`),this.openPopup(e,t);throw this.logger.error("Navigate url is empty"),gi(yo)}monitorPopupForHash(e,t){return new Promise(((t,r)=>{this.logger.verbose("PopupHandler.monitorPopupForHash - polling started");const n=setInterval((()=>{if(e.closed)return this.logger.error("PopupHandler.monitorPopupForHash - window closed"),clearInterval(n),void r(gi(Ro));let o="";try{o=e.location.href}catch(e){}if(!o||"about:blank"===o)return;clearInterval(n);let i="";const a=this.config.auth.OIDCOptions.serverResponseType;e&&(i=a===_.QUERY?e.location.search:e.location.hash),this.logger.verbose("PopupHandler.monitorPopupForHash - popup window is on same origin as caller"),t(i)}),this.config.system.pollIntervalMilliseconds)})).finally((()=>{this.cleanPopup(e,t)}))}openPopup(e,t){try{let r;if(t.popup?(r=t.popup,this.logger.verbosePii(`Navigating popup window to: ${e}`),r.location.assign(e)):void 0===t.popup&&(this.logger.verbosePii(`Opening popup window to: ${e}`),r=this.openSizedPopup(e,t)),!r)throw gi(Eo);return r.focus&&r.focus(),this.currentWindow=r,t.popupWindowParent.addEventListener("beforeunload",this.unloadWindow),r}catch(e){throw this.logger.error("error opening popup "+e.message),this.browserStorage.setInteractionInProgress(!1),gi(So)}}openSizedPopup(e,{popupName:t,popupWindowAttributes:r,popupWindowParent:n}){const o=n.screenLeft?n.screenLeft:n.screenX,i=n.screenTop?n.screenTop:n.screenY,a=n.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,s=n.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;let c=r.popupSize?.width,l=r.popupSize?.height,h=r.popupPosition?.top,d=r.popupPosition?.left;return(!c||c<0||c>a)&&(this.logger.verbose("Default popup window width used. Window width not configured or invalid."),c=pi.POPUP_WIDTH),(!l||l<0||l>s)&&(this.logger.verbose("Default popup window height used. Window height not configured or invalid."),l=pi.POPUP_HEIGHT),(!h||h<0||h>s)&&(this.logger.verbose("Default popup window top position used. Window top not configured or invalid."),h=Math.max(0,s/2-pi.POPUP_HEIGHT/2+i)),(!d||d<0||d>a)&&(this.logger.verbose("Default popup window left position used. Window left not configured or invalid."),d=Math.max(0,a/2-pi.POPUP_WIDTH/2+o)),n.open(e,t,`width=${c}, height=${l}, top=${h}, left=${d}, scrollbars=yes`)}unloadWindow(t){this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Popup),this.currentWindow&&this.currentWindow.close(),t.preventDefault()}cleanPopup(e,t){e.close(),t.removeEventListener("beforeunload",this.unloadWindow),this.browserStorage.setInteractionInProgress(!1)}generatePopupName(e,t){return`${pi.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${e.join("-")}.${t}.${this.correlationId}`}generateLogoutPopupName(e){const t=e.account&&e.account.homeAccountId;return`${pi.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${t}.${this.correlationId}`}}class Ls{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async initiateAuthRequest(e,t){if(this.logger.verbose("RedirectHandler.initiateAuthRequest called"),e){t.redirectStartPage&&(this.logger.verbose("RedirectHandler.initiateAuthRequest: redirectStartPage set, caching start page"),this.browserStorage.setTemporaryCache(bi,t.redirectStartPage,!0)),this.browserStorage.setTemporaryCache(Oi,this.authCodeRequest.correlationId,!0),this.browserStorage.cacheCodeRequest(this.authCodeRequest),this.logger.infoPii(`RedirectHandler.initiateAuthRequest: Navigate to: ${e}`);const r={apiId:xi.acquireTokenRedirect,timeout:t.redirectTimeout,noHistory:!1};if("function"==typeof t.onRedirectNavigate){this.logger.verbose("RedirectHandler.initiateAuthRequest: Invoking onRedirectNavigate callback");return!1!==t.onRedirectNavigate(e)?(this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate did not return false, navigating"),void await t.navigationClient.navigateExternal(e,r)):void this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate returned false, stopping navigation")}return this.logger.verbose("RedirectHandler.initiateAuthRequest: Navigating window to navigate url"),void await t.navigationClient.navigateExternal(e,r)}throw this.logger.info("RedirectHandler.initiateAuthRequest: Navigate url is empty"),gi(yo)}async handleCodeResponse(e,t){this.logger.verbose("RedirectHandler.handleCodeResponse called"),this.browserStorage.setInteractionInProgress(!1);const r=this.browserStorage.generateStateKey(t),n=this.browserStorage.getTemporaryCache(r);if(!n)throw Ct(Oe,"Cached State");let o;try{o=this.authModule.handleFragmentResponse(e,n)}catch(e){throw e instanceof rn&&e.subError===Ro?gi(Ro):e}const i=this.browserStorage.generateNonceKey(n),a=this.browserStorage.getTemporaryCache(i);if(this.authCodeRequest.code=o.code,o.cloud_instance_host_name&&await An(this.authModule.updateAuthority.bind(this.authModule),fn.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,this.authCodeRequest.correlationId)(o.cloud_instance_host_name,this.authCodeRequest.correlationId),o.nonce=a||void 0,o.state=n,o.client_info)this.authCodeRequest.clientInfo=o.client_info;else{const e=this.checkCcsCredentials();e&&(this.authCodeRequest.ccsCredential=e)}const s=await this.authModule.acquireToken(this.authCodeRequest,o);return this.browserStorage.cleanRequestByState(t),s}checkCcsCredentials(){const e=this.browserStorage.getTemporaryCache(Ni,!0);if(e)try{return JSON.parse(e)}catch(t){this.authModule.logger.error("Cache credential could not be parsed"),this.authModule.logger.errorPii(`Cache credential could not be parsed: ${e}`)}return null}}class Us extends Is{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,a,c,l),this.nativeStorage=s}async acquireToken(t){const r=await An(this.initializeAuthorizationRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Redirect);this.browserStorage.updateCacheEntries(r.state,r.nonce,r.authority,r.loginHint||"",r.account||null);const n=this.initializeServerTelemetryManager(xi.acquireTokenRedirect),o=t=>{t.persisted&&(this.logger.verbose("Page was restored from back/forward cache. Clearing temporary cache."),this.browserStorage.cleanRequestByState(r.state),this.eventHandler.emitEvent(us.RESTORE_FROM_BFCACHE,e.InteractionType.Redirect))};try{const e=await An(this.initializeAuthorizationCodeRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(r),i=await An(this.createAuthCodeClient.bind(this),fn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:r.authority,requestAzureCloudOptions:r.azureCloudOptions,requestExtraQueryParameters:r.extraQueryParameters,account:r.account}),a=new Ls(i,this.browserStorage,e,this.logger,this.performanceClient),s=await i.getAuthCodeUrl({...r,nativeBroker:Ms.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),c=this.getRedirectStartPage(t.redirectStartPage);return this.logger.verbosePii(`Redirect start page: ${c}`),window.addEventListener("pageshow",o),await a.initiateAuthRequest(s,{navigationClient:this.navigationClient,redirectTimeout:this.config.system.redirectNavigationTimeout,redirectStartPage:c,onRedirectNavigate:t.onRedirectNavigate||this.config.auth.onRedirectNavigate})}catch(e){throw e instanceof Ie&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),window.removeEventListener("pageshow",o),this.browserStorage.cleanRequestByState(r.state),e}}async handleRedirectPromise(r="",n){const o=this.initializeServerTelemetryManager(xi.handleRedirectPromise);try{if(!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const[i,a]=this.getRedirectResponse(r||"");if(!i)return this.logger.info("handleRedirectPromise did not detect a response as a result of a redirect. Cleaning temporary cache."),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),"back_forward"!==function(){if("undefined"==typeof window||void 0===window.performance||"function"!=typeof window.performance.getEntriesByType)return;const e=window.performance.getEntriesByType("navigation"),t=e.length?e[0]:void 0;return t?.type}()?n.event.errorCode="no_server_response":this.logger.verbose("Back navigation event detected. Muting no_server_response error"),null;const s=this.browserStorage.getTemporaryCache(bi,!0)||t.EMPTY_STRING,c=Lr.removeHashFromUrl(s);if(c===Lr.removeHashFromUrl(window.location.href)&&this.config.auth.navigateToLoginRequestUrl){this.logger.verbose("Current page is loginRequestUrl, handling response"),s.indexOf("#")>-1&&Ca(s);return await this.handleResponse(i,o)}if(!this.config.auth.navigateToLoginRequestUrl)return this.logger.verbose("NavigateToLoginRequestUrl set to false, handling response"),await this.handleResponse(i,o);if(!ya()||this.config.system.allowRedirectInIframe){this.browserStorage.setTemporaryCache(_i,a,!0);const e={apiId:xi.handleRedirectPromise,timeout:this.config.system.redirectNavigationTimeout,noHistory:!0};let t=!0;if(s&&"null"!==s)this.logger.verbose(`Navigating to loginRequestUrl: ${s}`),t=await this.navigationClient.navigateInternal(s,e);else{const r=Ia();this.browserStorage.setTemporaryCache(bi,r,!0),this.logger.warning("Unable to get valid login request url from cache, redirecting to home page"),t=await this.navigationClient.navigateInternal(r,e)}if(!t)return await this.handleResponse(i,o)}return null}catch(t){throw t instanceof Ie&&(t.setCorrelationId(this.correlationId),o.cacheFailedRequest(t)),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),t}}getRedirectResponse(t){this.logger.verbose("getRedirectResponseHash called");let r=t;r||(r=this.config.auth.OIDCOptions.serverResponseType===_.QUERY?window.location.search:window.location.hash);let n=qr(r);if(n){try{!function(e,t,r){if(!e.state)throw gi(To);const n=rs(t,e.state);if(!n)throw gi(Ao);if(n.interactionType!==r)throw gi(wo)}(n,this.browserCrypto,e.InteractionType.Redirect)}catch(e){return e instanceof Ie&&this.logger.error(`Interaction type validation failed due to ${e.errorCode}: ${e.errorMessage}`),[null,""]}return fa(window),this.logger.verbose("Hash contains known properties, returning response hash"),[n,r]}const o=this.browserStorage.getTemporaryCache(_i,!0);return this.browserStorage.removeItem(this.browserStorage.generateCacheKey(_i)),o&&(n=qr(o),n)?(this.logger.verbose("Hash does not contain known properties, returning cached hash"),[n,o]):[null,""]}async handleResponse(e,t){const r=e.state;if(!r)throw gi(To);const n=this.browserStorage.getCachedRequest(r);if(this.logger.verbose("handleResponse called, retrieved cached request"),e.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw gi(ni);const t=new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,xi.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,e.accountId,this.nativeStorage,n.correlationId),{userRequestState:o}=Gn.parseRequestState(this.browserCrypto,r);return t.acquireToken({...n,state:o,prompt:void 0}).finally((()=>{this.browserStorage.cleanRequestByState(r)}))}const o=this.browserStorage.getCachedAuthority(r);if(!o)throw gi(xo);const i=await An(this.createAuthCodeClient.bind(this),fn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:o});nn.removeThrottle(this.browserStorage,this.config.auth.clientId,n);return new Ls(i,this.browserStorage,n,this.logger,this.performanceClient).handleCodeResponse(e,r)}async logout(t){this.logger.verbose("logoutRedirect called");const r=this.initializeLogoutRequest(t),n=this.initializeServerTelemetryManager(xi.logout);try{this.eventHandler.emitEvent(us.LOGOUT_START,e.InteractionType.Redirect,t),await this.clearCacheOnLogout(r.account);const o={apiId:xi.logout,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},i=await An(this.createAuthCodeClient.bind(this),fn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:t&&t.authority,requestExtraQueryParameters:t?.extraQueryParameters,account:t&&t.account||void 0});if(i.authority.protocolMode===Mr.OIDC)try{i.authority.endSessionEndpoint}catch{if(r.account?.homeAccountId)return this.browserStorage.removeAccount(r.account?.homeAccountId),void this.eventHandler.emitEvent(us.LOGOUT_SUCCESS,e.InteractionType.Redirect,r)}const a=i.getLogoutUri(r);if(this.eventHandler.emitEvent(us.LOGOUT_SUCCESS,e.InteractionType.Redirect,r),!t||"function"!=typeof t.onRedirectNavigate)return this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(a,o);if(!1!==t.onRedirectNavigate(a))return this.logger.verbose("Logout onRedirectNavigate did not return false, navigating"),this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(a,o);this.browserStorage.setInteractionInProgress(!1),this.logger.verbose("Logout onRedirectNavigate returned false, stopping navigation")}catch(t){throw t instanceof Ie&&(t.setCorrelationId(this.correlationId),n.cacheFailedRequest(t)),this.eventHandler.emitEvent(us.LOGOUT_FAILURE,e.InteractionType.Redirect,null,t),this.eventHandler.emitEvent(us.LOGOUT_END,e.InteractionType.Redirect),t}this.eventHandler.emitEvent(us.LOGOUT_END,e.InteractionType.Redirect)}getRedirectStartPage(e){const t=e||window.location.href;return Lr.getAbsoluteUrl(t,Ta())}}async function Hs(e,t,r,n,o){if(t.addQueueMeasurement(fn.SilentHandlerInitiateAuthRequest,n),!e)throw r.info("Navigate url is empty"),gi(yo);return o?An(xs,fn.SilentHandlerLoadFrame,r,t,n)(e,o,t,n):In(Ds,fn.SilentHandlerLoadFrameSync,r,t,n)(e)}async function Bs(e,t,r,n,o,i,a){return n.addQueueMeasurement(fn.SilentHandlerMonitorIframeForHash,i),new Promise(((n,i)=>{t<qa&&o.warning(`system.loadFrameTimeout or system.iframeHashTimeout set to lower (${t}ms) than the default (10000ms). This may result in timeouts.`);const s=window.setTimeout((()=>{window.clearInterval(c),i(gi(_o))}),t),c=window.setInterval((()=>{let t="";const r=e.contentWindow;try{t=r?r.location.href:""}catch(e){}if(!t||"about:blank"===t)return;let o="";r&&(o=a===_.QUERY?r.location.search:r.location.hash),window.clearTimeout(s),window.clearInterval(c),n(o)}),r)})).finally((()=>{In(Ks,fn.RemoveHiddenIframe,o,n,i)(e)}))}function xs(e,t,r,n){return r.addQueueMeasurement(fn.SilentHandlerLoadFrame,n),new Promise(((r,n)=>{const o=Fs();window.setTimeout((()=>{o?(o.src=e,r(o)):n("Unable to load iframe")}),t)}))}function Ds(e){const t=Fs();return t.src=e,t}function Fs(){const e=document.createElement("iframe");return e.className="msalSilentIframe",e.style.visibility="hidden",e.style.position="absolute",e.style.width=e.style.height="0",e.style.border="0",e.setAttribute("sandbox","allow-scripts allow-same-origin allow-forms"),document.body.appendChild(e),e}function Ks(e){document.body===e.parentNode&&document.body.removeChild(e)}class zs extends Is{constructor(e,t,r,n,o,i,a,s,c,l,h){super(e,t,r,n,o,i,s,l,h),this.apiId=a,this.nativeStorage=c}async acquireToken(t){this.performanceClient.addQueueMeasurement(fn.SilentIframeClientAcquireToken,t.correlationId),t.loginHint||t.sid||t.account&&t.account.username||this.logger.warning("No user hint provided. The authorization server may need more information to complete this request.");const r={...t};r.prompt?r.prompt!==R.NONE&&r.prompt!==R.NO_SESSION&&(this.logger.warning(`SilentIframeClient. Replacing invalid prompt ${r.prompt} with ${R.NONE}`),r.prompt=R.NONE):r.prompt=R.NONE;const n=await An(this.initializeAuthorizationRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);_a(n.authority);const o=this.initializeServerTelemetryManager(this.apiId);let i;try{return i=await An(this.createAuthCodeClient.bind(this),fn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,t.correlationId)({serverTelemetryManager:o,requestAuthority:n.authority,requestAzureCloudOptions:n.azureCloudOptions,requestExtraQueryParameters:n.extraQueryParameters,account:n.account}),await An(this.silentTokenHelper.bind(this),fn.SilentIframeClientTokenHelper,this.logger,this.performanceClient,t.correlationId)(i,n)}catch(n){if(n instanceof Ie&&(n.setCorrelationId(this.correlationId),o.cacheFailedRequest(n)),!(i&&n instanceof Ie&&n.errorCode===pi.INVALID_GRANT_ERROR))throw n;this.performanceClient.addFields({retryError:n.errorCode},this.correlationId);const a=await An(this.initializeAuthorizationRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);return await An(this.silentTokenHelper.bind(this),fn.SilentIframeClientTokenHelper,this.logger,this.performanceClient,this.correlationId)(i,a)}}logout(){return Promise.reject(gi(qo))}async silentTokenHelper(e,t){const r=t.correlationId;this.performanceClient.addQueueMeasurement(fn.SilentIframeClientTokenHelper,r);const n=await An(this.initializeAuthorizationCodeRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,r)(t),o=await An(e.getAuthCodeUrl.bind(e),fn.GetAuthCodeUrl,this.logger,this.performanceClient,r)({...t,nativeBroker:Ms.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),i=new Ns(e,this.browserStorage,n,this.logger,this.performanceClient),a=await An(Hs,fn.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,r)(o,this.performanceClient,this.logger,r,this.config.system.navigateFrameWait),s=this.config.auth.OIDCOptions.serverResponseType,c=await An(Bs,fn.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,r)(a,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,r,s),l=In(Os,fn.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(c,s,this.logger);if(l.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw gi(ni);const e=new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.apiId,this.performanceClient,this.nativeMessageHandler,l.accountId,this.browserStorage,r),{userRequestState:n}=Gn.parseRequestState(this.browserCrypto,t.state);return An(e.acquireToken.bind(e),fn.NativeInteractionClientAcquireToken,this.logger,this.performanceClient,r)({...t,state:n,prompt:t.prompt||R.NONE})}return An(i.handleCodeResponse.bind(i),fn.HandleCodeResponse,this.logger,this.performanceClient,r)(l,t)}}class Gs extends Is{async acquireToken(e){this.performanceClient.addQueueMeasurement(fn.SilentRefreshClientAcquireToken,e.correlationId);const t=await An(vs,fn.InitializeBaseRequest,this.logger,this.performanceClient,e.correlationId)(e,this.config,this.performanceClient,this.logger),r={...e,...t};e.redirectUri&&(r.redirectUri=this.getRedirectUri(e.redirectUri));const n=this.initializeServerTelemetryManager(xi.acquireTokenSilent_silentFlow),o=await this.createRefreshTokenClient({serverTelemetryManager:n,authorityUrl:r.authority,azureCloudOptions:r.azureCloudOptions,account:r.account});return An(o.acquireTokenByRefreshToken.bind(o),fn.RefreshTokenClientAcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(r).catch((e=>{throw e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e),e}))}logout(){return Promise.reject(gi(qo))}async createRefreshTokenClient(e){const t=await An(this.getClientConfiguration.bind(this),fn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:e.serverTelemetryManager,requestAuthority:e.authorityUrl,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account});return new Xn(t,this.performanceClient)}}class $s{constructor(e,t,r,n){this.isBrowserEnvironment="undefined"!=typeof window,this.config=e,this.storage=t,this.logger=r,this.cryptoObj=n}loadExternalTokens(e,t,r){if(!this.isBrowserEnvironment)throw gi(Ko);const n=t.id_token?kt(t.id_token,Va):void 0,o={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},i=e.authority?new kn(kn.generateAuthority(e.authority,e.azureCloudOptions),this.config.system.networkClient,this.storage,o,this.logger,e.correlationId||ia()):void 0,a=this.loadAccount(e,r.clientInfo||t.client_info||"",n,i),s=this.loadIdToken(t,a.homeAccountId,a.environment,a.realm),c=this.loadAccessToken(e,t,a.homeAccountId,a.environment,a.realm,r),l=this.loadRefreshToken(t,a.homeAccountId,a.environment);return this.generateAuthenticationResult(e,{account:a,idToken:s,accessToken:c,refreshToken:l},n,i)}loadAccount(e,t,r,n){if(this.logger.verbose("TokenCache - loading account"),e.account){const t=Nr.createFromAccountInfo(e.account);return this.storage.setAccount(t),t}if(!n||!t&&!r)throw this.logger.error("TokenCache - if an account is not provided on the request, authority and either clientInfo or idToken must be provided instead."),gi(jo);const o=Nr.generateHomeAccountId(t,n.authorityType,this.logger,this.cryptoObj,r),i=r?.tid,a=Vn(this.storage,n,o,Va,r,t,n.hostnameAndPort,i,void 0,void 0,this.logger);return this.storage.setAccount(a),a}loadIdToken(e,t,r,n){if(!e.id_token)return this.logger.verbose("TokenCache - no id token found in response"),null;this.logger.verbose("TokenCache - loading id token");const o=Pt(t,r,e.id_token,this.config.auth.clientId,n);return this.storage.setIdTokenCredential(o),o}loadAccessToken(e,t,r,n,o,i){if(!t.access_token)return this.logger.verbose("TokenCache - no access token found in response"),null;if(!t.expires_in)return this.logger.error("TokenCache - no expiration set on the access token. Cannot add it to the cache."),null;if(!(t.scope||e.scopes&&e.scopes.length))return this.logger.error("TokenCache - scopes not specified in the request or response. Cannot add token to the cache."),null;this.logger.verbose("TokenCache - loading access token");const a=t.scope?Tr.fromString(t.scope):new Tr(e.scopes),s=i.expiresOn||t.expires_in+(new Date).getTime()/1e3,c=i.extendedExpiresOn||(t.ext_expires_in||t.expires_in)+(new Date).getTime()/1e3,l=Mt(r,n,t.access_token,this.config.auth.clientId,o,a.printScopes(),s,c,Va);return this.storage.setAccessTokenCredential(l),l}loadRefreshToken(e,t,r){if(!e.refresh_token)return this.logger.verbose("TokenCache - no refresh token found in response"),null;this.logger.verbose("TokenCache - loading refresh token");const n=Nt(t,r,e.refresh_token,this.config.auth.clientId,e.foci,void 0,e.refresh_token_expires_in);return this.storage.setRefreshTokenCredential(n),n}generateAuthenticationResult(e,t,r,n){let o,i="",a=[],s=null;t?.accessToken&&(i=t.accessToken.secret,a=Tr.fromString(t.accessToken.target).asArray(),s=new Date(1e3*Number(t.accessToken.expiresOn)),o=new Date(1e3*Number(t.accessToken.extendedExpiresOn)));const c=t.account;return{authority:n?n.canonicalAuthority:"",uniqueId:t.account.localAccountId,tenantId:t.account.realm,scopes:a,account:c.getAccountInfo(),idToken:t.idToken?.secret||"",idTokenClaims:r||{},accessToken:i,fromCache:!0,expiresOn:s,correlationId:e.correlationId||"",requestId:"",extExpiresOn:o,familyId:t.refreshToken?.familyId||"",tokenType:t?.accessToken?.tokenType||"",state:e.state||"",cloudGraphHostName:c.cloudGraphHostName||"",msGraphHost:c.msGraphHost||"",fromNativeBroker:!1}}}class Qs extends Jn{constructor(e){super(e),this.includeRedirectUri=!1}}class Ws extends Is{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,s,c,l),this.apiId=a}async acquireToken(t){if(!t.code)throw gi(Yo);const r=await An(this.initializeAuthorizationRequest.bind(this),fn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(t,e.InteractionType.Silent),n=this.initializeServerTelemetryManager(this.apiId);try{const e={...r,code:t.code},o=await An(this.getClientConfiguration.bind(this),fn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,t.correlationId)({serverTelemetryManager:n,requestAuthority:r.authority,requestAzureCloudOptions:r.azureCloudOptions,requestExtraQueryParameters:r.extraQueryParameters,account:r.account}),i=new Qs(o);this.logger.verbose("Auth code client created");const a=new Ns(i,this.browserStorage,e,this.logger,this.performanceClient);return await An(a.handleCodeResponseFromServer.bind(a),fn.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)({code:t.code,msgraph_host:t.msGraphHost,cloud_graph_host_name:t.cloudGraphHostName,cloud_instance_host_name:t.cloudInstanceHostName},r,!1)}catch(e){throw e instanceof Ie&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}logout(){return Promise.reject(gi(qo))}}function js(e){const t=e?.idTokenClaims;return t?.tfp||t?.acr?"B2C":t?.tid?"9188040d-6c67-4c5b-b112-36a304b66dad"===t?.tid?"MSA":"AAD":void 0}function Vs(e,t){try{Ra(e)}catch(e){throw t.end({success:!1},e),e}}class Ys{constructor(e){this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.initialized=!1,this.logger=this.operatingContext.getLogger(),this.networkClient=this.config.system.networkClient,this.navigationClient=this.config.system.navigationClient,this.redirectResponse=new Map,this.hybridAuthCodeResponses=new Map,this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new Za(this.logger,this.performanceClient):yt,this.eventHandler=new gs(this.logger),this.browserStorage=this.isBrowserEnvironment?new ns(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,En(this.config.auth),this.performanceClient):os(this.config.auth.clientId,this.logger);const t={cacheLocation:Ai.MemoryStorage,temporaryCacheLocation:Ai.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};this.nativeInternalStorage=new ns(this.config.auth.clientId,t,this.browserCrypto,this.logger,void 0,this.performanceClient),this.tokenCache=new $s(this.config,this.browserStorage,this.logger,this.browserCrypto),this.activeSilentTokenRequests=new Map,this.trackPageVisibility=this.trackPageVisibility.bind(this),this.trackPageVisibilityWithMeasurement=this.trackPageVisibilityWithMeasurement.bind(this),this.listeningToStorageEvents=!1,this.handleAccountCacheChange=this.handleAccountCacheChange.bind(this)}static async createController(e,t){const r=new Ys(e);return await r.initialize(t),r}trackPageVisibility(e){e&&(this.logger.info("Perf: Visibility change detected"),this.performanceClient.incrementFields({visibilityChangeCount:1},e))}async initialize(e){if(this.logger.trace("initialize called"),this.initialized)return void this.logger.info("initialize has already been called, exiting early.");if(!this.isBrowserEnvironment)return this.logger.info("in non-browser environment, exiting early."),this.initialized=!0,void this.eventHandler.emitEvent(us.INITIALIZE_END);const t=e?.correlationId||this.getRequestCorrelationId(),r=this.config.system.allowNativeBroker,n=this.performanceClient.startMeasurement(fn.InitializeClientApplication,t);if(this.eventHandler.emitEvent(us.INITIALIZE_START),r)try{this.nativeExtensionProvider=await Ms.createProvider(this.logger,this.config.system.nativeBrokerHandshakeTimeout,this.performanceClient)}catch(e){this.logger.verbose(e)}this.config.cache.claimsBasedCachingEnabled||(this.logger.verbose("Claims-based caching is disabled. Clearing the previous cache with claims"),await An(this.browserStorage.clearTokensAndKeysWithClaims.bind(this.browserStorage),fn.ClearTokensAndKeysWithClaims,this.logger,this.performanceClient,t)(this.performanceClient,t)),this.initialized=!0,this.eventHandler.emitEvent(us.INITIALIZE_END),n.end({allowNativeBroker:r,success:!0})}async handleRedirectPromise(e){if(this.logger.verbose("handleRedirectPromise called"),Ea(this.initialized),this.isBrowserEnvironment){const t=e||"";let r=this.redirectResponse.get(t);return void 0===r?(r=this.handleRedirectPromiseInternal(e),this.redirectResponse.set(t,r),this.logger.verbose("handleRedirectPromise has been called for the first time, storing the promise")):this.logger.verbose("handleRedirectPromise has been called previously, returning the result from the first call"),r}return this.logger.verbose("handleRedirectPromise returns null, not browser environment"),null}async handleRedirectPromiseInternal(t){const r=this.getAllAccounts(),n=this.browserStorage.getCachedNativeRequest(),o=n&&Ms.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider)&&this.nativeExtensionProvider&&!t,i=o?n?.correlationId:this.browserStorage.getTemporaryCache(Oi,!0)||"",a=this.performanceClient.startMeasurement(fn.AcquireTokenRedirect,i);let s;if(this.eventHandler.emitEvent(us.HANDLE_REDIRECT_START,e.InteractionType.Redirect),o&&this.nativeExtensionProvider){this.logger.trace("handleRedirectPromise - acquiring token from native platform");const e=new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,xi.handleRedirectPromise,this.performanceClient,this.nativeExtensionProvider,n.accountId,this.nativeInternalStorage,n.correlationId);s=An(e.handleRedirectPromise.bind(e),fn.HandleNativeRedirectPromiseMeasurement,this.logger,this.performanceClient,a.event.correlationId)(this.performanceClient,a.event.correlationId)}else{this.logger.trace("handleRedirectPromise - acquiring token from web flow");const e=this.createRedirectClient(i);s=An(e.handleRedirectPromise.bind(e),fn.HandleRedirectPromiseMeasurement,this.logger,this.performanceClient,a.event.correlationId)(t,a)}return s.then((t=>{if(t){r.length<this.getAllAccounts().length?(this.eventHandler.emitEvent(us.LOGIN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, login success")):(this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, acquire token success")),a.end({success:!0,accountType:js(t.account)})}else a.event.errorCode?a.end({success:!1}):a.discard();return this.eventHandler.emitEvent(us.HANDLE_REDIRECT_END,e.InteractionType.Redirect),t})).catch((t=>{const n=t;throw r.length>0?this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,n):this.eventHandler.emitEvent(us.LOGIN_FAILURE,e.InteractionType.Redirect,null,n),this.eventHandler.emitEvent(us.HANDLE_REDIRECT_END,e.InteractionType.Redirect),a.end({success:!1},n),t}))}async acquireTokenRedirect(t){const r=this.getRequestCorrelationId(t);this.logger.verbose("acquireTokenRedirect called",r);const n=this.performanceClient.startMeasurement(fn.AcquireTokenPreRedirect,r);n.add({accountType:js(t.account),scenarioId:t.scenarioId});const o=t.onRedirectNavigate;if(o)t.onRedirectNavigate=e=>{const t="function"==typeof o?o(e):void 0;return!1!==t?n.end({success:!0}):n.discard(),t};else{const e=this.config.auth.onRedirectNavigate;this.config.auth.onRedirectNavigate=t=>{const r="function"==typeof e?e(t):void 0;return!1!==r?n.end({success:!0}):n.discard(),r}}const i=this.getAllAccounts().length>0;try{let o;if(ba(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0),i?this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_START,e.InteractionType.Redirect,t):this.eventHandler.emitEvent(us.LOGIN_START,e.InteractionType.Redirect,t),this.nativeExtensionProvider&&this.canUseNative(t)){o=new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,xi.acquireTokenRedirect,this.performanceClient,this.nativeExtensionProvider,this.getNativeAccountId(t),this.nativeInternalStorage,r).acquireTokenRedirect(t,n).catch((e=>{if(e instanceof ks&&Ss(e)){this.nativeExtensionProvider=void 0;return this.createRedirectClient(r).acquireToken(t)}if(e instanceof Fn){this.logger.verbose("acquireTokenRedirect - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createRedirectClient(r).acquireToken(t)}throw this.browserStorage.setInteractionInProgress(!1),e}))}else{o=this.createRedirectClient(r).acquireToken(t)}return await o}catch(t){throw n.end({success:!1},t),i?this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,t):this.eventHandler.emitEvent(us.LOGIN_FAILURE,e.InteractionType.Redirect,null,t),t}}acquireTokenPopup(t){const r=this.getRequestCorrelationId(t),n=this.performanceClient.startMeasurement(fn.AcquireTokenPopup,r);n.add({scenarioId:t.scenarioId,accountType:js(t.account)});try{this.logger.verbose("acquireTokenPopup called",r),Vs(this.initialized,n),this.browserStorage.setInteractionInProgress(!0)}catch(e){return Promise.reject(e)}const o=this.getAllAccounts();let i;if(o.length>0?this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_START,e.InteractionType.Popup,t):this.eventHandler.emitEvent(us.LOGIN_START,e.InteractionType.Popup,t),this.canUseNative(t))i=this.acquireTokenNative({...t,correlationId:r},xi.acquireTokenPopup).then((e=>(this.browserStorage.setInteractionInProgress(!1),n.end({success:!0,isNativeBroker:!0,requestId:e.requestId,accountType:js(e.account)}),e))).catch((e=>{if(e instanceof ks&&Ss(e)){this.nativeExtensionProvider=void 0;return this.createPopupClient(r).acquireToken(t)}if(e instanceof Fn){this.logger.verbose("acquireTokenPopup - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createPopupClient(r).acquireToken(t)}throw this.browserStorage.setInteractionInProgress(!1),e}));else{i=this.createPopupClient(r).acquireToken(t)}return i.then((t=>(o.length<this.getAllAccounts().length?this.eventHandler.emitEvent(us.LOGIN_SUCCESS,e.InteractionType.Popup,t):this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,t),n.end({success:!0,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:js(t.account)}),t))).catch((t=>(o.length>0?this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t):this.eventHandler.emitEvent(us.LOGIN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),Promise.reject(t))))}trackPageVisibilityWithMeasurement(){const e=this.ssoSilentMeasurement||this.acquireTokenByCodeAsyncMeasurement;e&&(this.logger.info("Perf: Visibility change detected in ",e.event.name),e.increment({visibilityChangeCount:1}))}async ssoSilent(t){const r=this.getRequestCorrelationId(t),n={...t,prompt:t.prompt,correlationId:r};let o;if(this.ssoSilentMeasurement=this.performanceClient.startMeasurement(fn.SsoSilent,r),this.ssoSilentMeasurement?.add({scenarioId:t.scenarioId,accountType:js(t.account)}),Vs(this.initialized,this.ssoSilentMeasurement),this.ssoSilentMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),this.logger.verbose("ssoSilent called",r),this.eventHandler.emitEvent(us.SSO_SILENT_START,e.InteractionType.Silent,n),this.canUseNative(n))o=this.acquireTokenNative(n,xi.ssoSilent).catch((e=>{if(e instanceof ks&&Ss(e)){this.nativeExtensionProvider=void 0;return this.createSilentIframeClient(n.correlationId).acquireToken(n)}throw e}));else{o=this.createSilentIframeClient(n.correlationId).acquireToken(n)}return o.then((t=>(this.eventHandler.emitEvent(us.SSO_SILENT_SUCCESS,e.InteractionType.Silent,t),this.ssoSilentMeasurement?.end({success:!0,isNativeBroker:t.fromNativeBroker,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:js(t.account)}),t))).catch((t=>{throw this.eventHandler.emitEvent(us.SSO_SILENT_FAILURE,e.InteractionType.Silent,null,t),this.ssoSilentMeasurement?.end({success:!1},t),t})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenByCode(t){const r=this.getRequestCorrelationId(t);this.logger.trace("acquireTokenByCode called",r);const n=this.performanceClient.startMeasurement(fn.AcquireTokenByCode,r);Vs(this.initialized,n),this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_BY_CODE_START,e.InteractionType.Silent,t),n.add({scenarioId:t.scenarioId});try{if(t.code&&t.nativeAccountId)throw gi(Xo);if(t.code){const o=t.code;let i=this.hybridAuthCodeResponses.get(o);return i?(this.logger.verbose("Existing acquireTokenByCode request found",r),n.discard()):(this.logger.verbose("Initiating new acquireTokenByCode request",r),i=this.acquireTokenByCodeAsync({...t,correlationId:r}).then((t=>(this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_BY_CODE_SUCCESS,e.InteractionType.Silent,t),this.hybridAuthCodeResponses.delete(o),n.end({success:!0,isNativeBroker:t.fromNativeBroker,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:js(t.account)}),t))).catch((t=>{throw this.hybridAuthCodeResponses.delete(o),this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t})),this.hybridAuthCodeResponses.set(o,i)),await i}if(t.nativeAccountId){if(this.canUseNative(t,t.nativeAccountId)){const e=await this.acquireTokenNative({...t,correlationId:r},xi.acquireTokenByCode,t.nativeAccountId).catch((e=>{throw e instanceof ks&&Ss(e)&&(this.nativeExtensionProvider=void 0),e}));return n.end({accountType:js(e.account),success:!0}),e}throw gi(ei)}throw gi(Jo)}catch(t){throw this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t}}async acquireTokenByCodeAsync(e){this.logger.trace("acquireTokenByCodeAsync called",e.correlationId),this.acquireTokenByCodeAsyncMeasurement=this.performanceClient.startMeasurement(fn.AcquireTokenByCodeAsync,e.correlationId),this.acquireTokenByCodeAsyncMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement);const t=this.createSilentAuthCodeClient(e.correlationId);return await t.acquireToken(e).then((e=>(this.acquireTokenByCodeAsyncMeasurement?.end({success:!0,fromCache:e.fromCache,isNativeBroker:e.fromNativeBroker,requestId:e.requestId}),e))).catch((e=>{throw this.acquireTokenByCodeAsyncMeasurement?.end({success:!1},e),e})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenFromCache(e,t){switch(this.performanceClient.addQueueMeasurement(fn.AcquireTokenFromCache,e.correlationId),t){case $i.Default:case $i.AccessToken:case $i.AccessTokenAndRefreshToken:const t=this.createSilentCacheClient(e.correlationId);return An(t.acquireToken.bind(t),fn.SilentCacheClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw Ct(tt)}}async acquireTokenByRefreshToken(e,t){switch(this.performanceClient.addQueueMeasurement(fn.AcquireTokenByRefreshToken,e.correlationId),t){case $i.Default:case $i.AccessTokenAndRefreshToken:case $i.RefreshToken:case $i.RefreshTokenAndNetwork:const t=this.createSilentRefreshClient(e.correlationId);return An(t.acquireToken.bind(t),fn.SilentRefreshClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw Ct(tt)}}async acquireTokenBySilentIframe(e){this.performanceClient.addQueueMeasurement(fn.AcquireTokenBySilentIframe,e.correlationId);const t=this.createSilentIframeClient(e.correlationId);return An(t.acquireToken.bind(t),fn.SilentIframeClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e)}async logout(e){const t=this.getRequestCorrelationId(e);return this.logger.warning("logout API is deprecated and will be removed in msal-browser v3.0.0. Use logoutRedirect instead.",t),this.logoutRedirect({correlationId:t,...e})}async logoutRedirect(e){const t=this.getRequestCorrelationId(e);ba(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0);return this.createRedirectClient(t).logout(e)}logoutPopup(e){try{const t=this.getRequestCorrelationId(e);Ra(this.initialized),this.browserStorage.setInteractionInProgress(!0);return this.createPopupClient(t).logout(e)}catch(e){return Promise.reject(e)}}async clearCache(e){if(!this.isBrowserEnvironment)return void this.logger.info("in non-browser environment, returning early.");const t=this.getRequestCorrelationId(e);return this.createSilentCacheClient(t).logout(e)}getAllAccounts(e){return is(this.logger,this.browserStorage,this.isBrowserEnvironment,e)}getAccount(e){return as(e,this.logger,this.browserStorage)}getAccountByUsername(e){return ss(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return cs(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return ls(e,this.logger,this.browserStorage)}setActiveAccount(e){hs(e,this.browserStorage)}getActiveAccount(){return ds(this.browserStorage)}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=Nr.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return this.browserStorage.setAccount(r),e.fromNativeBroker?(this.logger.verbose("Response was from native broker, storing in-memory"),this.nativeInternalStorage.hydrateCache(e,t)):this.browserStorage.hydrateCache(e,t)}async acquireTokenNative(e,t,r){if(this.logger.trace("acquireTokenNative called"),!this.nativeExtensionProvider)throw gi(ni);return new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,t,this.performanceClient,this.nativeExtensionProvider,r||this.getNativeAccountId(e),this.nativeInternalStorage,e.correlationId).acquireToken(e)}canUseNative(e,t){if(this.logger.trace("canUseNative called"),!Ms.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,e.authenticationScheme))return this.logger.trace("canUseNative: isNativeAvailable returned false, returning false"),!1;if(e.prompt)switch(e.prompt){case R.NONE:case R.CONSENT:case R.LOGIN:this.logger.trace("canUseNative: prompt is compatible with native flow");break;default:return this.logger.trace(`canUseNative: prompt = ${e.prompt} is not compatible with native flow, returning false`),!1}return!(!t&&!this.getNativeAccountId(e))||(this.logger.trace("canUseNative: nativeAccountId is not available, returning false"),!1)}getNativeAccountId(e){const t=e.account||this.getAccount({loginHint:e.loginHint,sid:e.sid})||this.getActiveAccount();return t&&t.nativeAccountId||""}createPopupClient(e){return new qs(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createRedirectClient(e){return new Us(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentIframeClient(e){return new zs(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,xi.ssoSilent,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentCacheClient(e){return new Rs(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentRefreshClient(e){return new Gs(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentAuthCodeClient(e){return new Ws(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,xi.acquireTokenByCode,this.performanceClient,this.nativeExtensionProvider,e)}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return Sa(),this.performanceClient.addPerformanceCallback(e)}removePerformanceCallback(e){return this.performanceClient.removePerformanceCallback(e)}enableAccountStorageEvents(){"undefined"!=typeof window&&(this.listeningToStorageEvents?this.logger.verbose("Account storage listener already registered."):(this.logger.verbose("Adding account storage listener."),this.listeningToStorageEvents=!0,window.addEventListener("storage",this.handleAccountCacheChange)))}disableAccountStorageEvents(){"undefined"!=typeof window&&(this.listeningToStorageEvents?(this.logger.verbose("Removing account storage listener."),window.removeEventListener("storage",this.handleAccountCacheChange),this.listeningToStorageEvents=!1):this.logger.verbose("No account storage listener registered."))}handleAccountCacheChange(e){try{e.key?.includes(I)&&this.eventHandler.emitEvent(us.ACTIVE_ACCOUNT_CHANGED);const t=e.newValue||e.oldValue;if(!t)return;const r=JSON.parse(t);if("object"!=typeof r||!Nr.isAccountEntity(r))return;const n=$r.toObject(new Nr,r).getAccountInfo();!e.oldValue&&e.newValue?(this.logger.info("Account was added to cache in a different window"),this.eventHandler.emitEvent(us.ACCOUNT_ADDED,void 0,n)):!e.newValue&&e.oldValue&&(this.logger.info("Account was removed from cache in a different window"),this.eventHandler.emitEvent(us.ACCOUNT_REMOVED,void 0,n))}catch(e){return}}getTokenCache(){return this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){this.navigationClient=e}getConfiguration(){return this.config}getPerformanceClient(){return this.performanceClient}isBrowserEnv(){return this.isBrowserEnvironment}getRequestCorrelationId(e){return e?.correlationId?e.correlationId:this.isBrowserEnvironment?ia():t.EMPTY_STRING}async loginRedirect(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginRedirect called",t),this.acquireTokenRedirect({correlationId:t,...e||Ki})}loginPopup(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginPopup called",t),this.acquireTokenPopup({correlationId:t,...e||Ki})}async acquireTokenSilent(e){const r=this.getRequestCorrelationId(e),n=this.performanceClient.startMeasurement(fn.AcquireTokenSilent,r);n.add({cacheLookupPolicy:e.cacheLookupPolicy,scenarioId:e.scenarioId}),Vs(this.initialized,n),this.logger.verbose("acquireTokenSilent called",r);const o=e.account||this.getActiveAccount();if(!o)throw gi(Lo);n.add({accountType:js(o)});const i={clientId:this.config.auth.clientId,authority:e.authority||t.EMPTY_STRING,scopes:e.scopes,homeAccountIdentifier:o.homeAccountId,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid,shrOptions:e.shrOptions},a=JSON.stringify(i),s=this.activeSilentTokenRequests.get(a);if(void 0===s){this.logger.verbose("acquireTokenSilent called for the first time, storing active request",r);const t=An(this.acquireTokenSilentAsync.bind(this),fn.AcquireTokenSilentAsync,this.logger,this.performanceClient,r)({...e,correlationId:r},o).then((t=>(this.activeSilentTokenRequests.delete(a),n.end({success:!0,fromCache:t.fromCache,isNativeBroker:t.fromNativeBroker,cacheLookupPolicy:e.cacheLookupPolicy,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length}),t))).catch((e=>{throw this.activeSilentTokenRequests.delete(a),n.end({success:!1},e),e}));return this.activeSilentTokenRequests.set(a,t),{...await t,state:e.state}}return this.logger.verbose("acquireTokenSilent has been called previously, returning the result from the first call",r),n.discard(),{...await s,state:e.state}}async acquireTokenSilentAsync(t,r){const n=()=>this.trackPageVisibility(t.correlationId);this.performanceClient.addQueueMeasurement(fn.AcquireTokenSilentAsync,t.correlationId),this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_START,e.InteractionType.Silent,t),t.correlationId&&this.performanceClient.incrementFields({visibilityChangeCount:0},t.correlationId),document.addEventListener("visibilitychange",n);const o=await An(Ts,fn.InitializeSilentRequest,this.logger,this.performanceClient,t.correlationId)(t,r,this.config,this.performanceClient,this.logger),i=t.cacheLookupPolicy||$i.Default;return this.acquireTokenSilentNoIframe(o,i).catch((async e=>{const t=function(e,t){const r=!(e instanceof Fn&&e.subError!==Ln),n=e.errorCode===pi.INVALID_GRANT_ERROR||e.errorCode===tt,o=r&&n||e.errorCode===_n||e.errorCode===Mn,i=Qi.includes(t);return o&&i}(e,i);if(t){if(this.activeIframeRequest){if(i!==$i.Skip){const[t,r]=this.activeIframeRequest;this.logger.verbose(`Iframe request is already in progress, awaiting resolution for request with correlationId: ${r}`,o.correlationId);const n=this.performanceClient.startMeasurement(fn.AwaitConcurrentIframe,o.correlationId);n.add({awaitIframeCorrelationId:r});const a=await t;if(n.end({success:a}),a)return this.logger.verbose(`Parallel iframe request with correlationId: ${r} succeeded. Retrying cache and/or RT redemption`,o.correlationId),this.acquireTokenSilentNoIframe(o,i);throw this.logger.info(`Iframe request with correlationId: ${r} failed. Interaction is required.`),e}return this.logger.warning("Another iframe request is currently in progress and CacheLookupPolicy is set to Skip. This may result in degraded performance and/or reliability for both calls. Please consider changing the CacheLookupPolicy to take advantage of request queuing and token cache.",o.correlationId),An(this.acquireTokenBySilentIframe.bind(this),fn.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o)}{let e;return this.activeIframeRequest=[new Promise((t=>{e=t})),o.correlationId],this.logger.verbose("Refresh token expired/invalid or CacheLookupPolicy is set to Skip, attempting acquire token by iframe.",o.correlationId),An(this.acquireTokenBySilentIframe.bind(this),fn.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o).then((t=>(e(!0),t))).catch((t=>{throw e(!1),t})).finally((()=>{this.activeIframeRequest=void 0}))}}throw e})).then((r=>(this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,r),t.correlationId&&this.performanceClient.addFields({fromCache:r.fromCache,isNativeBroker:r.fromNativeBroker,requestId:r.requestId},t.correlationId),r))).catch((t=>{throw this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),t})).finally((()=>{document.removeEventListener("visibilitychange",n)}))}async acquireTokenSilentNoIframe(t,r){return Ms.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,t.authenticationScheme)&&t.account.nativeAccountId?(this.logger.verbose("acquireTokenSilent - attempting to acquire token from native platform"),this.acquireTokenNative(t,xi.acquireTokenSilent_silentFlow).catch((async e=>{if(e instanceof ks&&Ss(e))throw this.logger.verbose("acquireTokenSilent - native platform unavailable, falling back to web flow"),this.nativeExtensionProvider=void 0,Ct(tt);throw e}))):(this.logger.verbose("acquireTokenSilent - attempting to acquire token from web flow"),An(this.acquireTokenFromCache.bind(this),fn.AcquireTokenFromCache,this.logger,this.performanceClient,t.correlationId)(t,r).catch((n=>{if(r===$i.AccessToken)throw n;return this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_NETWORK_START,e.InteractionType.Silent,t),An(this.acquireTokenByRefreshToken.bind(this),fn.AcquireTokenByRefreshToken,this.logger,this.performanceClient,t.correlationId)(t,r)})))}}class Js{constructor(e,t,r,n){this.clientId=e,this.clientCapabilities=t,this.crypto=r,this.logger=n}toNaaTokenRequest(e){let t;t=void 0===e.extraQueryParameters?new Map:new Map(Object.entries(e.extraQueryParameters));const r=(new mn).addClientCapabilitiesToClaims(e.claims,this.clientCapabilities),n=e.scopes||a;return{platformBrokerId:e.account?.homeAccountId,clientId:this.clientId,authority:e.authority,scope:n.join(" "),correlationId:void 0!==e.correlationId?e.correlationId:this.crypto.createNewGuid(),claims:vr.isEmptyObj(r)?void 0:r,state:e.state,authenticationScheme:e.authenticationScheme||W.BEARER,extraParameters:t}}fromNaaTokenResponse(e,t,r){if(!t.token.id_token||!t.token.access_token)throw Ct(Ee);const n=new Date(1e3*(r+(t.token.expires_in||0))),o=kt(t.token.id_token,this.crypto.base64Decode),i=this.fromNaaAccountInfo(t.account,t.token.id_token,o),a=t.token.scope||e.scope;return{authority:t.token.authority||i.environment,uniqueId:i.localAccountId,tenantId:i.tenantId,scopes:a.split(" "),account:i,idToken:t.token.id_token,idTokenClaims:o,accessToken:t.token.access_token,fromCache:!1,expiresOn:n,tokenType:e.authenticationScheme||W.BEARER,correlationId:e.correlationId,extExpiresOn:n,state:e.state}}fromNaaAccountInfo(e,t,r){const n=r||e.idTokenClaims,o=e.localAccountId||n?.oid||n?.sub||"",i=e.tenantId||n?.tid||"",a=e.homeAccountId||`${o}.${i}`,s=e.username||n?.preferred_username||"",c=e.name||n?.name,l=new Map,h=kr(a,o,i,n);l.set(i,h);return{homeAccountId:a,environment:e.environment,tenantId:i,username:s,localAccountId:o,name:c,idToken:t,idTokenClaims:n,tenantProfiles:l}}fromBridgeError(e){if(!function(e){return void 0!==e.status}(e))return new Ie("unknown_error","An unknown error occurred");switch(e.status){case xa:return new ft(lt);case Da:return new ft(ct);case Ga:return new ft(Ye);case za:return new ft(ut);case $a:return new ft(e.code||ut,e.description);case Fa:case Ka:return new rn(e.code,e.description);case Ba:return new Fn(e.code,e.description);default:return new Ie(e.code,e.description)}}toAuthenticationResultFromCache(e,t,r,n,o){if(!t||!r)throw Ct(Ee);const i=kt(t.secret,this.crypto.base64Decode),a=r.target||n.scopes.join(" ");return{authority:r.environment||e.environment,uniqueId:e.localAccountId,tenantId:e.tenantId,scopes:a.split(" "),account:e,idToken:t.secret,idTokenClaims:i||{},accessToken:r.secret,fromCache:!0,expiresOn:new Date(1e3*Number(r.expiresOn)),tokenType:n.authenticationScheme||W.BEARER,correlationId:o,extExpiresOn:new Date(1e3*Number(r.extendedExpiresOn)),state:n.state}}}const Xs={code:"unsupported_method",desc:"This method is not supported in nested app environment."};class Zs extends Ie{constructor(e,t){super(e,t),Object.setPrototypeOf(this,Zs.prototype),this.name="NestedAppAuthError"}static createUnsupportedError(){return new Zs(Xs.code,Xs.desc)}}class ec{constructor(e){this.operatingContext=e;const t=this.operatingContext.getBridgeProxy();if(void 0===t)throw new Error("unexpected: bridgeProxy is undefined");this.bridgeProxy=t,this.config=e.getConfig(),this.logger=this.operatingContext.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=e.isBrowserEnvironment()?new Za(this.logger,this.performanceClient):yt,this.browserStorage=this.operatingContext.isBrowserEnvironment()?new ns(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,En(this.config.auth)):os(this.config.auth.clientId,this.logger),this.eventHandler=new gs(this.logger),this.nestedAppAuthAdapter=new Js(this.config.auth.clientId,this.config.auth.clientCapabilities,this.browserCrypto,this.logger);const r=this.bridgeProxy.getAccountContext();if(r){hs(as(r,this.logger,this.browserStorage),this.browserStorage)}}static async createController(e){const t=new ec(e);return Promise.resolve(t)}initialize(){return Promise.resolve()}ensureValidRequest(e){return e?.correlationId?e:{...e,correlationId:this.browserCrypto.createNewGuid()}}async acquireTokenInteractive(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_START,e.InteractionType.Popup,r);const n=this.performanceClient.startMeasurement(fn.AcquireTokenPopup,r.correlationId);n?.add({nestedAppAuthRequest:!0});try{const o=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=Et(),a=await this.bridgeProxy.getTokenInteractive(o),s={...this.nestedAppAuthAdapter.fromNaaTokenResponse(o,a,i)};return await this.hydrateCache(s,t),this.browserStorage.setActiveAccount(s.account),this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,s),n.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),n.end({success:!0,requestId:s.requestId}),s}catch(t){const r=this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),r}}async acquireTokenSilentInternal(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_START,e.InteractionType.Silent,r);const n=await this.acquireTokenFromCache(r);if(n)return this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),n;const o=this.performanceClient.startMeasurement(fn.SsoSilent,r.correlationId);o?.increment({visibilityChangeCount:0}),o?.add({nestedAppAuthRequest:!0});try{const n=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=Et(),a=await this.bridgeProxy.getTokenSilent(n),s=this.nestedAppAuthAdapter.fromNaaTokenResponse(n,a,i);return await this.hydrateCache(s,t),this.browserStorage.setActiveAccount(s.account),this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,s),o?.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),o?.end({success:!0,requestId:s.requestId}),s}catch(t){const r=this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),o?.end({success:!1},t),r}}async acquireTokenFromCache(t){const r=this.performanceClient.startMeasurement(fn.AcquireTokenSilent,t.correlationId);if(r?.add({nestedAppAuthRequest:!0}),t.claims)return this.logger.verbose("Claims are present in the request, skipping cache lookup"),null;let n=null;switch(t.cacheLookupPolicy){case $i.Default:case $i.AccessToken:case $i.AccessTokenAndRefreshToken:n=await this.acquireTokenFromCacheInternal(t);break;default:return null}return n?(this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),r?.add({accessTokenSize:n?.accessToken.length,idTokenSize:n?.idToken.length}),r?.end({success:!0}),n):(this.logger.error("Cached tokens are not found for the account, proceeding with silent token request."),this.eventHandler.emitEvent(us.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null),r?.end({success:!1}),null)}async acquireTokenFromCacheInternal(e){const t=this.bridgeProxy.getAccountContext();let r=null;if(t){r=as(t,this.logger,this.browserStorage)||e.account}if(!r)return this.logger.verbose("No active account found, falling back to the host"),Promise.resolve(null);this.logger.verbose("active account found, attempting to acquire token silently");const n={...e,correlationId:e.correlationId||this.browserCrypto.createNewGuid(),authority:e.authority||r.environment,scopes:e.scopes?.length?e.scopes:[...a]},o=this.browserStorage.getTokenKeys(),i=this.browserStorage.getAccessToken(r,n,o,r.tenantId,this.performanceClient,n.correlationId);if(!i)return this.logger.verbose("No cached access token found"),Promise.resolve(null);if(bt(i.cachedAt)||Rt(i.expiresOn,this.config.system.tokenRenewalOffsetSeconds))return this.logger.verbose("Cached access token has expired"),Promise.resolve(null);const s=this.browserStorage.getIdToken(r,o,r.tenantId,this.performanceClient,n.correlationId);return s?this.nestedAppAuthAdapter.toAuthenticationResultFromCache(r,s,i,n,n.correlationId):(this.logger.verbose("No cached id token found"),Promise.resolve(null))}async acquireTokenPopup(e){return this.acquireTokenInteractive(e)}acquireTokenRedirect(e){throw Zs.createUnsupportedError()}async acquireTokenSilent(e){return this.acquireTokenSilentInternal(e)}acquireTokenByCode(e){throw Zs.createUnsupportedError()}acquireTokenNative(e,t,r){throw Zs.createUnsupportedError()}acquireTokenByRefreshToken(e,t){throw Zs.createUnsupportedError()}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){throw Zs.createUnsupportedError()}removePerformanceCallback(e){throw Zs.createUnsupportedError()}enableAccountStorageEvents(){throw Zs.createUnsupportedError()}disableAccountStorageEvents(){throw Zs.createUnsupportedError()}getAllAccounts(e){return is(this.logger,this.browserStorage,this.isBrowserEnv(),e)}getAccount(e){return as(e,this.logger,this.browserStorage)}getAccountByUsername(e){return ss(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return cs(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return ls(e,this.logger,this.browserStorage)}setActiveAccount(e){return hs(e,this.browserStorage)}getActiveAccount(){return ds(this.browserStorage)}handleRedirectPromise(e){return Promise.resolve(null)}loginPopup(e){return this.acquireTokenInteractive(e||Ki)}loginRedirect(e){throw Zs.createUnsupportedError()}logout(e){throw Zs.createUnsupportedError()}logoutRedirect(e){throw Zs.createUnsupportedError()}logoutPopup(e){throw Zs.createUnsupportedError()}ssoSilent(e){return this.acquireTokenSilentInternal(e)}getTokenCache(){throw Zs.createUnsupportedError()}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){}setNavigationClient(e){this.logger.warning("setNavigationClient is not supported in nested app auth")}getConfiguration(){return this.config}isBrowserEnv(){return this.operatingContext.isBrowserEnvironment()}getBrowserCrypto(){return this.browserCrypto}getPerformanceClient(){throw Zs.createUnsupportedError()}getRedirectResponse(){throw Zs.createUnsupportedError()}async clearCache(e){throw Zs.createUnsupportedError()}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=Nr.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return this.browserStorage.setAccount(r),this.browserStorage.hydrateCache(e,t)}}async function tc(e){const t=new ja(e),r=new Wa(e),n=[t.initialize(),r.initialize()];return await Promise.all(n),r.isAvailable()&&e.auth.supportsNestedAppAuth?ec.createController(r):t.isAvailable()?Ys.createController(t):null}class rc{static async createPublicClientApplication(e){const t=await async function(e,t){const r=new ja(e);return await r.initialize(),Ys.createController(r,t)}(e);return new rc(e,t)}constructor(e,t){this.controller=t||new Ys(new ja(e))}async initialize(e){return this.controller.initialize(e)}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}async function nc(e){const t=new rc(e);return await t.initialize(),t}class oc{constructor(e){this.initialized=!1,this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.logger=e.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new Za(this.logger,this.performanceClient):yt,this.browserStorage=this.isBrowserEnvironment?new ns(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,void 0,this.performanceClient):os(this.config.auth.clientId,this.logger)}getBrowserStorage(){return this.browserStorage}getAccount(e){return null}getAccountByHomeId(e){return null}getAccountByLocalId(e){return null}getAccountByUsername(e){return null}getAllAccounts(){return[]}initialize(){return this.initialized=!0,Promise.resolve()}acquireTokenPopup(e){return Ea(this.initialized),Sa(),{}}acquireTokenRedirect(e){return Ea(this.initialized),Sa(),Promise.resolve()}acquireTokenSilent(e){return Ea(this.initialized),Sa(),{}}acquireTokenByCode(e){return Ea(this.initialized),Sa(),{}}acquireTokenNative(e,t,r){return Ea(this.initialized),Sa(),{}}acquireTokenByRefreshToken(e,t){return Ea(this.initialized),Sa(),{}}addEventCallback(e,t){return null}removeEventCallback(e){}addPerformanceCallback(e){return Ea(this.initialized),Sa(),""}removePerformanceCallback(e){return Ea(this.initialized),Sa(),!0}enableAccountStorageEvents(){Ea(this.initialized),Sa()}disableAccountStorageEvents(){Ea(this.initialized),Sa()}handleRedirectPromise(e){return Ea(this.initialized),Promise.resolve(null)}loginPopup(e){return Ea(this.initialized),Sa(),{}}loginRedirect(e){return Ea(this.initialized),Sa(),{}}logout(e){return Ea(this.initialized),Sa(),{}}logoutRedirect(e){return Ea(this.initialized),Sa(),{}}logoutPopup(e){return Ea(this.initialized),Sa(),{}}ssoSilent(e){return Ea(this.initialized),Sa(),{}}getTokenCache(){return Ea(this.initialized),Sa(),{}}getLogger(){return this.logger}setLogger(e){Ea(this.initialized),Sa()}setActiveAccount(e){Ea(this.initialized),Sa()}getActiveAccount(){return Ea(this.initialized),Sa(),null}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){Ea(this.initialized),Sa()}getConfiguration(){return this.config}isBrowserEnv(){return Ea(this.initialized),Sa(),!0}getBrowserCrypto(){return Ea(this.initialized),Sa(),{}}getPerformanceClient(){return Ea(this.initialized),Sa(),{}}getRedirectResponse(){return Ea(this.initialized),Sa(),{}}async clearCache(e){Ea(this.initialized),Sa()}async hydrateCache(e,t){Ea(this.initialized),Sa()}}class ic extends Ha{getId(){return ic.ID}getModuleName(){return ic.MODULE_NAME}async initialize(){return!0}}ic.MODULE_NAME="",ic.ID="UnknownOperatingContext";class ac{static async createPublicClientApplication(e){const t=await tc(e);let r;return r=null!==t?new ac(e,t):new ac(e),r}constructor(e,t){if(this.configuration=e,t)this.controller=t;else{const t=new ic(e);this.controller=new oc(t)}}async initialize(){if(this.controller instanceof oc){const e=await tc(this.configuration);return null!==e&&(this.controller=e),this.controller.initialize()}return Promise.resolve()}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}const sc={initialize:()=>Promise.reject(ma(la)),acquireTokenPopup:()=>Promise.reject(ma(la)),acquireTokenRedirect:()=>Promise.reject(ma(la)),acquireTokenSilent:()=>Promise.reject(ma(la)),acquireTokenByCode:()=>Promise.reject(ma(la)),getAllAccounts:()=>[],getAccount:()=>null,getAccountByHomeId:()=>null,getAccountByUsername:()=>null,getAccountByLocalId:()=>null,handleRedirectPromise:()=>Promise.reject(ma(la)),loginPopup:()=>Promise.reject(ma(la)),loginRedirect:()=>Promise.reject(ma(la)),logout:()=>Promise.reject(ma(la)),logoutRedirect:()=>Promise.reject(ma(la)),logoutPopup:()=>Promise.reject(ma(la)),ssoSilent:()=>Promise.reject(ma(la)),addEventCallback:()=>null,removeEventCallback:()=>{},addPerformanceCallback:()=>"",removePerformanceCallback:()=>!1,enableAccountStorageEvents:()=>{},disableAccountStorageEvents:()=>{},getTokenCache:()=>{throw ma(la)},getLogger:()=>{throw ma(la)},setLogger:()=>{},setActiveAccount:()=>{},getActiveAccount:()=>null,initializeWrapperLibrary:()=>{},setNavigationClient:()=>{},getConfiguration:()=>{throw ma(la)},hydrateCache:()=>Promise.reject(ma(la)),clearCache:()=>Promise.reject(ma(la))};function cc(){let e;try{e=window[Ai.SessionStorage];const t=e?.getItem("msal.browser.performance.enabled");if(1===Number(t))return Promise.resolve().then((function(){return uc}))}catch(e){}}function lc(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.now}function hc(e){if(e&&lc())return Math.round(window.performance.now()-e)}class dc{constructor(e,t){this.correlationId=t,this.measureName=dc.makeMeasureName(e,t),this.startMark=dc.makeStartMark(e,t),this.endMark=dc.makeEndMark(e,t)}static makeMeasureName(e,t){return`msal.measure.${e}.${t}`}static makeStartMark(e,t){return`msal.start.${e}.${t}`}static makeEndMark(e,t){return`msal.end.${e}.${t}`}static supportsBrowserPerformance(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.mark&&"function"==typeof window.performance.measure&&"function"==typeof window.performance.clearMarks&&"function"==typeof window.performance.clearMeasures&&"function"==typeof window.performance.getEntriesByName}static flushMeasurements(e,t){if(dc.supportsBrowserPerformance())try{t.forEach((t=>{const r=dc.makeMeasureName(t.name,e);window.performance.getEntriesByName(r,"measure").length>0&&(window.performance.clearMeasures(r),window.performance.clearMarks(dc.makeStartMark(r,e)),window.performance.clearMarks(dc.makeEndMark(r,e)))}))}catch(e){}}startMeasurement(){if(dc.supportsBrowserPerformance())try{window.performance.mark(this.startMark)}catch(e){}}endMeasurement(){if(dc.supportsBrowserPerformance())try{window.performance.mark(this.endMark),window.performance.measure(this.measureName,this.startMark,this.endMark)}catch(e){}}flushMeasurement(){if(dc.supportsBrowserPerformance())try{const e=window.performance.getEntriesByName(this.measureName,"measure");if(e.length>0){const t=e[0].duration;return window.performance.clearMeasures(this.measureName),window.performance.clearMarks(this.startMark),window.performance.clearMarks(this.endMark),t}}catch(e){}return null}}var uc=Object.freeze({__proto__:null,BrowserPerformanceMeasurement:dc});e.AccountEntity=Nr,e.ApiId=xi,e.AuthError=Ie,e.AuthErrorCodes=ye,e.AuthErrorMessage=Te,e.AuthenticationHeaderParser=class{constructor(e){this.headers=e}getShrNonce(){const e=this.headers[u];if(e){const t=this.parseChallenges(e);if(t.nextnonce)return t.nextnonce;throw yr(hr)}const t=this.headers[d];if(t){const e=this.parseChallenges(t);if(e.nonce)return e.nonce;throw yr(hr)}throw yr(lr)}parseChallenges(e){const r=e.indexOf(" "),n=e.substr(r+1).split(","),o={};return n.forEach((e=>{const[r,n]=e.split("=");o[r]=unescape(n.replace(/['"]+/g,t.EMPTY_STRING))})),o}},e.AuthenticationScheme=W,e.AzureCloudInstance=wt,e.BrowserAuthError=ui,e.BrowserAuthErrorCodes=ci,e.BrowserAuthErrorMessage=di,e.BrowserCacheLocation=Ai,e.BrowserConfigurationAuthError=pa,e.BrowserConfigurationAuthErrorCodes=da,e.BrowserConfigurationAuthErrorMessage=ga,e.BrowserPerformanceClient=class extends mo{constructor(e,r,n){super(e.auth.clientId,e.auth.authority||`${t.DEFAULT_AUTHORITY}`,new Tt(e.system?.loggerOptions||{},La,Ua),La,Ua,e.telemetry?.application||{appName:"",appVersion:""},r,n)}generateId(){return ia()}getPageVisibility(){return document.visibilityState?.toString()||null}deleteIncompleteSubMeasurements(e){cc()?.then((t=>{const r=this.eventsByCorrelationId.get(e.event.correlationId),n=r&&r.eventId===e.event.eventId,o=[];n&&r?.incompleteSubMeasurements&&r.incompleteSubMeasurements.forEach((e=>{o.push({...e})})),t.BrowserPerformanceMeasurement.flushMeasurements(e.event.correlationId,o)}))}startMeasurement(e,t){const r=this.getPageVisibility(),n=super.startMeasurement(e,t),o=lc()?window.performance.now():void 0,i=cc()?.then((t=>new t.BrowserPerformanceMeasurement(e,n.event.correlationId)));return i?.then((e=>e.startMeasurement())),{...n,end:(e,t)=>{const a=n.end({...e,startPageVisibility:r,endPageVisibility:this.getPageVisibility(),durationMs:hc(o)},t);return i?.then((e=>e.endMeasurement())),this.deleteIncompleteSubMeasurements(n),a},discard:()=>{n.discard(),i?.then((e=>e.flushMeasurement())),this.deleteIncompleteSubMeasurements(n)}}}setPreQueueTime(e,t){if(!lc())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to set telemetry queue time for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to set telemetry queue time`);const r=this.preQueueTimeByCorrelationId.get(t);r&&(this.logger.trace(`BrowserPerformanceClient: Incomplete pre-queue ${r.name} found`,t),this.addQueueMeasurement(r.name,t,void 0,!0)),this.preQueueTimeByCorrelationId.set(t,{name:e,time:window.performance.now()})}addQueueMeasurement(e,t,r,n){if(!lc())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to add queue measurement for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to add queue measurement`);const o=super.getPreQueueTime(e,t);if(!o)return;const i=window.performance.now(),a=r||super.calculateQueuedTime(o,i);return super.addQueueMeasurement(e,t,a,n)}},e.BrowserPerformanceMeasurement=dc,e.BrowserStorage=ts,e.BrowserUtils=Ma,e.CacheLookupPolicy=$i,e.ClientAuthError=ft,e.ClientAuthErrorCodes=gt,e.ClientAuthErrorMessage=mt,e.ClientConfigurationError=Cr,e.ClientConfigurationErrorCodes=pr,e.ClientConfigurationErrorMessage=fr,e.DEFAULT_IFRAME_TIMEOUT_MS=qa,e.EventHandler=gs,e.EventMessageUtils=class{static getInteractionStatusFromEvent(t,r){switch(t.eventType){case us.LOGIN_START:return Fi.Login;case us.SSO_SILENT_START:return Fi.SsoSilent;case us.ACQUIRE_TOKEN_START:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup)return Fi.AcquireToken;break;case us.HANDLE_REDIRECT_START:return Fi.HandleRedirect;case us.LOGOUT_START:return Fi.Logout;case us.SSO_SILENT_SUCCESS:case us.SSO_SILENT_FAILURE:if(r&&r!==Fi.SsoSilent)break;return Fi.None;case us.LOGOUT_END:if(r&&r!==Fi.Logout)break;return Fi.None;case us.HANDLE_REDIRECT_END:if(r&&r!==Fi.HandleRedirect)break;return Fi.None;case us.LOGIN_SUCCESS:case us.LOGIN_FAILURE:case us.ACQUIRE_TOKEN_SUCCESS:case us.ACQUIRE_TOKEN_FAILURE:case us.RESTORE_FROM_BFCACHE:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup){if(r&&r!==Fi.Login&&r!==Fi.AcquireToken)break;return Fi.None}}return null}},e.EventType=us,e.InteractionRequiredAuthError=Fn,e.InteractionRequiredAuthErrorCodes=Un,e.InteractionRequiredAuthErrorMessage=Dn,e.InteractionStatus=Fi,e.JsonWebTokenTypes=me,e.Logger=Tt,e.MemoryStorage=Ja,e.NavigationClient=Na,e.OIDC_DEFAULT_SCOPES=a,e.PerformanceEvents=fn,e.PromptValue=R,e.ProtocolMode=Mr,e.PublicClientApplication=rc,e.PublicClientNext=ac,e.ServerError=rn,e.ServerResponseType=_,e.SignedHttpRequest=class{constructor(e,t){const r=t&&t.loggerOptions||{};this.logger=new Tt(r,La,Ua),this.cryptoOps=new Za(this.logger),this.popTokenGenerator=new Qn(this.cryptoOps),this.shrParameters=e}async generatePublicKeyThumbprint(){const{kid:e}=await this.popTokenGenerator.generateKid(this.shrParameters);return e}async signRequest(e,t,r){return this.popTokenGenerator.signPayload(e,t,this.shrParameters,r)}async removeKeys(e){return this.cryptoOps.removeTokenBindingKey(e)}},e.StringUtils=vr,e.StubPerformanceClient=uo,e.UrlString=Lr,e.WrapperSKU={React:"@azure/msal-react",Angular:"@azure/msal-angular"},e.createNestablePublicClientApplication=async function(e){const t=new Wa(e);if(await t.initialize(),t.isAvailable()){const r=new ec(t);return new rc(e,r)}return nc(e)},e.createStandardPublicClientApplication=nc,e.stubbedPublicClientApplication=sc,e.version=Ua}));
