import type { Knex } from 'knex';
import { SchemaHelper, type SortRecord, type Sql } from '../types.js';
export declare class SchemaHelperMSSQL extends SchemaHelper {
    applyLimit(rootQuery: Knex.QueryBuilder, limit: number): void;
    applyOffset(rootQuery: Knex.QueryBuilder, offset: number): void;
    formatUUID(uuid: string): string;
    getDatabaseSize(): Promise<number | null>;
    preprocessBindings(queryParams: Sql): Sql;
    addInnerSortFieldsToGroupBy(groupByFields: (string | Knex.Raw)[], sortRecords: SortRecord[], _hasMultiRelationalSort: boolean): void;
}
