import { fetchDynamicVariableContext } from '../utils/fetch-dynamic-variable-context.js';
import { fetchRawPermissions } from '../utils/fetch-raw-permissions.js';
import { processPermissions } from '../utils/process-permissions.js';
export async function fetchPermissions(options, context) {
    const permissions = await fetchRawPermissions({ ...options, bypassMinimalAppPermissions: options.bypassDynamicVariableProcessing ?? false }, context);
    if (options.accountability && !options.bypassDynamicVariableProcessing) {
        const permissionsContext = await fetchDynamicVariableContext({
            accountability: options.accountability,
            policies: options.policies,
            permissions,
        }, context);
        // Replace dynamic variables with their actual values
        const processedPermissions = processPermissions({
            permissions,
            accountability: options.accountability,
            permissionsContext,
        });
        // TODO merge in permissions coming from the share scope
        return processedPermissions;
    }
    return permissions;
}
