import { useEnv } from '@directus/env';
import { useLogger } from '../logger/index.js';
export function validateEnv(requiredKeys) {
    const env = useEnv();
    const logger = useLogger();
    for (const requiredKey of requiredKeys) {
        if (requiredKey in env === false) {
            logger.error(`"${requiredKey}" Environment Variable is missing.`);
            process.exit(1);
        }
    }
}
