## API Report File for "ip-matching"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export function getIP(input: string | IP): IP | null;

// @public
export function getMatch(input: string | IPMatch): IPMatch;

// @public
export type IP = IPv4 | IPv6;

// @public
export class IPMask extends IPMatch {
    constructor(ip: IP, mask: IP);
    // (undocumented)
    convertToMasks(): IPMask[];
    convertToSubnet(): IPSubnetwork | undefined;
    // (undocumented)
    equals(match: IPMatch): boolean;
    // (undocumented)
    getAmount(): number;
    // (undocumented)
    readonly input: string;
    // (undocumented)
    readonly ip: IP;
    isSubsetOf(mask: IPMask): boolean;
    // (undocumented)
    readonly mask: IP;
    matches(ip: string | IP): boolean;
    toString(): string;
    // (undocumented)
    readonly type = "IPMask";
}

// @public
export abstract class IPMatch {
    // @deprecated
    protected constructor(input: string | null);
    abstract convertToMasks(): IPMask[];
    abstract equals(match: IPMatch): boolean;
    abstract getAmount(): number;
    abstract readonly input: string;
    abstract matches(ip: string | IP): boolean;
    abstract toString(): string;
    abstract readonly type: string;
}

// @public
export class IPRange extends IPMatch {
    constructor(left: IP, right: IP);
    // (undocumented)
    convertToMasks(): IPMask[];
    convertToSubnets(): IPSubnetwork[];
    // (undocumented)
    equals(match: IPMatch): boolean;
    // (undocumented)
    getAmount(): number;
    getFirst(): IP;
    getLast(): IP;
    // (undocumented)
    readonly input: string;
    // (undocumented)
    protected isLowerOrEqual(left: IP, right: IP): boolean;
    // (undocumented)
    readonly left: IP;
    matches(ip: string | IP): boolean;
    // (undocumented)
    readonly right: IP;
    toString(): string;
    // (undocumented)
    readonly type = "IPRange";
}

// @public
export class IPSubnetwork extends IPMatch {
    constructor(ip: IP, bits: number);
    // (undocumented)
    readonly bits: number;
    // (undocumented)
    convertToMasks(): IPMask[];
    // (undocumented)
    equals(match: IPMatch): boolean;
    // (undocumented)
    getAmount(): number;
    getFirst(): IP;
    getLast(): IP;
    // (undocumented)
    readonly input: string;
    matches(ip: string | IP): boolean;
    // (undocumented)
    protected range: IPRange;
    toString(): string;
    // (undocumented)
    readonly type = "IPSubnetwork";
}

// @public
export class IPv4 extends IPMatch {
    constructor(input: string);
    static readonly bits = 32;
    readonly bits = 32;
    // (undocumented)
    convertToMasks(): IPMask[];
    // (undocumented)
    equals(match: IPMatch): boolean;
    exact(): boolean;
    static fromBits(bits: number[]): IPv4;
    // (undocumented)
    getAmount(): number;
    getNext(): IPv4 | undefined;
    getPrevious(): IPv4 | undefined;
    // (undocumented)
    readonly input: string;
    matches(ip: string | IP): boolean;
    // (undocumented)
    readonly parts: number[];
    toBits(): number[];
    toString(): string;
    // (undocumented)
    readonly type = "IPv4";
}

// @public
export class IPv6 extends IPMatch {
    constructor(input: string);
    static readonly bits = 128;
    readonly bits = 128;
    // (undocumented)
    convertToMasks(): IPMask[];
    // (undocumented)
    equals(match: IPMatch): boolean;
    exact(): boolean;
    static fromBits(bits: number[]): IPv6;
    // (undocumented)
    getAmount(): number;
    getNext(): IPv6 | undefined;
    getPrevious(): IPv6 | undefined;
    // (undocumented)
    readonly input: string;
    matches(ip: string | IP): boolean;
    // (undocumented)
    readonly parts: number[];
    toBits(): number[];
    toFullString(): string;
    toHextets(): string[];
    toLongString(): string;
    toMixedString(): string;
    toString(): string;
    // (undocumented)
    readonly type = "IPv6";
}

// @public
export function matches(ip: string | IP, target: string | IPMatch): boolean;

// @internal (undocumented)
export function partsToIP(parts: number[]): IP;


```
